/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class DeployedFlowNameChecker {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowNameChecker.class);
    private List<ImportItemInterface> m_objectsToRename;
    private ImportOperationInterface m_handler;
    private Log m_log;
    private MdObjectStore m_store;
    static final int MAXAUTONUMBER = 1000;

    public DeployedFlowNameChecker(ImportOperationInterface handler) {
        this.m_handler = handler;
        this.m_log = this.m_handler.getLogger();
        this.m_store = handler.getStore();
        this.m_objectsToRename = new ArrayList<ImportItemInterface>();
    }

    public int checkForDuplicates(TypeInterface type) throws RemoteException, MdException {
        List flows;
        int rc = 0;
        Map importItems = this.m_handler.getImportItems();
        if (type.getPublicType() == "DeployedFlow" && (flows = (List)importItems.get("DeployedFlow")) != null && flows.size() > 0) {
            rc |= this.checkFlows(flows);
        }
        if (this.m_objectsToRename.size() > 0) {
            this.m_handler.addNameSubstitutions(this.m_objectsToRename);
        }
        return rc;
    }

    private int checkFlows(List<?> flows) {
        int returnCode = 0;
        for (ImportItemInterface importItem : flows) {
            if (importItem.getImportState() != 1) continue;
            String originalName = importItem.getName();
            try {
                boolean renamed = this.checkFlow(importItem, originalName);
                if (!renamed) continue;
                this.m_objectsToRename.add(importItem);
                this.m_log.warn((Object)UtilMisc.getMessage((String)m_bundle.getString("DeployedFlowNameChecker.Rename.fmt"), (Object)originalName, (Object)importItem.getName()));
                returnCode |= 4;
            }
            catch (Exception e) {
                returnCode |= 8;
                this.m_log.error((Object)UtilMisc.getMessage((String)m_bundle.getString("DeployedFlowNameChecker.RenameError.fmt"), (Object)originalName));
                if (!this.m_log.isDebugEnabled()) continue;
                this.m_log.debug((Object)"Exception", (Throwable)e);
            }
        }
        return returnCode;
    }

    private boolean checkFlow(ImportItemInterface importItem, String originalName) throws RemoteException, MdException {
        boolean renamed = false;
        boolean objectFound = false;
        for (int index = 0; !objectFound && index < 1000; ++index) {
            if (this.flowExistsInRepository(importItem)) {
                String newName = DeployedFlowNameChecker.generateNewName(originalName, index);
                importItem.rename(newName);
                renamed = true;
                continue;
            }
            objectFound = true;
        }
        return renamed;
    }

    private boolean flowExistsInRepository(ImportItemInterface importItem) throws RemoteException, MdException {
        return MetaUtilities.doesFlowExist((String)importItem.getName(), (MdStore)this.m_store, (String)this.m_handler.getRepositoryID());
    }

    private static String generateNewName(String originalName, int count) {
        int MAXDIGITS = 3;
        if (count < 1000) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumIntegerDigits(3);
            nf.setMinimumIntegerDigits(3);
            String unique = originalName + nf.format(count++);
            return unique;
        }
        return null;
    }
}

