/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StatefulServiceHolderImpl
implements StatefulServiceHolderInterface {
    private Object _statefulService;
    private StatefulServiceHolderInterface.ServicePair _root;
    private final Map<String, StatefulServiceHolderInterface> _childMap = new HashMap<String, StatefulServiceHolderInterface>();

    @Override
    public Object getStatefulService() {
        return this._statefulService;
    }

    @Override
    public void setStatefulService(Object statefulService) {
        this._statefulService = statefulService;
    }

    @Override
    public void removeStatefulServiceFromScope() {
    }

    @Override
    public void addChild(String childId, StatefulServiceHolderInterface child) {
        if (this._root != null) {
            throw new IllegalStateException("can only add child to the root of a stateful service hierarchy");
        }
        this._childMap.put(childId, child);
    }

    @Override
    public void removeChild(String childId) {
        this._childMap.remove(childId);
    }

    @Override
    public Set<StatefulServiceHolderInterface.ServicePair> getChildren() {
        HashSet<StatefulServiceHolderInterface.ServicePair> childSet = new HashSet<StatefulServiceHolderInterface.ServicePair>();
        Set<Map.Entry<String, StatefulServiceHolderInterface>> childEntrySet = this._childMap.entrySet();
        for (Map.Entry<String, StatefulServiceHolderInterface> childEntry : childEntrySet) {
            String childId = childEntry.getKey();
            StatefulServiceHolderInterface child = childEntry.getValue();
            ServicePairImpl childPair = new ServicePairImpl(childId, child);
            childSet.add(childPair);
        }
        return childSet;
    }

    @Override
    public void setRoot(String rootId, StatefulServiceHolderInterface root) {
        if (!this._childMap.isEmpty()) {
            throw new IllegalStateException("cannot set root on the root of a stateful service hierarchy");
        }
        this._root = new ServicePairImpl(rootId, root);
    }

    @Override
    public StatefulServiceHolderInterface.ServicePair getRoot() {
        return this._root;
    }

    @Override
    public void clearRoot() {
        this._root = null;
    }

    private static final class ServicePairImpl
    implements StatefulServiceHolderInterface.ServicePair {
        private final String _id;
        private final StatefulServiceHolderInterface _service;

        private ServicePairImpl(String id, StatefulServiceHolderInterface service) {
            this._id = id;
            this._service = service;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public StatefulServiceHolderInterface getService() {
            return this._service;
        }
    }
}

