/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker.stateful;

import com.sas.svcs.remoting.MutableRemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceHolderInterface;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ServerRemoteInvocationStatefulServiceResultProxyProcessor
implements RemoteInvocationResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ServerRemoteInvocationStatefulServiceResultProxyProcessor.class);
    private Map<String, Object> _returnsStatefulMethodsMap;
    private StatefulServiceHolderInterface _serviceHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(RemoteInvocationResult rir) {
        SecurityContext springContext;
        if (!(rir instanceof MutableRemoteInvocationAttributeResult) || this._returnsStatefulMethodsMap == null || this._returnsStatefulMethodsMap.isEmpty() || rir.hasException()) {
            return;
        }
        MutableRemoteInvocationAttributeResult mrir = (MutableRemoteInvocationAttributeResult)rir;
        RemoteInvocation ri = mrir.getRemoteInvocation();
        String methodName = ri.getMethodName();
        Object statefulServiceProxy = this._returnsStatefulMethodsMap.get(methodName);
        if (statefulServiceProxy == null) {
            return;
        }
        if (statefulServiceProxy.equals("")) {
            statefulServiceProxy = mrir.getService();
        }
        Object statefulService = mrir.getValue();
        boolean changedSpringContext = false;
        if ((SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null) && null != (springContext = (SecurityContext)ri.getAttribute(SecurityContextHolder.class.getName())) && null != springContext.getAuthentication()) {
            SecurityContextHolder.setContext((SecurityContext)springContext);
            changedSpringContext = true;
        }
        try {
            ((StatefulServiceHolderInterface)statefulServiceProxy).setStatefulService(statefulService);
        }
        finally {
            if (changedSpringContext) {
                SecurityContextHolder.clearContext();
            }
        }
        mrir.setValue(statefulServiceProxy);
        if (this._serviceHolder != null) {
            String childId = StatefulServiceResultIdHolder.getId();
            String parentId = (String)((Object)ri.getAttribute("sasStatefulServiceId"));
            String rootId = null;
            StatefulServiceHolderInterface root = null;
            StatefulServiceIdHolder.setId(parentId);
            try {
                StatefulServiceHolderInterface.ServicePair rootPair = this._serviceHolder.getRoot();
                if (rootPair != null) {
                    rootId = rootPair.getId();
                    root = rootPair.getService();
                } else {
                    rootId = parentId;
                    root = this._serviceHolder;
                }
            }
            finally {
                StatefulServiceIdHolder.clear();
            }
            StatefulServiceIdHolder.setId(childId);
            try {
                ((StatefulServiceHolderInterface)statefulServiceProxy).setRoot(rootId, root);
            }
            finally {
                StatefulServiceIdHolder.clear();
            }
            StatefulServiceIdHolder.setId(rootId);
            try {
                root.addChild(childId, (StatefulServiceHolderInterface)statefulServiceProxy);
            }
            finally {
                StatefulServiceIdHolder.clear();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("inserting stateful service proxy for result of " + methodName);
        }
    }

    public void setReturnsStatefulMethodsMap(Map<String, Object> returnsStatefulMethodsMap) {
        this._returnsStatefulMethodsMap = returnsStatefulMethodsMap;
    }

    public void setServiceHolder(StatefulServiceHolderInterface serviceHolder) {
        this._serviceHolder = serviceHolder;
    }
}

