/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.httpinvoker;

import com.sas.svcs.remoting.MutableRemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationProcessor;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class PostProcessingHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    private static final Logger LOGGER = LogManager.getLogger(PostProcessingHttpInvokerServiceExporter.class);
    private List preProcessors = new ArrayList();
    private List postProcessors = new ArrayList();

    public void setPreProcessors(List preProcessors) {
        this.preProcessors = preProcessors;
        Iterator it = preProcessors.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof RemoteInvocationProcessor) continue;
            it.remove();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Removing invalid object from collaboration list, " + next);
        }
    }

    public void setPostProcessors(List c) {
        this.postProcessors = c;
        Iterator it = this.postProcessors.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof RemoteInvocationResultProcessor) continue;
            it.remove();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Removing invalid object from collaboration list, " + next);
        }
    }

    protected RemoteInvocationResult invokeAndCreateResult(RemoteInvocation ri, Object target) {
        if (this.preProcessors != null && !this.preProcessors.isEmpty()) {
            for (RemoteInvocationProcessor riv : this.preProcessors) {
                riv.process(ri);
            }
        }
        RemoteInvocationResult rir = super.invokeAndCreateResult(ri, target);
        if (this.preProcessors != null && !this.preProcessors.isEmpty()) {
            for (RemoteInvocationProcessor riv : this.preProcessors) {
                riv.finish(ri);
            }
        }
        if (this.postProcessors.isEmpty()) {
            return rir;
        }
        Object service = this.getService();
        MutableRemoteInvocationAttributeResult mriar = new MutableRemoteInvocationAttributeResult(ri, service, rir);
        for (RemoteInvocationResultProcessor rirv : this.postProcessors) {
            rirv.process(mriar);
        }
        RemoteInvocationAttributeResult riar = mriar.toRemoteInvocationAttributeResult();
        return riar;
    }
}

