/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.remoting.client.CreateSocketsFactory;
import com.sas.svcs.remoting.client.SocketFactoryHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SocketFactory
extends PlainConnectionSocketFactory
implements CreateSocketsFactory {
    public static final SocketFactory INSTANCE = new SocketFactory();
    private static final Logger LOGGER = LogManager.getLogger(SocketFactory.class);

    private SocketFactory() {
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return SocketFactoryHelper.decorate(new Socket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createSocket(" + host + "," + port + "," + localAddress + "," + localPort + ")");
        }
        Socket socket = new Socket(host, port);
        if (localAddress != null && localPort > 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        return SocketFactoryHelper.decorate(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, int connectTimeout) throws IOException, UnknownHostException {
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(host, port);
        InetSocketAddress localSocketAddress = new InetSocketAddress(localAddress, localPort);
        HttpCoreContext httpCoreContext = new HttpCoreContext();
        HttpHost httpHost = new HttpHost(host, port);
        httpCoreContext.setTargetHost(httpHost);
        return SocketFactoryHelper.decorate(super.connectSocket(connectTimeout, null, httpHost, remoteSocketAddress, localSocketAddress, (HttpContext)httpCoreContext));
    }
}

