/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.remoting.client.SASClientHttpServiceProxy;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulProxyFactory;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SASClientCreatesStatefulHttpServiceProxy
extends SASClientHttpServiceProxy {
    private static final Logger LOGGER = LogManager.getLogger(SASClientCreatesStatefulHttpServiceProxy.class);
    private Map<String, Object> returnsStatefulMethodsMap = new HashMap<String, Object>(1);

    public SASClientCreatesStatefulHttpServiceProxy() {
    }

    public SASClientCreatesStatefulHttpServiceProxy(ServiceRegistryInterface r) {
        super(r);
    }

    public SASClientCreatesStatefulHttpServiceProxy(ServiceRegistryInterface r, Class<?> k) {
        super(r, k);
    }

    public void setReturnsStatefulMethodsMap(Map<String, Object> returnsStatefulMethodsMap) {
        this.returnsStatefulMethodsMap = returnsStatefulMethodsMap;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Service returns stateful services");
        }
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object result = super.invoke(mi);
        if (this.returnsStatefulMethodsMap.containsKey(mi.getMethod().getName())) {
            Object statefulObj = this.returnsStatefulMethodsMap.get(mi.getMethod().getName());
            if (statefulObj.equals("")) {
                statefulObj = this.getObject();
            }
            Class<?> statefulClass = mi.getMethod().getReturnType();
            return StatefulProxyFactory.getProxy(statefulObj, statefulClass, this.useInterfaceClassLoader);
        }
        return result;
    }
}

