/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.remoting.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostConfigProxyResolver {
    private static final Logger LOGGER = LogManager.getLogger(HostConfigProxyResolver.class);
    protected ProxySelector proxySelector = ProxySelector.getDefault();
    protected ConcurrentMap<Proxy, HttpHost> proxyToHostMap = new ConcurrentHashMap<Proxy, HttpHost>(2);

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    public HttpHost getHttpHostForUri(URI uri) {
        HttpHost httpHost = null;
        List<Proxy> proxies = this.proxySelector.select(uri);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Proxy selector returned " + proxies.size() + " potential proxies for " + uri);
        }
        for (Proxy proxy : proxies) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing potential proxy " + proxy.toString() + " for " + uri);
            }
            if (!Proxy.Type.HTTP.equals((Object)proxy.type()) || !(proxy.address() instanceof InetSocketAddress)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found proxy match for " + uri);
            }
            if (null != (httpHost = (HttpHost)this.proxyToHostMap.get(proxy))) continue;
            String proxyHost = ((InetSocketAddress)proxy.address()).getHostName();
            int proxyPort = ((InetSocketAddress)proxy.address()).getPort();
            httpHost = new HttpHost(proxyHost, proxyPort, proxy.type().name());
            this.proxyToHostMap.putIfAbsent(proxy, httpHost);
            if (!LOGGER.isDebugEnabled()) break;
            LOGGER.debug("Constructed new http host with proxy address " + proxyHost + " and port " + proxyPort);
            break;
        }
        if (null == httpHost) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No http host found for " + uri);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using http host " + httpHost.toString() + " for " + uri);
        }
        return httpHost;
    }
}

