/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.SDSPreSizedInputStream;
import com.sas.app.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Random;

class SDSImageServerConnection {
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final String[] SERVER_NAMES = new String[]{"anvil.unx.sas.com", "yosemite.unx.sas.com"};
    private static int s_nextServerIndex = new Random().nextInt(SERVER_NAMES.length);
    private static final int ImageServerPort = 5070;
    private static final int SOCKET_TIMEOUT = 60000;
    private static final int CONNECT_OK_HEADER = 1399156324;
    private static final int REQUEST_VERSION = 2;
    private static final byte[] REQUEST_USER = new byte[16];
    private static final byte[] REQUEST_EXT = new byte[4];
    static final int R_QUERY = 1;
    static final int R_DIRL = 4;
    private static boolean RUN_DEAD_CODE;
    private Socket m_socket;
    private Reply m_previous;
    private byte[] m_requestBuffer = new byte[8192];

    static synchronized Socket connectSocket() throws IOException {
        int origServerIndexTried = s_nextServerIndex;
        IOException firstException = null;
        Socket rc = null;
        while (true) {
            String server = SERVER_NAMES[s_nextServerIndex];
            if (++s_nextServerIndex >= SERVER_NAMES.length) {
                s_nextServerIndex = 0;
            }
            try {
                Socket s = new Socket(server, 5070);
                SDSImageServerConnection.readOkHeader(s);
                s.setSoTimeout(60000);
                rc = s;
            }
            catch (IOException e) {
                if (firstException != null) continue;
                firstException = e;
                if (s_nextServerIndex != origServerIndexTried) continue;
            }
            break;
        }
        if (rc == null) {
            if (firstException != null) {
                throw firstException;
            }
            assert (false);
            throw new IllegalStateException();
        }
        return rc;
    }

    private static void readOkHeader(Socket s) throws IOException {
        int send = new DataInputStream(s.getInputStream()).readInt();
        if (send != 1399156324) {
            throw new IOException(s + ": connection failed: expected 'Send' header value of 0x" + Integer.toHexString(1399156324) + " to indicate ok to proceed and instead received 0x" + Integer.toHexString(send));
        }
    }

    static SDSImageServerConnection connect() throws IOException {
        return new SDSImageServerConnection(SDSImageServerConnection.connectSocket());
    }

    private static void writeRequest(OutputStream s, String path, byte[] buffer, int flags, long localJavaTime, long localSize) throws IOException {
        int len;
        if (s == null) {
            throw Util.illegalNull("s");
        }
        SDSImageServerConnection.validatePath(path);
        if ((flags & 5) != flags) {
            throw Util.illegalArgument("flags", flags + " = 0x" + Integer.toHexString(flags));
        }
        int min = 41 + path.length();
        if (buffer == null || buffer.length < min) {
            buffer = new byte[min];
        }
        ByteBuffer b = ByteBuffer.wrap(buffer);
        b.putInt(2);
        b.put(REQUEST_USER);
        int timeT = SDSImageServerConnection.time_t(localJavaTime);
        if (SDSImageServerConnection.javaTime(timeT) != localJavaTime || localSize > Integer.MAX_VALUE || localSize < 0L) {
            timeT = 0;
            len = 0;
        } else {
            len = (int)localSize;
        }
        b.putInt(timeT);
        b.putInt(len);
        b.putInt(flags);
        b.put(REQUEST_EXT);
        int n = path.length();
        b.putInt(n + 1);
        for (int i = 0; i < n; ++i) {
            b.put((byte)path.charAt(i));
        }
        b.put((byte)0);
        b.flip();
        s.write(b.array(), b.arrayOffset(), b.remaining());
        s.flush();
    }

    static long javaTime(int time_t) {
        return 1000L * (long)time_t;
    }

    private static int time_t(long javaMillis) {
        long rc = javaMillis / 1000L;
        if (rc < Integer.MIN_VALUE || rc > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of range: " + javaMillis);
        }
        return (int)rc;
    }

    static void validatePath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw Util.illegalNull("path");
        }
        if (path.length() <= 0 || !path.startsWith("/")) {
            throw Util.illegalArgument("path", path);
        }
    }

    static void validateSimpleName(String name) {
        if (name == null) {
            throw Util.illegalNull("name");
        }
        if (name.length() <= 0 || name.indexOf(47) >= 0 || name.indexOf(92) >= 0 || name.indexOf(File.separatorChar) >= 0 || name.startsWith("/") || name.startsWith(File.separator)) {
            throw Util.illegalArgument("name", name);
        }
    }

    SDSImageServerConnection(Socket s) {
        if (s == null) {
            throw Util.illegalNull("s");
        }
        this.m_socket = s;
    }

    private void finishPrevious() {
        Reply previous = this.m_previous;
        this.m_previous = null;
        if (previous != null) {
            previous.finish();
        }
    }

    private byte[] getRequestBufferFor(String path) {
        SDSImageServerConnection.validatePath(path);
        int min = 41 + path.length();
        byte[] rc = this.m_requestBuffer;
        if (rc.length < min) {
            this.m_requestBuffer = rc = new byte[Math.max(rc.length + 1024, min)];
        }
        return rc;
    }

    Reply query(String path) throws IOException {
        return this.requestResponse(path, 1, 0L, 0L);
    }

    Reply list(String path) throws IOException {
        return this.requestResponse(path, 4, 0L, 0L);
    }

    Reply get(String path) throws IOException {
        return this.getIfDifferent(path, 0L, 0L);
    }

    Reply getIfDifferent(String path, long javaTimeModified, long length) throws IOException {
        if (javaTimeModified % 1000L != 0L) {
            javaTimeModified = 0L;
            length = 0L;
        }
        return this.requestResponse(path, 0, javaTimeModified, length);
    }

    private Reply requestResponse(String path, int flags, long localJavaTime, long localSize) throws IOException {
        this.finishPrevious();
        SDSImageServerConnection.writeRequest(this.m_socket.getOutputStream(), path, this.getRequestBufferFor(path), flags, localJavaTime, localSize);
        this.m_previous = Reply.readResponse(this.m_socket.getInputStream(), flags);
        return this.m_previous;
    }

    void close() {
        this.m_previous = null;
        if (this.m_socket.isClosed()) {
            return;
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        if (SERVER_NAMES == null) {
            assert (false);
            throw new IllegalStateException(Util.illegalNull("SERVER_NAMES"));
        }
        if (SERVER_NAMES.length <= 0) {
            assert (false);
            throw new IllegalStateException(Util.illegalArgument("SERVER_NAMES.length", new Integer(SERVER_NAMES.length)));
        }
        RUN_DEAD_CODE = false;
        if (RUN_DEAD_CODE) {
            new Reply(0, 0L, 0L, null);
        }
    }

    static final class Reply {
        private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
        static final int REPL_NOTFND = 1;
        static final int REPL_GOOD = 2;
        static final int REPL_NEW = 4;
        static final int REPL_DIR = 16;
        static final int REPL_NOUSER = 32;
        static final int REPL_NULL = 64;
        static final int REPL_DIRL = 512;
        private final int m_flags;
        private final long m_javaTime;
        private final long m_imageLength;
        private InputStream m_stream;
        private String[] m_dirListing;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Reply readResponse(InputStream s, int queryFlags) throws IOException {
            if (s == null) {
                throw Util.illegalNull("s");
            }
            DataInputStream dis = new DataInputStream(s);
            int flags = dis.readInt();
            int mtime = dis.readInt();
            long javaTime = SDSImageServerConnection.javaTime(mtime);
            int imagel = dis.readInt();
            if ((queryFlags & 1) == 0) {
                if ((queryFlags & 4) == 4) {
                    if ((flags & 0x200) == 512) {
                        if ((queryFlags & 4) == 0) {
                            assert (false);
                            throw new IllegalStateException();
                        }
                        int len = dis.readInt();
                        long llen = (long)len & 0xFFFFFFFFL;
                        SDSPreSizedInputStream rcs = new SDSPreSizedInputStream(s, llen, true);
                        try {
                            String line;
                            ArrayList<String> list = new ArrayList<String>();
                            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)rcs, US_ASCII));
                            while ((line = r.readLine()) != null) {
                                if ((line = line.trim()).length() <= 0) continue;
                                list.add(line);
                            }
                            Reply reply = new Reply(flags, javaTime, (long)imagel, list.toArray(new String[list.size()]));
                            return reply;
                        }
                        finally {
                            Util.close(rcs);
                        }
                    }
                } else if ((flags & 4) == 4) {
                    long llen = (long)imagel & 0xFFFFFFFFL;
                    return new Reply(flags, javaTime, (long)imagel, new SDSPreSizedInputStream(s, llen, true));
                }
            }
            return new Reply(flags, javaTime, (long)imagel, (InputStream)null);
        }

        private String[] defensiveCopy(String[] strings) {
            if (strings == null) {
                return null;
            }
            if (strings.length <= 0) {
                return strings;
            }
            String[] copy = new String[strings.length];
            System.arraycopy(strings, 0, copy, 0, strings.length);
            return copy;
        }

        private Reply(int flags, long javaTime, long imageLength, InputStream s) {
            if (imageLength < 0L) {
                throw Util.illegalNegative("imageLength", imageLength);
            }
            this.m_flags = flags;
            this.m_javaTime = javaTime;
            this.m_imageLength = imageLength;
            this.m_stream = s;
        }

        private Reply(int flags, long javaTime, long imageLength, String[] listing) {
            if (imageLength < 0L) {
                throw Util.illegalNegative("imageLength", imageLength);
            }
            this.m_flags = flags;
            this.m_javaTime = javaTime;
            this.m_imageLength = imageLength;
            this.m_stream = null;
            this.m_dirListing = listing;
            if (!this.isDirectory() || (this.m_flags & 0x200) == 0) {
                throw Util.illegalArgument("flags", flags + " = " + Integer.toHexString(flags));
            }
        }

        void finish() {
            InputStream s = this.m_stream;
            this.m_stream = null;
            Util.close(s);
        }

        int flags() {
            return this.m_flags;
        }

        boolean exists() {
            return (this.m_flags & 0x16) != 0 && (this.m_flags & 1) == 0 && (this.m_flags & 0x20) == 0 && (this.m_flags & 0x40) == 0;
        }

        boolean isFile() {
            return (this.m_flags & 6) != 0 && (this.m_flags & 1) == 0 && (this.m_flags & 0x20) == 0 && (this.m_flags & 0x40) == 0 && (this.m_flags & 0x10) == 0;
        }

        boolean isDirectory() {
            return (this.m_flags & 0x10) == 16 && (this.m_flags & 1) == 0 && (this.m_flags & 0x20) == 0 && (this.m_flags & 0x40) == 0;
        }

        long lastModified() {
            return this.m_javaTime;
        }

        long length() {
            return this.m_imageLength;
        }

        InputStream getStream() {
            return this.m_stream;
        }

        String[] list() {
            return this.defensiveCopy(this.m_dirListing);
        }
    }
}

