/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

final class IterEnum
implements Enumeration,
Iterator {
    private Iterator m_it;
    private Enumeration m_enum;
    private boolean m_isIt;
    private List m_pending;
    private boolean m_readOnly;

    public IterEnum() {
    }

    public IterEnum(Iterator it) {
        this.m_it = it;
        this.m_isIt = true;
    }

    public IterEnum(Enumeration e) {
        this.m_enum = e;
        this.m_isIt = false;
    }

    public synchronized boolean isReadOnly() {
        return this.m_readOnly;
    }

    public synchronized void setReadOnly() {
        this.m_readOnly = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterator it) {
        if (it == null || !it.hasNext()) {
            return;
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        IterEnum iterEnum = this;
        synchronized (iterEnum) {
            LinkedList<Iterator> list = this.m_pending;
            if (list == null || list.isEmpty()) {
                if ((this.m_isIt ? this.m_it : this.m_enum) == null) {
                    this.m_isIt = true;
                    this.m_it = it;
                    this.m_enum = null;
                    return;
                }
                if (list == null) {
                    this.m_pending = list = new LinkedList<Iterator>();
                }
            }
            list.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Enumeration e) {
        if (e == null || !e.hasMoreElements()) {
            return;
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        IterEnum iterEnum = this;
        synchronized (iterEnum) {
            LinkedList<Enumeration> list = this.m_pending;
            if (list == null || list.isEmpty()) {
                if ((this.m_isIt ? this.m_it : this.m_enum) == null) {
                    this.m_isIt = false;
                    this.m_enum = e;
                    this.m_it = null;
                    return;
                }
                if (list == null) {
                    this.m_pending = list = new LinkedList<Enumeration>();
                }
            }
            list.add(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.m_isIt) {
            Iterator it = this.m_it;
            if (it == null) {
                return false;
            }
            if (it.hasNext()) {
                return true;
            }
            this.m_it = null;
        } else {
            Enumeration e = this.m_enum;
            if (e == null) {
                return false;
            }
            if (e.hasMoreElements()) {
                return true;
            }
            this.m_enum = null;
        }
        return this.advance();
    }

    private boolean advance() {
        List list = this.m_pending;
        while (list != null) {
            Object pending = list.remove(0);
            if (list.isEmpty()) {
                list = null;
                this.m_pending = null;
            }
            if (pending instanceof Iterator) {
                Iterator it = (Iterator)pending;
                if (!it.hasNext()) continue;
                this.m_isIt = true;
                this.m_it = it;
                this.m_enum = null;
                return true;
            }
            Enumeration e = (Enumeration)pending;
            if (!e.hasMoreElements()) continue;
            this.m_isIt = false;
            this.m_enum = e;
            this.m_it = null;
            return true;
        }
        return false;
    }

    public synchronized Object next() throws NoSuchElementException {
        if (this.m_isIt) {
            Iterator it = this.m_it;
            if (it != null) {
                return it.next();
            }
        } else {
            Enumeration e = this.m_enum;
            if (e != null) {
                return e.nextElement();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public synchronized void remove() throws UnsupportedOperationException, IllegalStateException {
        Iterator it;
        if (this.m_isIt) {
            it = this.m_it;
            if (it == null || this.isReadOnly()) {
                throw new IllegalStateException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        it.remove();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }
}

