/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static Logger logger = LogManager.getLogger(XmlHelper.class);
    private Document document;
    private int indent = 4;

    public XmlHelper() {
    }

    public XmlHelper(int indent) {
        this.indent = indent;
    }

    public void parse(File xmlFile) {
        logger.debug("parse() >>>");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        logger.info("DocumentBuilderFactory Class: " + factory.getClass().getName());
        factory.setValidating(false);
        factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            logger.info("DocumentBuilder Class: " + builder.getClass().getName());
            this.document = builder.parse(new FileInputStream(xmlFile));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.debug("parse() <<<");
    }

    public Element createElement(String name) {
        return this.document.createElement(name);
    }

    public Comment createComments(String comments) {
        return this.document.createComment(comments);
    }

    public void insertComment(Element element, Comment comment) {
        element.getParentNode().insertBefore(comment, element);
    }

    public void setAttributes(Element element, Map<String, String> attributes) {
        Set<Map.Entry<String, String>> a = attributes.entrySet();
        for (Map.Entry<String, String> entry : a) {
            element.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Element findNode(String xpath) {
        logger.debug("findNode() >>>");
        logger.info("xpath=${xpath}");
        XPathFactory factory = XPathFactory.newInstance();
        logger.info("XPathFactory Class: " + factory.getClass().getName());
        XPath xPath = factory.newXPath();
        logger.info("XPath Class: " + xPath.getClass().getName());
        Element element = null;
        try {
            element = (Element)xPath.evaluate(xpath, this.document.getDocumentElement(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        logger.debug("findNode() <<<");
        return element;
    }

    public NodeList findNodes(String xpath) {
        logger.debug("findNodes() >>>");
        logger.info("xpath=${xpath}");
        XPathFactory factory = XPathFactory.newInstance();
        logger.info("XPathFactory Class: " + factory.getClass().getName());
        XPath xPath = factory.newXPath();
        logger.info("XPath Class: " + xPath.getClass().getName());
        NodeList list = null;
        try {
            list = (NodeList)xPath.evaluate(xpath, this.document.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        logger.debug("findNodes() <<<");
        return list;
    }

    public void setAttribute(String xpath, String name, String value) {
        NodeList nl = this.findNodes(xpath.toString());
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element element = (Element)nl.item(i);
                element.setAttribute(name, value);
            }
        }
    }

    public boolean nodeExists(String xpath) {
        boolean exists = false;
        Element e = this.findNode(xpath);
        if (e != null) {
            exists = true;
        }
        return exists;
    }

    public void removeNode(Element parent, Element elementToBeRemoved) {
        parent.removeChild(elementToBeRemoved);
    }

    public void findAndRemoveNode(Element parent, String xpath) {
        logger.debug("findAndRemoveNode() >>>");
        logger.info("xpath=${xpath}");
        boolean exists = false;
        Element e = this.findNode(xpath);
        if (e != null) {
            exists = true;
            parent.removeChild(e);
            logger.debug("Removed Node at $xpath");
        }
        logger.debug("findAndRemoveNode() <<<");
    }

    public void appendChildElement(Element parent, Element newElement) {
        parent.appendChild(newElement);
    }

    public void write(File xmlFile) {
        try {
            PrintWriter out = new PrintWriter(xmlFile);
            out.print(this.toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        logger.debug("toString() >>>");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        logger.info("TransformerFactory Class: " + transformerFactory.getClass().getName());
        try {
            transformerFactory.setAttribute("indent-number", String.valueOf(this.indent));
        }
        catch (IllegalArgumentException iae) {
            logger.info("Can't use attribute 'indent-number' with TransformerFactory.");
        }
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.indent));
            StringWriter sw = new StringWriter();
            transformer.setOutputProperty("indent", "yes");
            logger.info("Transformer Class: " + transformer.getClass().getName());
            transformer.transform(new DOMSource(this.document), new StreamResult(sw));
            String value = sw.toString();
            logger.debug("toString() <<<");
            return value;
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

