/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Server {
    String host;
    int port;
    int timeout;
    String description;
    private boolean isPrimary;

    Server(String _host, int _port, int _timeout, String _description) {
        this.host = _host;
        this.port = _port;
        this.timeout = _timeout;
        this.description = _description;
        this.isPrimary = false;
    }

    public void setIsPrimary(boolean val) {
        this.isPrimary = val;
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    static Map<String, Set<Server>> loadServers(File configFile, PrintWriter out) {
        HashMap<String, Set<Server>> servers = new HashMap<String, Set<Server>>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(configFile));
            out.println("Configured prerequisite servers:");
            while (true) {
                String buf;
                if ((buf = br.readLine()) == null) {
                    return servers;
                }
                out.println(":" + buf);
                out.flush();
                if ((buf = buf.replaceAll(" +", " ")).equals("") || buf.startsWith("#")) continue;
                String[] parms = buf.split(" ", 4);
                int port = Integer.parseInt(parms[1]);
                int timeout = Integer.parseInt(parms[2]);
                String description = parms[3];
                Server s = new Server(parms[0], port, timeout, description);
                if (servers.containsKey(description)) {
                    Set cluster = (Set)servers.get(description);
                    cluster.add(s);
                    continue;
                }
                HashSet<Server> set = new HashSet<Server>();
                set.add(s);
                servers.put(description, set);
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return servers;
        }
    }

    public static void addServerToMap(Server s, Map<String, Set<Server>> map) {
        if (map.containsKey(s.description)) {
            Set<Server> cluster = map.get(s.description);
            cluster.add(s);
        } else {
            HashSet<Server> set = new HashSet<Server>();
            set.add(s);
            map.put(s.description, set);
        }
    }

    public static void removeServerFromMap(Server s, Map<String, Set<Server>> map) {
        if (map.containsKey(s.description)) {
            Set<Server> cluster = map.get(s.description);
            cluster.remove(s);
        }
    }
}

