/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.startup;

import com.sas.vfabrictcsvr.startup.HostPortSet;
import com.sas.vfabrictcsvr.startup.MetadataClusterUtil;
import com.sas.vfabrictcsvr.startup.XmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.tomcat.util.IntrospectionUtils;
import org.w3c.dom.Element;

public class MetadataServerCheck {
    private static final String SHARED_SERVICES_USER = "SharedServices";
    private static final String SHARED_SERVICES_PW = "pw.sas.jdbc.SharedServices";
    private static final String CATALINA_BASE = "catalina.base";
    private static final String CONFIG_DIR = "conf";
    private static final String CATALINA_PROPERTIES = "catalina.properties";
    private static final String SERVER_CONFIG_FILE = "server.xml";
    private static final String TOMCAT_DIGESTER_CLASS = "org.apache.tomcat.util.digester.PROPERTY_SOURCE";
    private static final String SPRING_DECODER_PASSPHRASE = "com.sas.vfabrictcsvr.decoder.PropertyDecoder.passphrase.file";
    PrintWriter out = new PrintWriter(System.out);

    public static void main(String[] args) {
        MetadataServerCheck msc = new MetadataServerCheck();
        HostPortSet msCluster = msc.getConfiguredMetadataServers();
        HostPortSet msPrimary = msc.getConfiguredPrimaryMetadataServer();
        System.out.println("toString:" + msCluster.toString());
        System.out.println("Primary:" + msPrimary.toString());
    }

    HostPortSet getConfiguredMetadataServers() {
        String connectionUrl = this.getSharedServicesUrl();
        String jdbcDriver = this.getSharedServicesDriver();
        if (connectionUrl == null || jdbcDriver == null) {
            return null;
        }
        Properties connProps = new Properties();
        connProps.setProperty("user", SHARED_SERVICES_USER);
        String passwd = this.getSharedServicesPassword();
        connProps.setProperty("password", passwd);
        connProps.setProperty("url", connectionUrl);
        String minPoolSize = this.getMinPoolSize();
        String maxPoolSize = this.getMaxPoolSize();
        MetadataClusterUtil.out = this.out;
        return MetadataClusterUtil.getClusterHostPortSetWithXADriver(connProps, jdbcDriver, minPoolSize, maxPoolSize);
    }

    HostPortSet getConfiguredPrimaryMetadataServer() {
        String connectionUrl = this.getSharedServicesUrl();
        String jdbcDriver = this.getSharedServicesDriver();
        if (connectionUrl == null || jdbcDriver == null) {
            return null;
        }
        Properties connProps = new Properties();
        connProps.setProperty("user", SHARED_SERVICES_USER);
        String passwd = this.getSharedServicesPassword();
        connProps.setProperty("password", passwd);
        connProps.setProperty("url", connectionUrl);
        String minPoolSize = this.getMinPoolSize();
        String maxPoolSize = this.getMaxPoolSize();
        return MetadataClusterUtil.getPrimaryHostPortSetWithXADriver(connProps, jdbcDriver, minPoolSize, maxPoolSize);
    }

    File getCatalinaBase() {
        String basepath = System.getProperty(CATALINA_BASE);
        File catalinaBase = null;
        if (basepath != null && basepath != "") {
            catalinaBase = new File(basepath);
        }
        return catalinaBase;
    }

    File getCatalinaPropertiesFile() {
        File configDir = new File(this.getCatalinaBase(), CONFIG_DIR);
        return new File(configDir, CATALINA_PROPERTIES);
    }

    Properties getCatalinaProperties() {
        Properties catalinaProps = new Properties();
        try {
            FileInputStream is = new FileInputStream(this.getCatalinaPropertiesFile());
            catalinaProps.load(is);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return catalinaProps;
    }

    String getSharedServicesPassword() {
        Properties catalinaProps = this.getCatalinaProperties();
        String encodedPw = catalinaProps.getProperty(SHARED_SERVICES_PW);
        System.setProperty(SHARED_SERVICES_PW, encodedPw);
        System.setProperty(SPRING_DECODER_PASSPHRASE, catalinaProps.getProperty(SPRING_DECODER_PASSPHRASE));
        String decoderClass = catalinaProps.getProperty(TOMCAT_DIGESTER_CLASS);
        IntrospectionUtils.PropertySource psource = null;
        String decodedPw = "";
        try {
            if (decoderClass.indexOf(",") > -1) {
                String string;
                Class<?> cls;
                String[] decoderClasses;
                String[] stringArray = decoderClasses = decoderClass.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && (null == (decodedPw = (psource = (IntrospectionUtils.PropertySource)(cls = Class.forName(string = stringArray[i])).newInstance()).getProperty(SHARED_SERVICES_PW)) || decodedPw.equals("")); ++i) {
                }
            } else {
                Class<?> cls = Class.forName(decoderClass);
                psource = (IntrospectionUtils.PropertySource)cls.newInstance();
                decodedPw = psource.getProperty(SHARED_SERVICES_PW);
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
            this.out.flush();
        }
        return decodedPw;
    }

    File getServerConfigFile() {
        File configDir = new File(this.getCatalinaBase(), CONFIG_DIR);
        return new File(configDir, SERVER_CONFIG_FILE);
    }

    String getSharedServicesUrl() {
        File serverXmlFile = this.getServerConfigFile();
        XmlHelper xmlHelper = new XmlHelper();
        xmlHelper.parse(serverXmlFile);
        StringBuilder xpath = new StringBuilder();
        xpath.append("/Server/GlobalNamingResources/Resource[");
        xpath.append("@name=\"sas/jdbc/SharedServices\"");
        xpath.append("]");
        if (!xmlHelper.nodeExists(xpath.toString())) {
            this.out.println("Can't find SharedServices data source configuration in server.xml");
            this.out.flush();
            return null;
        }
        Element engineElement = xmlHelper.findNode(xpath.toString());
        return engineElement.getAttribute("xaProperties.url");
    }

    String getSharedServicesDriver() {
        File serverXmlFile = this.getServerConfigFile();
        XmlHelper xmlHelper = new XmlHelper();
        xmlHelper.parse(serverXmlFile);
        StringBuilder xpath = new StringBuilder();
        xpath.append("/Server/GlobalNamingResources/Resource[");
        xpath.append("@name=\"sas/jdbc/SharedServices\"");
        xpath.append("]");
        if (!xmlHelper.nodeExists(xpath.toString())) {
            this.out.println("Can't find SharedServices data source configuration in server.xml");
            this.out.flush();
            return null;
        }
        Element engineElement = xmlHelper.findNode(xpath.toString());
        return engineElement.getAttribute("xaDataSourceClassName");
    }

    String getMinPoolSize() {
        File serverXmlFile = this.getServerConfigFile();
        XmlHelper xmlHelper = new XmlHelper();
        xmlHelper.parse(serverXmlFile);
        StringBuilder xpath = new StringBuilder();
        xpath.append("/Server/GlobalNamingResources/Resource[");
        xpath.append("@name=\"sas/jdbc/SharedServices\"");
        xpath.append("]");
        if (!xmlHelper.nodeExists(xpath.toString())) {
            this.out.println("Can't find SharedServices data source configuration in server.xml");
            this.out.flush();
            return null;
        }
        Element engineElement = xmlHelper.findNode(xpath.toString());
        return engineElement.getAttribute("minPoolSize");
    }

    String getMaxPoolSize() {
        File serverXmlFile = this.getServerConfigFile();
        XmlHelper xmlHelper = new XmlHelper();
        xmlHelper.parse(serverXmlFile);
        StringBuilder xpath = new StringBuilder();
        xpath.append("/Server/GlobalNamingResources/Resource[");
        xpath.append("@name=\"sas/jdbc/SharedServices\"");
        xpath.append("]");
        if (!xmlHelper.nodeExists(xpath.toString())) {
            this.out.println("Can't find SharedServices data source configuration in server.xml");
            this.out.flush();
            return null;
        }
        Element engineElement = xmlHelper.findNode(xpath.toString());
        return engineElement.getAttribute("maxPoolSize");
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter _out) {
        this.out = _out;
    }
}

