/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.loader;

import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionedJarRepositoryLoader
extends WebappClassLoaderBase {
    private static final String PICKLIST = "/WEB-INF/picklist";
    private static final String INCLUDE_PATTERNS = "/WEB-INF/picklist.includes";
    private static final String EXCLUDE_PATTERNS = "/WEB-INF/picklist.excludes";
    private Logger logger = LogManager.getLogger(VersionedJarRepositoryLoader.class);

    public VersionedJarRepositoryLoader() {
    }

    public VersionedJarRepositoryLoader(ClassLoader parent) {
        super(parent);
    }

    public VersionedJarRepositoryLoader copyWithoutTransformers() {
        VersionedJarRepositoryLoader result = new VersionedJarRepositoryLoader(this.getParent());
        super.copyStateWithoutTransformers((WebappClassLoaderBase)result);
        try {
            result.start();
        }
        catch (LifecycleException exp) {
            throw new IllegalStateException(exp);
        }
        return result;
    }

    protected Object getClassLoadingLock(String className) {
        return this;
    }

    private WildcardFileFilter getFilter(String docBase, String path) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(docBase + path);
        if (file.exists()) {
            BufferedReader reader = null;
            this.logger.info("Reading patterns from " + file);
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage());
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (list.size() > 0) {
            return new WildcardFileFilter(list.toArray(new String[list.size()]));
        }
        return null;
    }

    private WildcardFileFilter getDefaultExcludeFilter() {
        WildcardFileFilter filter = null;
        Properties props = new Properties();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("loader.properties");
        try {
            props.load(in);
            String excludesProperty = props.getProperty("excludes");
            if (excludesProperty != null) {
                String[] patterns = excludesProperty.split(",");
                filter = new WildcardFileFilter(patterns);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Added " + patterns.length + " default exclude patterns");
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return filter;
    }

    private String getDocBase(StandardContext context) {
        String docBase = null;
        StandardContext ctx = context;
        this.logger.info("Context is " + ctx);
        docBase = ctx.getDocBase();
        if (docBase.startsWith("../") || docBase.startsWith("..\\")) {
            String ctnBase = System.getenv("CATALINA_BASE");
            docBase = ctnBase + docBase.substring(2);
        }
        return docBase;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.resources instanceof StandardRoot && this.resources.getContext() instanceof StandardContext) {
            StandardContext context = (StandardContext)this.resources.getContext();
            String docBase = this.getDocBase(context);
            WildcardFileFilter includeFilter = this.getFilter(docBase, INCLUDE_PATTERNS);
            WildcardFileFilter excludeFilter = this.getFilter(docBase, EXCLUDE_PATTERNS);
            WildcardFileFilter defaultExcludeFilter = this.getDefaultExcludeFilter();
            File file = new File(docBase + PICKLIST);
            this.logger.info("Checking for picklist " + file);
            if (file.exists()) {
                try {
                    this.logger.info("Accessing VJR with " + file);
                    PickList picklist = new PickList(file);
                    Repository repo = Repository.getDefaultRepository();
                    Plugin[] plugins = repo.find(picklist);
                    URL[] urls = Repository.getClasspath((Plugin[])plugins);
                    for (int i = 0; i < urls.length; ++i) {
                        URI uri = urls[i].toURI();
                        File jar = new File(uri);
                        if (!jar.exists()) {
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("File not found, ignoring: " + uri.toString());
                            continue;
                        }
                        if (includeFilter != null && includeFilter.accept(jar)) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Including jar " + jar);
                            }
                        } else if (excludeFilter != null && excludeFilter.accept(jar) || defaultExcludeFilter.accept(jar)) {
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("Excluding jar " + jar);
                            continue;
                        }
                        try {
                            this.addURL(uri.toURL());
                        }
                        catch (MalformedURLException e) {
                            this.logger.error(e.getMessage());
                        }
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Added URI " + uri.toString());
                    }
                }
                catch (RepositoryException e) {
                    this.logger.error(e.getMessage());
                    for (PluginRequest request : e.getUnsatisfiedRequests()) {
                        this.logger.error("Unsatisfied plugin " + request.getName() + ", version " + request.getRange().toVersionString());
                    }
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    }
}

