/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.listener;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class SecureSystemProperties
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(SecureSystemProperties.class);
    private static final String TOMCAT_DIGESTER_CLASS = "org.apache.tomcat.util.digester.PROPERTY_SOURCE";
    private static final String SECURE_PROPERTY_PREFIX = "secure.system.property.";

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("before_init")) {
            log.info((Object)"SecureSystemProperties: initialized");
            String decoderClass = System.getProperty(TOMCAT_DIGESTER_CLASS);
            try {
                IntrospectionUtils.PropertySource psource = (IntrospectionUtils.PropertySource)Class.forName(decoderClass).newInstance();
                for (String p : System.getProperties().stringPropertyNames()) {
                    if (!p.startsWith(SECURE_PROPERTY_PREFIX)) continue;
                    String p1 = p.replaceFirst(SECURE_PROPERTY_PREFIX, "");
                    log.info((Object)("found secure property: " + p + " setting system property " + p1));
                    System.setProperty(p1, psource.getProperty(p));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

