/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.execution;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WindowsService {
    private static Logger logger = LogManager.getLogger(WindowsService.class);
    private static final int WINDOWS_SERVICE_QUERY_ERROR = -1;
    private static final int WINDOWS_SERVICE_STOPPED = 1;
    private static final int WINDOWS_SERVICE_START_PENDING = 2;
    private static final int WINDOWS_SERVICE_STOP_PENDING = 3;
    private static final int WINDOWS_SERVICE_RUNNING = 4;
    private static final int WINDOWS_SERVICE_CONTINUE_PENDING = 5;
    private static final int WINDOWS_SERVICE_PAUSE_PENDING = 6;
    private static final int WINDOWS_SERVICE_PAUSED = 7;
    private static final int WINDOWS_SERVICE_NOT_DEFINED = 1060;
    protected static final int DEFAULT_SECONDS_WAIT_SERVICE_STOP = 600;
    protected static final int DEFAULT_SECONDS_WAIT_SERVICE_DELETE = 600;

    public WindowsService() throws RuntimeException {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            throw new RuntimeException("The " + WindowsService.class + " can only be used on a Windows system");
        }
    }

    public boolean isExist(String serviceName) {
        logger.trace("isExist >>>");
        int stateCode = this.getStateCode(serviceName);
        boolean result = stateCode != 1060 && stateCode > -1;
        logger.trace("isExist <<<");
        return result;
    }

    public boolean isStopped(String serviceName) {
        return this.isStateEqual(serviceName, 1);
    }

    public boolean isRunning(String serviceName) {
        return this.isStateEqual(serviceName, 4);
    }

    public boolean isPaused(String serviceName) {
        return this.isStateEqual(serviceName, 7);
    }

    public int waitForStop(String serviceName, int timeOutInSeconds) {
        logger.trace("waitForStop >>>");
        int status = -1;
        if (!this.isExist(serviceName)) {
            logger.warn("Service " + serviceName + " does not exist");
        } else {
            if (timeOutInSeconds <= 0) {
                timeOutInSeconds = 1;
            }
            logger.info("Retry time out set to " + timeOutInSeconds + " seconds");
            for (int retry = 0; status != 0 && retry < timeOutInSeconds; ++retry) {
                int stateCode = this.getStateCode(serviceName);
                logger.info("Query " + (retry + 1) + " on Windows service " + serviceName + " returned " + stateCode + " " + this.getStateLabel(stateCode));
                if (stateCode == 1) {
                    status = 0;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException exc) {
                    logger.error((Object)exc);
                }
            }
        }
        logger.trace("waitForStop <<<");
        return status;
    }

    public int waitForDelete(String serviceName, int timeOutInSeconds) {
        logger.trace("waitForDelete >>>");
        int status = -1;
        if (timeOutInSeconds <= 0) {
            timeOutInSeconds = 1;
        }
        logger.info("Retry time out set to " + timeOutInSeconds + " seconds");
        for (int retry = 0; status != 0 && retry < timeOutInSeconds; ++retry) {
            int stateCode = this.getStateCode(serviceName);
            String stateLabel = this.getStateLabel(stateCode);
            logger.info("Query " + (retry + 1) + " on Windows service " + serviceName + " returned " + stateCode + " " + stateLabel);
            if (stateCode == 1060) {
                status = 0;
                continue;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException exc) {
                logger.error((Object)exc);
            }
        }
        logger.trace("waitForDelete <<<");
        return status;
    }

    private boolean isStateEqual(String serviceName, int targetCode) {
        logger.trace("isStateEqual >>>");
        boolean result = false;
        int stateCode = this.getStateCode(serviceName);
        if (stateCode == targetCode) {
            result = true;
        }
        logger.trace("isStateEqual <<<");
        return result;
    }

    private int getStateCode(String serviceName) {
        logger.trace("getStateCode >>>");
        int stateCode = -1;
        String stateInfo = this.getStateInfo(serviceName);
        if (stateInfo.isEmpty()) {
            logger.info("Service state info for " + serviceName + " is empty");
        } else {
            Scanner scanner = new Scanner(stateInfo);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Pattern statePattern = Pattern.compile("^(\\s*STATE\\s*:\\s*)(\\d)(.*)$");
                Matcher stateMatch = statePattern.matcher(line);
                if (stateMatch.find()) {
                    stateCode = Integer.valueOf(stateMatch.group(2));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Service state code = " + stateMatch.group(2));
                    logger.debug("Service state text = " + stateMatch.group(3));
                    continue;
                }
                Pattern failPattern = Pattern.compile("^.*(FAILED\\s+)(\\d+).*$");
                Matcher failMatch = failPattern.matcher(line);
                if (!failMatch.find()) continue;
                stateCode = Integer.valueOf(failMatch.group(2));
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Service state code = " + failMatch.group(2));
                logger.debug("Service state text = " + failMatch.group(1));
            }
            scanner.close();
        }
        logger.trace("getStateCode <<<");
        return stateCode;
    }

    public String getStateLabel(int stateCode) {
        logger.trace("getStateLabel >>>");
        String label = new String();
        switch (stateCode) {
            case 1: {
                label = "STOPPED";
                break;
            }
            case 2: {
                label = "START PENDING";
                break;
            }
            case 3: {
                label = "STOP PENDING";
                break;
            }
            case 4: {
                label = "RUNNING";
                break;
            }
            case 5: {
                label = "CONTINUE PENDING";
                break;
            }
            case 6: {
                label = "PAUSE PENDING";
                break;
            }
            case 7: {
                label = "PAUSED";
                break;
            }
            case 1060: {
                label = "NOT DEFINED";
                break;
            }
            default: {
                label = String.valueOf(stateCode);
            }
        }
        logger.trace("getStateLabel <<<");
        return label;
    }

    private String getStateInfo(String serviceName) {
        logger.trace("getStateInfo >>>");
        String command = new String("sc query " + serviceName);
        logger.debug("Command = \"" + command + "\"");
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command);
            process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.error("Query on service state failed for " + serviceName);
        }
        BufferedReader outputBuffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder outputValue = new StringBuilder();
        String outputLine = null;
        do {
            try {
                outputLine = outputBuffer.readLine();
                if (outputLine == null) continue;
                outputValue.append(outputLine + System.lineSeparator());
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Unable to retrieve service state from query output for " + serviceName);
            }
        } while (outputLine != null);
        logger.trace("getStateInfo <<<");
        return outputValue.toString();
    }
}

