/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.execution;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionProperties {
    private static Logger logger = LogManager.getLogger(ExecutionProperties.class);
    private Properties execProperties = new Properties();
    private boolean propertiesLoaded = false;
    public int EXEC_INT_PROPERTY_NOT_FOUND = -1;
    public String EXEC_STR_PROPERTY_NOT_FOUND = null;

    public void loadProperties(String propertyFileName) {
        logger.trace("loadProperties >>>");
        logger.debug("propertyFile = " + propertyFileName);
        if (propertyFileName == null) {
            logger.warn("Invalid properties file argument");
        } else {
            try {
                FileInputStream fileInput = new FileInputStream(propertyFileName);
                this.execProperties.load(fileInput);
            }
            catch (FileNotFoundException ex) {
                logger.debug("Properties file " + propertyFileName + " was not found");
            }
            catch (IOException ex) {
                logger.warn("Failed to read properties from " + propertyFileName);
            }
            this.propertiesLoaded = true;
            if (logger.isDebugEnabled()) {
                Enumeration<?> propertyName = this.execProperties.propertyNames();
                StringBuilder propertyList = new StringBuilder();
                while (propertyName.hasMoreElements()) {
                    String pname = (String)propertyName.nextElement();
                    propertyList.append(System.lineSeparator() + "   >> " + pname + " = " + this.execProperties.getProperty(pname));
                }
                logger.debug("Properties loaded:" + propertyList.toString());
            }
        }
        logger.trace("loadProperties <<<");
    }

    public String getProperty(String pname) {
        String rvalue = this.EXEC_STR_PROPERTY_NOT_FOUND;
        if (!this.propertiesLoaded) {
            logger.error("The properties have not been loaded");
        } else {
            rvalue = this.execProperties.getProperty(pname);
        }
        return rvalue;
    }

    public int getServiceStopTimeout() {
        int rvalue = this.EXEC_INT_PROPERTY_NOT_FOUND;
        if (!this.propertiesLoaded) {
            logger.error("The properties have not been loaded");
        } else {
            String pvalue = this.getProperty("SecondsWaitForWndowsServiceStop");
            if (pvalue != null) {
                rvalue = Integer.valueOf(pvalue);
            }
        }
        return rvalue;
    }

    public int getServiceDeleteTimeout() {
        int rvalue = this.EXEC_INT_PROPERTY_NOT_FOUND;
        if (!this.propertiesLoaded) {
            logger.error("The properties have not been loaded");
        } else {
            String pvalue = this.getProperty("SecondsWaitForWindowsServiceDelete");
            if (pvalue != null) {
                rvalue = Integer.valueOf(pvalue);
            }
        }
        return rvalue;
    }

    public int getProcessStartTimeout() {
        int rvalue = this.EXEC_INT_PROPERTY_NOT_FOUND;
        if (!this.propertiesLoaded) {
            logger.error("The properties have not been loaded");
        } else {
            String pvalue = this.getProperty("SecondsWaitForServerStart");
            if (pvalue != null) {
                rvalue = Integer.valueOf(pvalue);
            }
        }
        return rvalue;
    }

    public int getProcessStopTimeout() {
        int rvalue = this.EXEC_INT_PROPERTY_NOT_FOUND;
        if (!this.propertiesLoaded) {
            logger.error("The properties have not been loaded");
        } else {
            String pvalue = this.getProperty("SecondsWaitForServerStop");
            if (pvalue != null) {
                rvalue = Integer.valueOf(pvalue);
            }
        }
        return rvalue;
    }
}

