/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.execution;

import com.sas.vfabrictcsvr.execution.ExecutionProperties;
import com.sas.vfabrictcsvr.execution.ServerConfiguration;
import com.sas.vfabrictcsvr.execution.ServerProcess;
import com.sas.vfabrictcsvr.execution.WindowsService;
import java.io.File;
import java.io.IOException;
import org.apache.catalina.startup.Bootstrap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ExecutionInterface {
    private static Logger logger = LogManager.getLogger(ExecutionInterface.class);
    private static Options options = new Options();
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final String PROPERTY_FILE_OPTION_NAME = "sas.vfabrictcsvr.execution.properties.file";
    private static final String PROPERTY_SERVER_LOG_LEVEL = "sas.vfabrictcsvr.execution.log.level";
    private static final String PROPERTY_SERVER_LOG_SIZE = "sas.vfabrictcsvr.execution.log.size";
    public static final String PROPERTY_CATALINA_HOME = "catalina.home";
    public static final String PROPERTY_CATALINA_BASE = "catalina.base";
    public static final String PROPERTY_CATALINA_PID = "catalina.pid";
    public static final String PROPERTY_CATALINA_OUT = "catalina.out";
    private static final String LOG_FILE_DIRECTORY = "logs";
    private static final String LOG_FILE_NAME = "vfabric.execution";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String LOG_FILE_MAX_SIZE = "10 MB";
    private static final String LOG_FILE_MAX_COUNT = "10";
    private static final String DEFAULT_LOG_FILE_NAME = "server.log";
    protected static long initialLogFileSize = -1L;
    protected static File catalinaHome;
    protected static File catalinaBase;
    protected static File catalinaPID;
    protected static File catalinaOut;
    protected static boolean verbose;
    protected static ExecutionProperties pexec;
    protected static ServerConfiguration serverConfig;

    public static void main(String[] args) {
        int status = 0;
        CommandLine cmdLine = null;
        ExecutionInterface.configureLogging();
        logger.trace("main >>>");
        status = ExecutionInterface.getEnvironment();
        if (status == 0) {
            ExecutionInterface.configureLogFileAppender();
            logger.trace("--- Starting ExecutionInterface ---");
            try {
                cmdLine = ExecutionInterface.parseCommandLine(args);
            }
            catch (ParseException exc) {
                status = -1;
                logger.fatal(exc.getMessage());
            }
        }
        if (status == 0) {
            try {
                ExecutionInterface.validateCommandArgs(cmdLine);
            }
            catch (IllegalArgumentException exc) {
                status = -1;
                logger.fatal(exc.getMessage());
                logger.fatal("Command line argument validation failed");
            }
        }
        if (status == 0) {
            if (cmdLine.hasOption("h")) {
                String header = String.format("%nManage operations on SAS process or service.%n%n", new Object[0]);
                String footer = String.format("%nCopyright (c) 2022 - 2023 by SAS Institute Inc., Cary, NC USA 27513", new Object[0]);
                HelpFormatter formatter = new HelpFormatter();
                formatter.setLeftPadding(3);
                formatter.setWidth(85);
                formatter.setOptionComparator(null);
                formatter.printHelp("ExecutionInterface", header, options, footer, true);
            } else {
                String propertyFileName = ExecutionInterface.getPropertyFileName();
                if (propertyFileName != null) {
                    pexec = new ExecutionProperties();
                    pexec.loadProperties(propertyFileName);
                }
                try {
                    serverConfig = new ServerConfiguration(catalinaBase);
                }
                catch (Exception exc) {
                    logger.error((Object)exc);
                    logger.error("Unable to retrieve server configuration");
                    status = -1;
                }
                if (status == 0) {
                    if (cmdLine.hasOption("wpr")) {
                        status = ExecutionInterface.doWaitProcessStart(cmdLine);
                    } else if (cmdLine.hasOption("wps")) {
                        status = ExecutionInterface.doWaitProcessStop(cmdLine);
                    } else if (cmdLine.hasOption("wss")) {
                        status = ExecutionInterface.doWaitServiceStop(cmdLine);
                    } else if (cmdLine.hasOption("wsd")) {
                        status = ExecutionInterface.doWaitServiceDelete(cmdLine);
                    } else {
                        logger.error("The specified action has not been implemented");
                    }
                }
            }
        }
        logger.trace("main <<<");
        System.exit(status);
    }

    private static void configureLogging() {
        Level logLevel = Level.INFO;
        String logLevelProperty = System.getProperty(PROPERTY_SERVER_LOG_LEVEL);
        if (logLevelProperty != null) {
            switch (logLevelProperty.toUpperCase()) {
                case "FATAL": {
                    logLevel = Level.FATAL;
                    break;
                }
                case "ERROR": {
                    logLevel = Level.ERROR;
                    break;
                }
                case "WARN": {
                    logLevel = Level.WARN;
                    break;
                }
                case "INFO": {
                    logLevel = Level.INFO;
                    break;
                }
                case "DEBUG": {
                    logLevel = Level.DEBUG;
                    break;
                }
                case "TRACE": {
                    logLevel = Level.TRACE;
                    break;
                }
                case "ALL": {
                    logLevel = Level.ALL;
                }
            }
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        config.getLoggerConfig(ExecutionInterface.class.getName()).setLevel(logLevel);
        lc.updateLoggers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureLogFileAppender() {
        logger.trace("configureLogFileAppender >>>");
        File logPath = new File(catalinaBase, LOG_FILE_DIRECTORY);
        File catalinaLogDir = null;
        try {
            catalinaLogDir = new File(logPath.getCanonicalPath());
        }
        catch (IOException exc) {
            logger.error("Unable to validate path " + logPath.getPath());
            logger.warn("No log file will be generated or updated for this execution");
            catalinaLogDir = null;
        }
        finally {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = lc.getConfiguration();
            if (catalinaLogDir != null && catalinaLogDir.exists() && catalinaLogDir.isDirectory() && catalinaLogDir.canWrite()) {
                PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d %-5p (%t) [%c] %m%n").build();
                DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMin("1").withMax(LOG_FILE_MAX_COUNT).build();
                RollingFileAppender vfabAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("vfabric")).setLayout((Layout)layout)).setConfiguration(config)).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)LOG_FILE_MAX_SIZE)).withFileName(catalinaLogDir + File.separator + LOG_FILE_NAME + LOG_FILE_EXTENSION).withFilePattern(catalinaLogDir + File.separator + LOG_FILE_NAME + ".%i" + LOG_FILE_EXTENSION).withCreateOnDemand(true).withStrategy((RolloverStrategy)strategy).build();
                vfabAppender.start();
                config.addAppender((Appender)vfabAppender);
                lc.getRootLogger().addAppender((Appender)vfabAppender);
                lc.updateLoggers();
            }
        }
        logger.trace("configureLogFileAppender <<<");
    }

    private static int getEnvironment() {
        String outPath;
        logger.trace("getEnvironment >>>");
        int status = 0;
        String homePath = System.getProperty(PROPERTY_CATALINA_HOME);
        if (homePath == null) {
            logger.error("The \"catalina.home\" property is required but not defined");
            status = -1;
        } else {
            File homeHandle = new File(homePath);
            try {
                catalinaHome = homeHandle.getCanonicalFile();
                logger.debug("catalinaHome = " + catalinaHome);
            }
            catch (IOException exc) {
                logger.error("Unable to validate path " + homePath);
                status = -1;
            }
        }
        String basePath = System.getProperty(PROPERTY_CATALINA_BASE);
        if (basePath == null) {
            logger.error("The \"catalina.base\" property is required but not defined");
            status = -1;
        } else {
            File baseHandle = new File(basePath);
            try {
                catalinaBase = baseHandle.getCanonicalFile();
                logger.debug("catalinaBase = " + catalinaBase);
            }
            catch (IOException exc) {
                logger.error("Unable to validate path " + basePath);
                status = -1;
            }
        }
        String pidPath = System.getProperty(PROPERTY_CATALINA_PID);
        if (pidPath != null) {
            File pidHandle = new File(pidPath);
            try {
                catalinaPID = pidHandle.getCanonicalFile();
                logger.debug("catalinaPID  = " + catalinaPID);
            }
            catch (IOException exc) {
                logger.error("Unable to validate path " + pidPath);
                status = -1;
            }
        }
        if ((outPath = null) == null) {
            outPath = catalinaBase + File.separator + LOG_FILE_DIRECTORY + File.separator + DEFAULT_LOG_FILE_NAME;
        }
        File outPathHandle = new File(outPath);
        try {
            catalinaOut = outPathHandle.getCanonicalFile();
            logger.debug("catalinaOut  = " + catalinaOut);
        }
        catch (IOException exc) {
            logger.error("Unable to validate path " + outPath);
            status = -1;
        }
        String logSize = System.getProperty(PROPERTY_SERVER_LOG_SIZE);
        if (logSize != null && logSize.length() > 0) {
            if (logSize.matches("\\d+")) {
                initialLogFileSize = Long.valueOf(logSize);
                logger.debug("initialLogFileSize  = " + initialLogFileSize);
            } else {
                logger.warn("The value or system property sas.vfabrictcsvr.execution.log.size is invalid: " + logSize);
            }
        }
        logger.trace("getEnvironment <<<");
        return status;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        CommandLine cmdLine;
        logger.trace("parseCommandLine >>>");
        if (logger.isDebugEnabled()) {
            for (String strValue : args) {
                System.out.println("   >> " + strValue);
            }
        }
        options.addOption("h", "help", false, "ACTION: Display this help and usage message.");
        options.addOption("wpr", "waitprocessstart", false, "ACTION: Wait for process to start and report ready.");
        options.addOption("wps", "waitprocessstop", false, "ACTION: Stop process and wait for termination.");
        options.addOption("wss", "waitservicestop", false, "ACTION: Stop Windows Service and wait for termination.");
        options.addOption("wsd", "waitservicedelete", false, "ACTION: Delete Windows Service and wait for deletion.");
        options.addOption("n", "name", true, "Name of the Windows Service to operate on.  Required for 'wss' and 'wsd' actions.");
        options.addOption("pid", "processid", true, "Process ID of the process to operate on.  Optional for 'wsp' action.");
        options.addOption("t", "timeout", true, "Maximum time to wait for result.  Optional for all actions.");
        options.addOption("v", "verbose", false, "Output run-time status messages to STDOUT (separate from logging).  Optional for all actions.");
        DefaultParser cmdParser = new DefaultParser();
        try {
            cmdLine = cmdParser.parse(options, args);
        }
        catch (ParseException exc) {
            logger.error(exc.getMessage());
            throw new ParseException("Command line parsing failed");
        }
        logger.trace("parseCommandLine <<<");
        return cmdLine;
    }

    private static void validateCommandArgs(CommandLine cmdLine) throws IllegalArgumentException {
        logger.trace("validateCommandArgs >>>");
        if (!cmdLine.hasOption("h")) {
            String optionValue;
            int actionCount = 0;
            if (cmdLine.hasOption("wpr")) {
                ++actionCount;
            }
            if (cmdLine.hasOption("wps")) {
                ++actionCount;
            }
            if (cmdLine.hasOption("wss")) {
                ++actionCount;
            }
            if (cmdLine.hasOption("wsd")) {
                ++actionCount;
            }
            if (actionCount == 0) {
                throw new IllegalArgumentException("An action argument is required");
            }
            if (actionCount > 1) {
                throw new IllegalArgumentException("Only one action argument at a time is allowed");
            }
            if ((cmdLine.hasOption("wss") || cmdLine.hasOption("wsd")) && !cmdLine.hasOption("n")) {
                throw new IllegalArgumentException("An Windows service name argument is required");
            }
            if (cmdLine.hasOption("t")) {
                int intValue;
                if (!(cmdLine.hasOption("wpr") || cmdLine.hasOption("wps") || cmdLine.hasOption("wss") || cmdLine.hasOption("wsd"))) {
                    throw new IllegalArgumentException("A timeout value is not a valid for the selected action");
                }
                optionValue = cmdLine.getOptionValue("t");
                try {
                    intValue = Integer.parseInt(optionValue);
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("The specified timeout value is not a valid integer");
                }
                if (intValue <= 0 || intValue > 3600) {
                    throw new IllegalArgumentException("The specified timeout value is not in allowed range of 0 to 3600");
                }
            }
            if ((cmdLine.hasOption("wss") || cmdLine.hasOption("wsd")) && !cmdLine.hasOption("n")) {
                throw new IllegalArgumentException("The wait-for-service actions require a service name argument");
            }
            if (cmdLine.hasOption("pid")) {
                if (!cmdLine.hasOption("wpr") && !cmdLine.hasOption("wps")) {
                    throw new IllegalArgumentException("A process ID argument is not a valid for the selected action");
                }
                optionValue = cmdLine.getOptionValue("pid");
                try {
                    int pidValue = Integer.parseInt(optionValue);
                    if (pidValue <= 0) {
                        throw new IllegalArgumentException("The specified process ID value must be greater than zero");
                    }
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("The specified process ID value is not a valid integer");
                }
            }
            if (cmdLine.hasOption("n") && !cmdLine.hasOption("wss") && !cmdLine.hasOption("wsd")) {
                throw new IllegalArgumentException("A service name argument is not a valid for the selected action");
            }
            if (cmdLine.hasOption("v")) {
                verbose = true;
                logger.debug("Verbose output is enabled");
            }
        }
        logger.trace("validateCommandArgs <<<");
    }

    private static String getPropertyFileName() {
        return System.getProperty(PROPERTY_FILE_OPTION_NAME);
    }

    private static int getTimeout(CommandLine cmdLine, TimeoutType type) {
        logger.trace("getTimeout(" + (Object)((Object)type) + ") >>>");
        int timeout = 0;
        if (cmdLine.hasOption("t")) {
            String optionValue = cmdLine.getOptionValue("t");
            timeout = Integer.parseInt(optionValue);
        } else {
            switch (type) {
                case PROCESS_START: {
                    timeout = pexec.getProcessStartTimeout();
                    if (timeout != ExecutionInterface.pexec.EXEC_INT_PROPERTY_NOT_FOUND) break;
                    timeout = 600;
                    break;
                }
                case PROCESS_STOP: {
                    timeout = pexec.getProcessStopTimeout();
                    if (timeout != ExecutionInterface.pexec.EXEC_INT_PROPERTY_NOT_FOUND) break;
                    timeout = 600;
                    break;
                }
                case SERVICE_STOP: {
                    timeout = pexec.getServiceStopTimeout();
                    if (timeout != ExecutionInterface.pexec.EXEC_INT_PROPERTY_NOT_FOUND) break;
                    timeout = 600;
                    break;
                }
                case SERVICE_DELETE: {
                    timeout = pexec.getServiceDeleteTimeout();
                    if (timeout != ExecutionInterface.pexec.EXEC_INT_PROPERTY_NOT_FOUND) break;
                    timeout = 600;
                    break;
                }
                default: {
                    logger.error("Invalid timeout ID value" + (Object)((Object)type));
                }
            }
        }
        logger.debug("Timeout value is " + timeout + " seconds");
        logger.trace("getTimeout <<<");
        return timeout;
    }

    private static int doWaitProcessStart(CommandLine cmdLine) {
        logger.trace("doWaitProcessStart >>>");
        int status = 0;
        int timeout = ExecutionInterface.getTimeout(cmdLine, TimeoutType.PROCESS_START);
        ServerProcess sp = new ServerProcess();
        long serverPID = -1L;
        int retry = 0;
        if (verbose) {
            System.out.println("Wait for server start will timeout in " + timeout + " seconds ...");
        }
        if (cmdLine.hasOption("pid")) {
            String optionValue = cmdLine.getOptionValue("pid");
            serverPID = Integer.parseInt(optionValue);
        } else if (catalinaPID != null) {
            for (retry = 0; serverPID == -1L && retry < timeout; ++retry) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exc) {
                    logger.error((Object)exc);
                }
                try {
                    serverPID = sp.getPID(catalinaPID);
                    continue;
                }
                catch (IOException exc) {
                    logger.debug("Wait " + (retry + 1) + " - Failed to retrieve PID");
                }
            }
        }
        if (serverPID <= 0L) {
            if (sp.getOSType() == ServerProcess.OSType.OS_TYPE_UNIX) {
                if (catalinaPID != null) {
                    logger.error("New server process ID file does not exist");
                } else {
                    logger.error("A valid server process ID is required to wait for process start, but one could not be found");
                    logger.error("Failed to wait for the process to start up");
                }
            }
        } else {
            logger.debug("New server process ID is " + serverPID);
        }
        if (serverPID > 0L || ExecutionInterface.serverConfig.healthValve) {
            status = sp.waitForStartup(serverPID, timeout - retry);
            if (status != 0) {
                if (serverPID > 0L) {
                    logger.warn("Wait for process " + serverPID + " to fully start timed out or failed");
                } else {
                    logger.warn("Wait for process to fully start timed out or failed");
                }
            } else if (serverPID > 0L) {
                logger.debug("Wait for process " + serverPID + " to fully start was successfull");
            } else {
                logger.debug("Wait for process to fully start was successfull");
            }
        }
        logger.trace("doWaitProcessStart <<<");
        return status;
    }

    private static int doWaitProcessStop(CommandLine cmdLine) {
        logger.trace("doWaitProcessStop >>>");
        int status = 0;
        int timeout = ExecutionInterface.getTimeout(cmdLine, TimeoutType.PROCESS_STOP);
        long serverPID = -1L;
        boolean foundPIDFile = false;
        boolean deletePIDFile = false;
        ServerProcess sp = new ServerProcess();
        if (verbose) {
            System.out.println("Wait for server stop will timeout in " + timeout + " seconds ...");
        }
        if (status == 0) {
            if (cmdLine.hasOption("pid")) {
                String optionValue = cmdLine.getOptionValue("pid");
                serverPID = Integer.parseInt(optionValue);
            } else if (catalinaPID != null) {
                try {
                    serverPID = sp.getPID(catalinaPID);
                    foundPIDFile = true;
                }
                catch (IOException exc) {
                    logger.error((Object)exc);
                    logger.error("Failed to retrieve the process ID");
                    status = -1;
                }
            }
            logger.debug("Process ID is " + serverPID);
        }
        if (serverPID <= 0L && sp.getOSType() != ServerProcess.OSType.OS_TYPE_WINDOWS) {
            logger.error("The server process ID value is invalid: " + serverPID);
            deletePIDFile = true;
            status = -1;
        } else {
            if (serverPID > 0L) {
                status = sp.getProcessStatus(serverPID);
                if (status != 10) {
                    logger.warn("Server process " + serverPID + " does not exist");
                    deletePIDFile = true;
                }
            } else if (ExecutionInterface.serverConfig.shutdownPort.length() > 0) {
                status = 10;
            }
            if (status == 10) {
                if (ExecutionInterface.serverConfig.shutdownPort.length() > 0 && Integer.valueOf(ExecutionInterface.serverConfig.shutdownPort) > 0) {
                    logger.debug("A shutdown port is configured (" + ExecutionInterface.serverConfig.shutdownPort + ")");
                    logger.debug("Calling catalina to perform the server stop action");
                    String[] catalinaArgs = new String[]{"stop"};
                    Bootstrap.main((String[])catalinaArgs);
                    status = 0;
                    deletePIDFile = true;
                } else if (serverPID > 0L) {
                    status = sp.terminateProcess(serverPID);
                    if (status != 0) {
                        logger.error("Failed to terminate process " + serverPID);
                    } else {
                        logger.debug("Termination of process " + serverPID + " was successfull");
                        deletePIDFile = true;
                    }
                }
                if (status == 0 && serverPID > 0L) {
                    status = sp.waitForTermination(serverPID, timeout);
                    if (status != 0) {
                        logger.warn("Wait for process " + serverPID + " to terminate timed out or the process does not exist");
                    } else {
                        logger.debug("Wait for process " + serverPID + " to terminate was successfull");
                    }
                }
            }
            if (status == 0 && foundPIDFile && deletePIDFile) {
                status = sp.deletePIDFile(catalinaPID);
                if (status != 0) {
                    logger.warn("Failed to delete process ID file " + catalinaPID.getPath());
                    status = 0;
                } else {
                    logger.debug("Deleted process ID file " + catalinaPID.getPath());
                }
            }
        }
        logger.trace("doWaitProcessStop <<<");
        return status;
    }

    private static int doWaitServiceStop(CommandLine cmdLine) {
        logger.trace("doWaitServiceStop >>>");
        int status = 0;
        int timeout = ExecutionInterface.getTimeout(cmdLine, TimeoutType.SERVICE_STOP);
        String serviceName = cmdLine.getOptionValue("n");
        WindowsService ws = new WindowsService();
        status = ws.waitForStop(serviceName, timeout);
        if (status != 0) {
            logger.warn("Wait for service " + serviceName + " to stop timed out or the service does not exist");
        } else {
            logger.debug("Wait for service " + serviceName + " to stop ended successfully");
        }
        logger.trace("doWaitServiceStop <<<");
        return status;
    }

    private static int doWaitServiceDelete(CommandLine cmdLine) {
        logger.trace("doWaitServiceDelete >>>");
        int status = 0;
        int timeout = ExecutionInterface.getTimeout(cmdLine, TimeoutType.SERVICE_DELETE);
        String serviceName = cmdLine.getOptionValue("n");
        WindowsService ws = new WindowsService();
        status = ws.waitForDelete(serviceName, timeout);
        if (status != 0) {
            logger.warn("Wait for service " + serviceName + " to be deleted timed out");
        } else {
            logger.debug("Wait for service " + serviceName + " to be deleted ended successfully");
        }
        logger.trace("doWaitServiceDelete <<<");
        return status;
    }

    static {
        verbose = false;
        pexec = null;
        serverConfig = null;
    }

    private static enum TimeoutType {
        PROCESS_START,
        PROCESS_STOP,
        SERVICE_STOP,
        SERVICE_DELETE;

    }
}

