/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.decoder;

import com.sas.vfabrictcsvr.decoder.SASmtr01;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptDecrypt {
    private static Logger logger = LogManager.getLogger(EncryptDecrypt.class);
    private String encryptionConfigName;
    private String keyDerivationAlgorithm;
    private int keyDerivationIterations;
    private int keySize;
    private String cipherTransformation;
    private String encryptionAlgorithm;
    private int algorithmBlocksize;
    private String hmacAlgorithm;
    private int hmacBlocksize;
    private String objName = null;
    private Cipher cipher;
    private byte[] saltVector;
    private byte[] initVector;
    private byte[] hmacSaltVector;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public EncryptDecrypt() {
    }

    public EncryptDecrypt(String newObjName) {
        this.objName = newObjName;
    }

    public String getObjectName() {
        return this.objName;
    }

    public String getEncryptionConfigName() {
        return this.encryptionConfigName;
    }

    public String getKeyDerivationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public int getKeyDerivationIterations() {
        return this.keyDerivationIterations;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public int getAlgorithmBlockSize() {
        return this.algorithmBlocksize;
    }

    public String getHMACAlgorithm() {
        return this.hmacAlgorithm;
    }

    public int getHMACBlockSize() {
        return this.hmacBlocksize;
    }

    public byte[] getSaltVector() {
        return this.saltVector;
    }

    public void setSaltVector(byte[] newVector) {
        this.saltVector = newVector;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public void setInitVector(byte[] newVector) {
        this.initVector = newVector;
    }

    public byte[] getHMACSaltVector() {
        return this.hmacSaltVector;
    }

    public void setHMACSaltVector(byte[] newVector) {
        this.hmacSaltVector = newVector;
    }

    public void initConfig(String configName) throws Exception {
        if (configName == null || configName.length() == 0) {
            throw new Exception("Invalid encryption configuration name: " + configName);
        }
        int status = 0;
        if (!configName.equals("sasmtr01")) {
            status = -1;
            throw new Exception("Invalid encryption configuration name: " + configName);
        }
        SASmtr01 sasmtr01 = new SASmtr01();
        this.encryptionConfigName = sasmtr01.getEncryptionConfigName();
        this.keyDerivationAlgorithm = sasmtr01.getKeyDerivationAlgorithm();
        this.keyDerivationIterations = sasmtr01.getKeyDerivationIterations();
        this.cipherTransformation = sasmtr01.getCipherTransformation();
        this.keySize = sasmtr01.getKeySize();
        this.encryptionAlgorithm = sasmtr01.getEncryptionAlgorithm();
        this.algorithmBlocksize = sasmtr01.getAlgorithmBlockSize();
        this.hmacAlgorithm = sasmtr01.getHMACAlgorithm();
        this.hmacBlocksize = sasmtr01.getHMACBlockSize();
        if (status == 0) {
            this.cipher = Cipher.getInstance(this.cipherTransformation);
            SecureRandom rand = new SecureRandom();
            this.saltVector = new byte[this.cipher.getBlockSize()];
            rand.nextBytes(this.saltVector);
            this.initVector = new byte[this.cipher.getBlockSize()];
            rand.nextBytes(this.initVector);
            this.hmacSaltVector = new byte[this.cipher.getBlockSize()];
            rand.nextBytes(this.hmacSaltVector);
        }
    }

    public byte[] encryptData(String password, String plainText) {
        byte[] plainTextUTF8 = null;
        byte[] cipherText = null;
        SecretKeySpec aesKey = null;
        try {
            plainTextUTF8 = plainText.getBytes("UTF-8");
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.keyDerivationAlgorithm);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), this.saltVector, this.keyDerivationIterations, this.keySize);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            aesKey = new SecretKeySpec(secretKey.getEncoded(), this.encryptionAlgorithm);
        }
        catch (Exception exc) {
            logger.error("Failed to generate an encryption key");
        }
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(this.initVector);
            this.cipher.init(1, aesKey, ivSpec);
            cipherText = this.cipher.doFinal(plainTextUTF8);
        }
        catch (Exception exc) {
            logger.error("Failed to encrypt the data");
        }
        if (logger.isDebugEnabled()) {
            StringBuilder hexText = new StringBuilder();
            for (int i = 0; i < cipherText.length; ++i) {
                hexText.append(String.format("%02X ", cipherText[i]));
            }
            logger.debug("Cipher text = " + hexText);
        }
        return cipherText;
    }

    public String decryptData(String password, byte[] cipherText) {
        SecretKeySpec algKey = null;
        String plainText = null;
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.keyDerivationAlgorithm);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), this.saltVector, this.keyDerivationIterations, this.keySize);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            algKey = new SecretKeySpec(secretKey.getEncoded(), this.encryptionAlgorithm);
        }
        catch (Exception exc) {
            logger.error("Failed to generate a decryption key");
        }
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(this.initVector);
            this.cipher.init(2, algKey, ivSpec);
            byte[] decryptedVector = this.cipher.doFinal(cipherText);
            plainText = new String(decryptedVector);
        }
        catch (Exception exc) {
            logger.error("Failed to decrypt the data");
        }
        return plainText;
    }

    public byte[] createHMAC(String password, byte[] message) {
        byte[] msgCode = null;
        SecretKeySpec secretKey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), this.hmacSaltVector, this.keyDerivationIterations, this.keySize);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.keyDerivationAlgorithm);
            byte[] algKey = keyFactory.generateSecret(keySpec).getEncoded();
            secretKey = new SecretKeySpec(algKey, this.hmacAlgorithm);
        }
        catch (Exception exc) {
            logger.error("Failed to generate an HMAC encryption key");
        }
        try {
            Mac hmacHandle = Mac.getInstance(this.hmacAlgorithm);
            hmacHandle.init(secretKey);
            msgCode = hmacHandle.doFinal(message);
        }
        catch (Exception exc) {
            logger.error("Failed to generate a message authentication code");
        }
        return msgCode;
    }

    public String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

