/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.authenticator;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SSLAuthenticator
extends ValveBase {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");
    private static final Log log = LogFactory.getLog(SSLAuthenticator.class);
    protected volatile String uriPattern = "/SASLogon/login.*$";
    protected volatile boolean fallThrough = false;
    protected volatile String sslClientCert = "SSL_CLIENT_CERT";
    protected volatile String sslClientVerify = "SSL_CLIENT_VERIFY";

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void setFallThrough(String fallThrough) {
        this.fallThrough = Boolean.parseBoolean(fallThrough);
    }

    public void setSslClientCert(String sslClientCert) {
        this.sslClientCert = sslClientCert;
    }

    public void setSslClientVerify(String sslClientVerify) {
        this.sslClientVerify = sslClientVerify;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Principal principal;
        String requestURI = request.getRequestURI();
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            requestURI = requestURI + "?" + request.getQueryString();
        }
        if ((principal = request.getUserPrincipal()) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
        } else if (requestURI.matches(this.uriPattern)) {
            String certString = request.getHeader(this.sslClientCert);
            String verify = request.getHeader(this.sslClientVerify);
            boolean success = false;
            if (certString != null && verify != null) {
                X509Certificate[] certs = this.parseCertificate(certString);
                if (certs != null && certs.length > 0) {
                    if (verify.equals("SUCCESS")) {
                        request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs);
                        principal = this.getContainer().getRealm().authenticate(certs);
                        if (principal != null) {
                            request.setUserPrincipal(principal);
                            log.info((Object)("Successfully authenticated " + principal.getName()));
                            success = true;
                        } else {
                            log.info((Object)"Authentication with Realm failed");
                        }
                    } else {
                        log.info((Object)("Client certificate not verified, received SSL verify code = " + verify));
                    }
                    if (!success) {
                        log.info((Object)("SubjectDN = " + certs[0]));
                    }
                } else {
                    log.info((Object)"Unable to parse certificate from HTTP header");
                }
            }
            if (!success && !this.fallThrough) {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
                return;
            }
        }
        this.getNext().invoke(request, response);
    }

    protected X509Certificate[] parseCertificate(String certString) {
        X509Certificate[] certs;
        block8: {
            certs = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to parse certificate from HTTP header " + this.sslClientCert + ":\n" + certString));
                }
                byte[] raw = certString.getBytes("UTF-8");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < raw.length; ++i) {
                    if (((i - 27) % 65 == 0 || i == raw.length - 26) && raw[i] == 32) {
                        raw[i] = 10;
                    }
                    stringBuffer.append((char)raw[i]);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Base64-Encoded certificate:\n" + stringBuffer.toString()));
                }
                ByteArrayInputStream is = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bufferedInputStream);
                ((InputStream)is).close();
                certs = new X509Certificate[]{cert};
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)e.getMessage());
            }
        }
        if (log.isDebugEnabled() && certs != null) {
            for (void var6_12 : certs) {
                log.debug((Object)("\n" + var6_12.toString()));
            }
        }
        return certs;
    }
}

