/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.components.util.layout.List;
import com.sas.graphics.components.util.layout.NodeInfo;
import com.sas.graphics.components.util.layout.SubdiagramNodeInfo;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.SubdiagramNodeLayoutInterface;
import java.util.Vector;

public class SubdiagramLayeredLayoutStrategy
extends LayeredLayoutStrategy {
    protected SubdiagramNodeInfo mySubdiagram = null;

    public SubdiagramLayeredLayoutStrategy(SubdiagramNodeInfo subdiagram) {
        this.mySubdiagram = subdiagram;
    }

    @Override
    public boolean arrange() {
        if (this.mySubdiagram == null || this.mySubdiagram.subdiagram == null || this.model == null) {
            return false;
        }
        if (this.assignNewOnly && this.prevOrientation == -1) {
            this.prevOrientation = this.orientation;
        }
        boolean redo = true;
        this.firstTime = true;
        while (redo) {
            int num;
            NodeInfo ni;
            redo = false;
            this.doSetupSubdiagramModel();
            if (this.nodes == null || this.nodes.isEmpty()) {
                return false;
            }
            this.totalNodes = this.numNodes;
            this.setData();
            this.layoutSubdiagrams();
            this.breakBigNodes();
            int tempmax = 0;
            int maxLayer = -1;
            if (!this.islandsOnly) {
                this.removeCycles();
                this.assignLayers();
                this.optimizeLayers();
                this.createDummyNodes();
                this.createSubdiagramDummyNodes();
                this.allPos = new Vector[this.numDiagrams][this.numLayers];
                this.allLayerWidth = new int[this.numDiagrams][this.numLayers];
                for (int i = 0; i < this.numDiagrams; ++i) {
                    for (int j = 0; j < this.numLayers; ++j) {
                        this.allLayerWidth[i][j] = 0;
                        this.allPos[i][j] = new Vector();
                    }
                }
                int offset = 0;
                this.minrow = 0;
                this.maxrow = 0;
                int prevmax = -1;
                int numNonIslandDiagrams = this.numDiagrams - this.islands.size();
                for (int i = 0; i < numNonIslandDiagrams; ++i) {
                    this.ninfo = (Vector)this.diagrams.elementAt(i);
                    this.roots = (List)this.droots.elementAt(i);
                    this.layerWidth = this.allLayerWidth[i];
                    this.pos = this.allPos[i];
                    this.assignUniformRows();
                    if (!this.assignNewOnly && !this.newLayout && this.crossings != 0) {
                        this.forceNewLayout = true;
                        return this.arrange();
                    }
                    if (this.firstTime && this.numDiagrams > 1) {
                        redo |= this.maxrow - this.minrow >= this.maxSize;
                    }
                    offset -= this.minrow;
                    this.maxrow = 0;
                    for (int j = 0; j < this.ninfo.size(); ++j) {
                        ni = (NodeInfo)this.ninfo.elementAt(j);
                        if (ni == null) continue;
                        ni.col += offset;
                        this.maxrow = Math.max(this.maxrow, ni.col);
                        maxLayer = Math.max(maxLayer, ni.layer);
                    }
                    offset = this.maxrow + 1;
                    prevmax = tempmax = Math.max(tempmax, offset);
                }
            } else {
                maxLayer = this.userLayers == -1 ? 16 : this.userLayers;
                int tempNumLayers = Math.max(this.maxlayersize, maxLayer + 1);
                this.allPos = new Vector[this.numDiagrams][tempNumLayers];
                this.allLayerWidth = new int[this.numDiagrams][tempNumLayers];
                for (int i = 0; i < this.numDiagrams; ++i) {
                    for (int j = 0; j < tempNumLayers; ++j) {
                        this.allLayerWidth[i][j] = 0;
                        this.allPos[i][j] = new Vector();
                    }
                }
            }
            if ((num = this.islands.size()) > 0) {
                int colSize = 1;
                int curLayer = 0;
                int curCol = tempmax;
                for (int i = 0; i < num; ++i) {
                    ni = (NodeInfo)this.islands.elementAt(i);
                    if (!this.assignNewOnly || !ni.node.isNodePlaced()) {
                        if (curLayer + ni.layersize - 1 > maxLayer) {
                            curLayer = 0;
                            curCol += colSize;
                            colSize = 1;
                        }
                        ni.setColumn(curCol);
                        ni.setLayer(curLayer);
                        curLayer += ni.layersize;
                    }
                    colSize = Math.max(colSize, ni.colsize);
                    this.numLayers = Math.max(this.numLayers, ni.layer + ni.layersize);
                    for (int j = 0; j < ni.layersize; ++j) {
                        Vector v = this.allPos[ni.diagramId][ni.layer + j];
                        for (int k = 0; k < ni.colsize; ++k) {
                            NodeInfo nk = ni.getChild(j, k);
                            v.addElement(nk);
                        }
                        this.allLayerWidth[ni.diagramId][ni.layer + j] = v.size();
                    }
                }
                tempmax = curCol + colSize;
                this.totalNodes = this.allinfo.size();
            }
            this.minrow = 0;
            this.maxrow = tempmax;
            this.mySubdiagram.childInfo = this.allinfo;
            this.mySubdiagram.layersize = this.numLayers;
            this.mySubdiagram.colsize = this.maxrow;
            this.firstTime = false;
        }
        this.layeringDone = true;
        this.forceNewLayout = false;
        return true;
    }

    private void doSetupSubdiagramModel() {
        this.nodes = this.mySubdiagram.subdiagram.getChildNodes();
        this.links = this.mySubdiagram.subdiagram.getInternalLinks();
        this.adjustModel();
        this.numNodes = this.nodes.size();
        this.numLinks = this.links.size();
    }

    private void createSubdiagramDummyNodes() {
        NodeInfo dni;
        NodeLayoutInterface dn;
        int j;
        NodeInfo last;
        int inc;
        int endIdx;
        int startIdx;
        Vector<NodeInfo> dummy;
        LinkLayoutInterface arc;
        int i;
        Vector externalLinks = this.mySubdiagram.subdiagram.getExternalLinks();
        Vector<LinkLayoutInterface> inLinks = new Vector<LinkLayoutInterface>();
        Vector<LinkLayoutInterface> outLinks = new Vector<LinkLayoutInterface>();
        for (i = 0; i < externalLinks.size(); ++i) {
            LinkLayoutInterface l = (LinkLayoutInterface)externalLinks.elementAt(i);
            if (!l.isVisible()) continue;
            if (this.mySubdiagram.subdiagram.isChildNode(l.getTopFromNode())) {
                outLinks.add(l);
                continue;
            }
            inLinks.add(l);
        }
        for (i = 0; i < inLinks.size(); ++i) {
            arc = (LinkLayoutInterface)inLinks.elementAt(i);
            NodeInfo toInfo = this.getNodeInfoFromNode(arc.getTopToNode());
            if (toInfo == null) continue;
            dummy = new Vector<NodeInfo>();
            this.mySubdiagram.externalDummys.put(arc, dummy);
            startIdx = 0;
            endIdx = toInfo.layer;
            inc = 1;
            last = null;
            if (this.revtree) {
                startIdx = toInfo.layer + toInfo.layersize;
                endIdx = this.numLayers;
                inc = 1;
                dummy.add(toInfo);
                last = toInfo;
            }
            for (j = startIdx; j < endIdx; j += inc) {
                dn = this.model.createDummyNode(10, 10);
                dni = new NodeInfo(dn, this.allinfo.size());
                dni.dummy = true;
                dni.diagramId = toInfo.diagramId;
                if (this.revtree) {
                    dummy.add(0, dni);
                } else {
                    dummy.addElement(dni);
                }
                this.nodes.addElement(dn);
                this.allinfo.addElement(dni);
                ((Vector)this.diagrams.elementAt(dni.diagramId)).addElement(dni);
                dni.setLayer(j);
                if (last != null) {
                    dni.inEdges.addElement(last);
                    last.outEdges.addElement(dni);
                }
                last = dni;
            }
            if (this.revtree) continue;
            dummy.addElement(toInfo);
            if (last == null) continue;
            toInfo.inEdges.addElement(last);
            last.outEdges.addElement(toInfo);
        }
        for (i = 0; i < outLinks.size(); ++i) {
            arc = (LinkLayoutInterface)outLinks.elementAt(i);
            NodeInfo fromInfo = this.getNodeInfoFromNode(arc.getTopFromNode());
            if (fromInfo == null) continue;
            dummy = new Vector();
            this.mySubdiagram.externalDummys.put(arc, dummy);
            startIdx = fromInfo.layer + fromInfo.layersize;
            endIdx = this.numLayers;
            inc = 1;
            last = null;
            if (this.revtree) {
                startIdx = 0;
                endIdx = fromInfo.layer;
                inc = 1;
            } else {
                dummy.addElement(fromInfo);
                last = fromInfo;
            }
            for (j = startIdx; j < endIdx; j += inc) {
                dn = this.model.createDummyNode(10, 10);
                dni = new NodeInfo(dn, this.allinfo.size());
                dni.dummy = true;
                dni.diagramId = fromInfo.diagramId;
                if (this.revtree) {
                    dummy.add(0, dni);
                } else {
                    dummy.addElement(dni);
                }
                this.nodes.addElement(dn);
                this.allinfo.addElement(dni);
                ((Vector)this.diagrams.elementAt(dni.diagramId)).addElement(dni);
                dni.setLayer(j);
                if (last != null) {
                    dni.inEdges.addElement(last);
                    last.outEdges.addElement(dni);
                }
                last = dni;
            }
            if (!this.revtree) continue;
            dummy.add(0, fromInfo);
            if (last == null) continue;
            fromInfo.inEdges.addElement(last);
            last.outEdges.addElement(fromInfo);
        }
        this.totalNodes = this.allinfo.size();
    }

    public static void arrangeExpandedSubdiagram(SubdiagramNodeLayoutInterface subdiagramNode, LayeredLayoutStrategy parentLayout) {
        SubdiagramNodeInfo sni = new SubdiagramNodeInfo(subdiagramNode, 0, parentLayout);
        sni.arrange();
        sni.layer = 0;
        sni.col = 0;
        sni.assignCoords();
    }
}

