/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDPathDiagramCurvedLink;
import com.sas.graphics.components.pfd.PFDPathDiagramModel;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPathDiagramSelfLink;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.components.util.layout.LayoutStrategy;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Point;
import java.util.Vector;

public class PathDiagramLayeredLayout
extends LayoutStrategy {
    private Vector<PathDiagramLinkLayoutInterface> subsetLinks = null;
    private Vector<NodeLayoutInterface> subsetNodes = null;
    private PFDPathDiagramModel subsetModel = null;
    private LayeredLayoutStrategy layoutStrategy = null;
    private Vector<PathDiagramLinkLayoutInterface> curvedLinks = null;
    private Vector<PathDiagramLinkLayoutInterface> selfLinks = null;
    private Vector<PathDiagramLinkLayoutInterface> p1p3Links = null;
    private Vector<PathDiagramLinkLayoutInterface> p2p3Links = null;
    private Vector<PathDiagramLinkLayoutInterface> nonP1Links = null;
    private Vector<PathDiagramNodeLayoutInterface> p3DirectNodes = null;
    private Vector<PathDiagramNodeLayoutInterface> p3Nodes = null;
    private static final int ERROR_LINK_LENGTH = 30;
    private double gridScaleFactor = 1.0;

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    @Override
    public boolean arrange() {
        int i;
        Point fromCenter;
        PFDPathDiagramNode tn;
        PathDiagramNodeLayoutInterface toNode;
        PathDiagramNodeLayoutInterface fromNode;
        PathDiagramLinkLayoutInterface link;
        int i2;
        if (this.model == null) {
            return false;
        }
        if (this.layoutStrategy != null) {
            this.layoutStrategy.arrange();
        }
        for (i2 = 0; i2 < this.p2p3Links.size(); ++i2) {
            link = this.p2p3Links.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)link.getFromNode();
            toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            tn = (PFDPathDiagramNode)toNode;
            Point toRight = tn.getDrawable().getSpotLocation(4, null);
            fromCenter = new Point(toRight.x + (int)(30.0 * this.gridScaleFactor) + fromNode.getWidth() / 2, toRight.y);
            fromNode.setCenterLocation(fromCenter);
        }
        for (i2 = 0; i2 < this.p1p3Links.size(); ++i2) {
            link = this.p1p3Links.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)link.getFromNode();
            toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            tn = (PFDPathDiagramNode)toNode;
            Point toCenter = tn.getDrawable().getSpotLocation(6, null);
            fromCenter = new Point(toCenter.x, toCenter.y + (int)(30.0 * this.gridScaleFactor) + fromNode.getHeight() / 2);
            fromNode.setCenterLocation(fromCenter);
        }
        for (i2 = 0; i2 < this.selfLinks.size(); ++i2) {
            PFDPathDiagramSelfLink pdsl = (PFDPathDiagramSelfLink)this.selfLinks.elementAt(i2);
            fromNode = (PathDiagramNodeLayoutInterface)pdsl.getFromNode();
            int loc = 2;
            if (this.p3DirectNodes.contains(fromNode)) {
                loc = 6;
            }
            pdsl.setRelativeLocation(loc, true);
        }
        Vector allNodes = this.model.getAllNodes();
        double minX = Double.MAX_VALUE;
        for (i = 0; i < allNodes.size(); ++i) {
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.elementAt(i);
            minX = Math.min(minX, node.getCenterLocation().getX());
        }
        for (i = 0; i < this.curvedLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface link2 = this.curvedLinks.elementAt(i);
            PathDiagramNodeLayoutInterface fromNode2 = (PathDiagramNodeLayoutInterface)link2.getFromNode();
            PathDiagramNodeLayoutInterface toNode2 = (PathDiagramNodeLayoutInterface)link2.getToNode();
            PFDPathDiagramCurvedLink pdcl = null;
            if (link2 instanceof PFDPathDiagramCurvedLink) {
                pdcl = (PFDPathDiagramCurvedLink)link2;
            }
            if (pdcl == null) continue;
            Point fp = fromNode2.getCenterLocation();
            Point tp = toNode2.getCenterLocation();
            if (fp.x == tp.x && (double)fp.x == minX) {
                double multiplier = (double)Math.abs(fp.y - tp.y) / (double)(2 * fromNode2.getWidth());
                int offset = (int)((double)fromNode2.getWidth() * multiplier);
                pdcl.setControlPoint(new Point(fp.x - offset, (fp.y + tp.y) / 2));
                continue;
            }
            PathDiagramLayeredLayout.computeLinkControlPoint(pdcl, fromNode2, toNode2);
        }
        return true;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        super.setModel(m);
        this.doSetupModel();
    }

    @Override
    void doSetupModel() {
        super.doSetupModel();
        this.subsetLinks = new Vector();
        this.subsetNodes = new Vector();
        this.p3DirectNodes = new Vector();
        this.p3Nodes = new Vector();
        this.curvedLinks = new Vector();
        this.selfLinks = new Vector();
        this.p1p3Links = new Vector();
        this.p2p3Links = new Vector();
        this.nonP1Links = new Vector();
        Vector allLinks = this.model.getAllLinks();
        for (int i = 0; i < allLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface pdli = (PathDiagramLinkLayoutInterface)allLinks.get(i);
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)pdli.getToNode();
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)pdli.getFromNode();
            if (pdli.getLinkPriority() != 1 && pdli.getLinkPriority() != 2) {
                this.model.removeLink(pdli);
                continue;
            }
            if (fromNode == toNode) {
                this.selfLinks.add(pdli);
                ((PFDPathDiagramSelfLink)pdli).setGridScaleFactor(this.gridScaleFactor);
                continue;
            }
            if (pdli.getLinkDirection() == 3 || pdli.getLinkPriority() != 1) {
                this.curvedLinks.add(pdli);
                continue;
            }
            if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
                if (toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1) {
                    this.p3DirectNodes.add(fromNode);
                    this.p1p3Links.add(pdli);
                    continue;
                }
                this.p3Nodes.add(fromNode);
                this.p2p3Links.add(pdli);
                continue;
            }
            this.subsetLinks.add(pdli);
        }
        Vector allNodes = this.model.getAllNodes();
        for (int i = 0; i < allNodes.size(); ++i) {
            PFDPathDiagramNode node = (PFDPathDiagramNode)allNodes.elementAt(i);
            if (this.p3Nodes.contains(node) || this.p3DirectNodes.contains(node)) continue;
            this.subsetNodes.add(node);
        }
        this.subsetModel = new PFDPathDiagramModel(this.subsetNodes, this.subsetLinks);
        this.layoutStrategy = new LayeredLayoutStrategy();
        this.layoutStrategy.setModel(this.subsetModel);
        this.layoutStrategy.setGridHeight((int)Math.ceil((double)this.layoutStrategy.getGridHeight() * this.gridScaleFactor));
        this.layoutStrategy.setGridWidth((int)Math.ceil((double)this.layoutStrategy.getGridWidth() * this.gridScaleFactor));
    }

    public static void computeLinkControlPoint(PFDPathDiagramCurvedLink pdcl, PathDiagramNodeLayoutInterface fromNode, PathDiagramNodeLayoutInterface toNode) {
        Point fp = fromNode.getCenterLocation();
        Point tp = toNode.getCenterLocation();
        Point cp = new Point();
        if (fp.y == tp.y) {
            cp.setLocation((double)((fp.x + tp.x) / 2), (double)fp.y - 1.5 * (double)fromNode.getWidth());
        } else if (fp.x == tp.x) {
            double multiplier = (double)Math.abs(fp.y - tp.y) / (double)(2 * fromNode.getWidth());
            int offset = (int)((double)fromNode.getWidth() * multiplier);
            cp.setLocation(fp.x + offset, (fp.y + tp.y) / 2);
        } else {
            cp.x = (int)((double)((fp.x + tp.x) / 2) - 0.7 * (double)fromNode.getHeight());
            cp.y = fp.y < tp.y ? (int)((double)((fp.y + tp.y) / 2) - 0.7 * (double)fromNode.getHeight()) : (int)((double)((fp.y + tp.y) / 2) + 0.7 * (double)fromNode.getHeight());
        }
        pdcl.setControlPoint(cp);
    }
}

