/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPathDiagramCurvedLink;
import com.sas.graphics.components.pfd.PFDPathDiagramGroupNode;
import com.sas.graphics.components.pfd.PFDPathDiagramLink;
import com.sas.graphics.components.pfd.PFDPathDiagramModel;
import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.pfd.PFDPathDiagramSelfLink;
import com.sas.graphics.components.util.layout.CustomLinkedList;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.components.util.layout.LayoutStrategy;
import com.sas.graphics.components.util.layout.PathDiagramLayeredLayout;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramLinkLayoutInterface;
import com.sas.graphics.interfaces.PathDiagramNodeLayoutInterface;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

public class PathDiagramGroupLayeredLayout
extends LayoutStrategy {
    private Hashtable<PathDiagramNodeLayoutInterface, PFDPathDiagramGroupNode> groupNodeMap = new Hashtable();
    private Vector<NodeLayoutInterface> subsetNodes = null;
    private Vector<PathDiagramLinkLayoutInterface> subsetLinks = null;
    private PFDPathDiagramModel subsetModel = null;
    private LayeredLayoutStrategy layoutStrategy = null;
    private Hashtable<PathDiagramNodeLayoutInterface, Vector<PathDiagramNodeLayoutInterface>> secondaryNodesMap = new Hashtable();
    private Hashtable<PathDiagramNodeLayoutInterface, Vector<Integer>> secondaryNodesHeightMap = new Hashtable();
    private Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> p2Top3LinksMap = new Hashtable();
    protected boolean firstTime = true;
    private static final int BEFORE = 1;
    private static final int AFTER = 2;
    private Vector<PathDiagramLinkLayoutInterface> p2Top3Links = new Vector();
    private Vector<PathDiagramLinkLayoutInterface> curvedLinks = new Vector();
    private Vector<PathDiagramLinkLayoutInterface> selfLinks = new Vector();
    private Vector<PathDiagramLinkLayoutInterface> links = new Vector();
    private static int UNDEFINED_SECONDARY_LINKS_TYPE = -1;
    private static int P2_SECONDARY_LINKS = 1;
    private static int P3_SECONDARY_LINKS = 2;
    int secondaryLinksType = UNDEFINED_SECONDARY_LINKS_TYPE;
    private double gridScaleFactor = 1.0;

    public void setGridScaleFactor(double fac) {
        this.gridScaleFactor = fac;
    }

    @Override
    public boolean arrange() {
        int i;
        if (this.model == null) {
            return false;
        }
        if (this.layoutStrategy != null) {
            this.layoutStrategy.arrange();
        }
        for (i = 0; i < this.curvedLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface link = this.curvedLinks.elementAt(i);
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)link.getFromNode();
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)link.getToNode();
            PFDPathDiagramCurvedLink pdcl = null;
            if (link instanceof PFDPathDiagramCurvedLink) {
                pdcl = (PFDPathDiagramCurvedLink)link;
            }
            if (pdcl == null) continue;
            if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1 || pdcl.getLinkPriority() != 1) {
                PathDiagramLayeredLayout.computeLinkControlPoint(pdcl, fromNode, toNode);
                continue;
            }
            if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2 || fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
                Vector<PathDiagramNodeLayoutInterface> linkedNodes = this.secondaryNodesMap.get(fromNode);
                Vector<Integer> heights = this.secondaryNodesHeightMap.get(fromNode);
                int linkArcHeight = heights.elementAt(linkedNodes.indexOf(toNode));
                Point fp = fromNode.getCenterLocation();
                Point tp = toNode.getCenterLocation();
                Point cp = new Point();
                cp.x = (fp.x + tp.x) / 2;
                double multiplier = 1 + ((linkArcHeight + 2) * (linkArcHeight + 1) / 2 - 3) / 2;
                cp.y = (int)((double)(fp.y + fromNode.getHeight() / 2) + multiplier * 50.0);
                pdcl.setControlPoint(cp);
                continue;
            }
            PathDiagramLayeredLayout.computeLinkControlPoint(pdcl, fromNode, toNode);
        }
        for (i = 0; i < this.selfLinks.size(); ++i) {
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)this.selfLinks.elementAt(i).getFromNode();
            PFDPathDiagramSelfLink pdsl = (PFDPathDiagramSelfLink)this.selfLinks.elementAt(i);
            if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1 || fromNode.isDirectErrorNode()) {
                pdsl.setRelativeLocation(2, true);
                continue;
            }
            pdsl.setRelativeLocation(6, true);
        }
        return true;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        super.setModel(m);
        this.doSetupModel();
    }

    @Override
    void doSetupModel() {
        super.doSetupModel();
        this.subsetLinks = new Vector();
        Vector allLinks = this.model.getAllLinks();
        Hashtable<PathDiagramNodeLayoutInterface, Integer> nodeConnectivityCount = new Hashtable<PathDiagramNodeLayoutInterface, Integer>();
        Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> groupNodeTable = new Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface>();
        Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface> reverseGroupNodeTable = new Hashtable<PathDiagramNodeLayoutInterface, PathDiagramNodeLayoutInterface>();
        for (int i = 0; i < allLinks.size(); ++i) {
            PathDiagramLinkLayoutInterface pdli = (PathDiagramLinkLayoutInterface)allLinks.get(i);
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)pdli.getToNode();
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)pdli.getFromNode();
            if (pdli.getLinkPriority() != 1 && pdli.getLinkPriority() != 2) {
                this.model.removeLink(pdli);
                continue;
            }
            if (pdli.getLinkPriority() == 1 && pdli.getLinkDirection() != 3 && pdli.getToNode() != pdli.getFromNode() && (toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1 || fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1)) {
                this.links.add(pdli);
            } else if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 || fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2) {
                this.p2Top3Links.add(pdli);
                this.p2Top3LinksMap.put(fromNode, toNode);
                this.p2Top3LinksMap.put(toNode, fromNode);
            } else if (fromNode == toNode) {
                this.selfLinks.add(pdli);
                ((PFDPathDiagramSelfLink)pdli).setGridScaleFactor(this.gridScaleFactor);
            } else {
                this.curvedLinks.add(pdli);
            }
            if (this.secondaryLinksType == UNDEFINED_SECONDARY_LINKS_TYPE && fromNode != toNode) {
                if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2) {
                    this.secondaryLinksType = P2_SECONDARY_LINKS;
                } else if (fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 && toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
                    this.secondaryLinksType = P3_SECONDARY_LINKS;
                }
            }
            if (fromNode == toNode) continue;
            if ((fromNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1 || toNode.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1) && pdli.getLinkPriority() == 1) {
                int cnt;
                if (nodeConnectivityCount.containsKey(fromNode)) {
                    cnt = (Integer)nodeConnectivityCount.get(fromNode);
                    nodeConnectivityCount.put(fromNode, ++cnt);
                } else {
                    nodeConnectivityCount.put(fromNode, 1);
                }
                if (nodeConnectivityCount.containsKey(toNode)) {
                    cnt = (Integer)nodeConnectivityCount.get(toNode);
                    nodeConnectivityCount.put(toNode, ++cnt);
                } else {
                    nodeConnectivityCount.put(toNode, 1);
                }
                groupNodeTable.put(fromNode, toNode);
                reverseGroupNodeTable.put(toNode, fromNode);
                continue;
            }
            if ((fromNode.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_3 || toNode.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_3) && (fromNode.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_2 || toNode.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_2)) continue;
            Vector<Object> linkedNodes = null;
            Vector<Object> linkedNodeHeights = null;
            if (!this.secondaryNodesMap.containsKey(fromNode)) {
                linkedNodes = new Vector();
                this.secondaryNodesMap.put(fromNode, linkedNodes);
                linkedNodeHeights = new Vector();
                this.secondaryNodesHeightMap.put(fromNode, linkedNodeHeights);
            }
            linkedNodes = this.secondaryNodesMap.get(fromNode);
            linkedNodes.add(toNode);
            linkedNodeHeights = this.secondaryNodesHeightMap.get(fromNode);
            linkedNodeHeights.add(0);
            if (!this.secondaryNodesMap.containsKey(toNode)) {
                linkedNodes = new Vector();
                this.secondaryNodesMap.put(toNode, linkedNodes);
                linkedNodeHeights = new Vector();
                this.secondaryNodesHeightMap.put(toNode, linkedNodeHeights);
            }
            linkedNodes = this.secondaryNodesMap.get(toNode);
            linkedNodes.add(fromNode);
            linkedNodeHeights = this.secondaryNodesHeightMap.get(toNode);
            linkedNodeHeights.add(0);
            ((PFDLink)((Object)pdli)).setMiddleLabelPosition(3);
        }
        this.subsetNodes = new Vector();
        Vector allNodes = this.model.getAllNodes();
        for (int i = 0; i < allNodes.size(); ++i) {
            PathDiagramNodeLayoutInterface node = (PathDiagramNodeLayoutInterface)allNodes.get(i);
            if (!nodeConnectivityCount.containsKey(node)) {
                nodeConnectivityCount.put(node, 0);
            }
            if (node.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_1 && (Integer)nodeConnectivityCount.get(node) <= 1) {
                PFDPathDiagramGroupNode gn;
                PathDiagramNodeLayoutInterface pdni = null;
                PathDiagramNodeLayoutInterface p2n = null;
                p2n = node.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 ? this.p2Top3LinksMap.get(node) : node;
                if (p2n == null) {
                    pdni = (PathDiagramNodeLayoutInterface)groupNodeTable.get(node);
                    if (pdni == null) {
                        pdni = (PathDiagramNodeLayoutInterface)reverseGroupNodeTable.get(node);
                    }
                } else if (groupNodeTable.containsKey(p2n)) {
                    pdni = (PathDiagramNodeLayoutInterface)groupNodeTable.get(p2n);
                } else if (reverseGroupNodeTable.containsKey(p2n)) {
                    pdni = (PathDiagramNodeLayoutInterface)reverseGroupNodeTable.get(p2n);
                }
                if (pdni == null || pdni.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_1) continue;
                if (!this.groupNodeMap.containsKey(pdni)) {
                    gn = new PFDPathDiagramGroupNode();
                    gn.setGridScaleFactor(this.gridScaleFactor);
                    gn.setMainNode(pdni);
                    gn.setP2P3NodesMap(this.p2Top3LinksMap);
                    this.subsetNodes.add(gn);
                    this.groupNodeMap.put(pdni, gn);
                }
                gn = this.groupNodeMap.get(pdni);
                if (node.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_2) {
                    gn.addPriority2Node(node);
                    continue;
                }
                if (node.getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_3) continue;
                gn.addPriority3Node(node);
                continue;
            }
            if (node.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_1) {
                if (this.groupNodeMap.containsKey(node)) continue;
                PFDPathDiagramGroupNode gn = new PFDPathDiagramGroupNode();
                gn.setGridScaleFactor(this.gridScaleFactor);
                gn.setMainNode(node);
                gn.setP2P3NodesMap(this.p2Top3LinksMap);
                this.subsetNodes.add(gn);
                this.groupNodeMap.put(node, gn);
                continue;
            }
            this.subsetNodes.add(node);
        }
        Hashtable linkProcessedMap = new Hashtable();
        Enumeration<PathDiagramNodeLayoutInterface> e = this.groupNodeMap.keys();
        while (e.hasMoreElements()) {
            PathDiagramNodeLayoutInterface node = e.nextElement();
            PFDPathDiagramGroupNode gn = this.groupNodeMap.get(node);
            Vector<PathDiagramNodeLayoutInterface> secondaryNodes = null;
            secondaryNodes = this.secondaryLinksType == P3_SECONDARY_LINKS ? gn.getPriority3Nodes() : gn.getPriority2Nodes();
            CustomLinkedList<PathDiagramNodeLayoutInterface> completeList = gn.getPriority2NodesOrderedList();
            LinkedList<PathDiagramNodeLayoutInterface> queue = new LinkedList<PathDiagramNodeLayoutInterface>();
            Vector<PathDiagramNodeLayoutInterface> sortedSecondaryNodes = this.sortNodesByConnectivity(secondaryNodes);
            Hashtable<PathDiagramNodeLayoutInterface, Integer> linksUnderRightCounts = gn.getLinksUnderCountMap();
            gn.setMaxLinkDepth(0);
            for (int i = 0; i < sortedSecondaryNodes.size(); ++i) {
                PathDiagramNodeLayoutInterface n = sortedSecondaryNodes.elementAt(i);
                if (completeList.contains(n)) continue;
                queue.add(n);
                CustomLinkedList<PathDiagramNodeLayoutInterface> orderedList = new CustomLinkedList<PathDiagramNodeLayoutInterface>();
                orderedList.linkLast(n);
                while (!queue.isEmpty()) {
                    n = (PathDiagramNodeLayoutInterface)queue.remove();
                    Vector<PathDiagramNodeLayoutInterface> linkedNodes = this.secondaryNodesMap.get(n);
                    Vector<Integer> heights = this.secondaryNodesHeightMap.get(n);
                    if (!linkProcessedMap.containsKey(n)) {
                        linkProcessedMap.put(n, new Hashtable());
                    }
                    Hashtable linkedNodesMap = (Hashtable)linkProcessedMap.get(n);
                    for (int j = 0; linkedNodes != null && j < linkedNodes.size(); ++j) {
                        NodeRange nr;
                        PathDiagramNodeLayoutInterface r = linkedNodes.elementAt(j);
                        if (linkedNodesMap.containsKey(r)) continue;
                        PathDiagramNodeLayoutInterface p2nr = null;
                        PathDiagramNodeLayoutInterface p2nn = null;
                        if (this.secondaryLinksType == P3_SECONDARY_LINKS) {
                            p2nn = this.p2Top3LinksMap.containsKey(n) ? this.p2Top3LinksMap.get(n) : n;
                            p2nr = this.p2Top3LinksMap.containsKey(r) ? this.p2Top3LinksMap.get(r) : r;
                        } else {
                            p2nn = n;
                            p2nr = r;
                        }
                        if (reverseGroupNodeTable.get(p2nr) != reverseGroupNodeTable.get(p2nn)) {
                            heights.set(j, 2);
                            continue;
                        }
                        if (orderedList.contains(r)) {
                            int indexR;
                            nr = null;
                            int indexN = orderedList.indexOf(n);
                            nr = indexN < (indexR = orderedList.indexOf(r)) ? new NodeRange(n, r) : new NodeRange(r, n);
                            NodeRange nr2 = new NodeRange(nr.getStart(), nr.getEnd());
                            Vector<PathDiagramNodeLayoutInterface> intermediateNodes = this.getIntermediateNodes(nr, orderedList);
                            this.computeNonIntersectingNodeRange(nr, intermediateNodes, orderedList);
                            this.incrementLinkUnderCounts(nr, linksUnderRightCounts, orderedList);
                            int maxHeight = 0;
                            if (nr.getStart() != nr.getEnd()) {
                                maxHeight = this.getMaximumContainedHeight(nr, orderedList);
                            } else {
                                PathDiagramNodeLayoutInterface pv = orderedList.getPrevious(nr2.getEnd());
                                maxHeight = Math.max(linksUnderRightCounts.get(nr.getStart()), linksUnderRightCounts.get(pv)) - 1;
                            }
                            heights.set(j, maxHeight + 1);
                        } else if (!orderedList.hasPrevious(n)) {
                            orderedList.linkBefore(r, n);
                            linksUnderRightCounts.put(r, 1);
                            heights.set(j, 1);
                        } else if (!orderedList.hasNext(n)) {
                            orderedList.linkAfter(r, n);
                            linksUnderRightCounts.put(n, 1);
                            heights.set(j, 1);
                        } else {
                            nr = new NodeRange(null, null);
                            PathDiagramNodeLayoutInterface cn = n;
                            PathDiagramNodeLayoutInterface cp = n;
                            PathDiagramNodeLayoutInterface insertionNode = null;
                            boolean insertBefore = true;
                            while (insertionNode == null) {
                                int nnc;
                                PathDiagramNodeLayoutInterface prev = orderedList.getPrevious(cp);
                                PathDiagramNodeLayoutInterface next = orderedList.getNext(cn);
                                int rnc = this.getNumberOfConnections(r);
                                int pnc = prev == null ? 0 : this.getNumberOfConnections(prev);
                                int n2 = nnc = next == null ? 0 : this.getNumberOfConnections(next);
                                if (prev == null || !this.isConnected(n, prev) || rnc < pnc) {
                                    nr.setStart(r);
                                    nr.setEnd(n);
                                    insertionNode = cp;
                                    insertBefore = true;
                                    continue;
                                }
                                if (next == null || !this.isConnected(n, next) || rnc < nnc) {
                                    insertionNode = cn;
                                    insertBefore = false;
                                    nr.setStart(n);
                                    nr.setEnd(r);
                                    continue;
                                }
                                cp = prev;
                                cn = next;
                            }
                            if (insertionNode == n) {
                                if (insertBefore) {
                                    PathDiagramNodeLayoutInterface prev = orderedList.getPrevious(n);
                                    int prevCount = linksUnderRightCounts.get(prev);
                                    orderedList.linkBefore(r, n);
                                    linksUnderRightCounts.put(r, prevCount + 1);
                                    this.incrementLinkHeights(1, orderedList, linkedNodes, heights, r, gn);
                                } else {
                                    int prevCount = linksUnderRightCounts.get(n);
                                    orderedList.linkAfter(r, n);
                                    linksUnderRightCounts.put(r, prevCount);
                                    linksUnderRightCounts.put(n, prevCount + 1);
                                    this.incrementLinkHeights(2, orderedList, linkedNodes, heights, r, gn);
                                }
                                heights.set(j, 1);
                            } else {
                                NodeRange nr2;
                                PathDiagramNodeLayoutInterface pv;
                                if (insertBefore) {
                                    orderedList.linkBefore(r, insertionNode);
                                    linksUnderRightCounts.put(r, linksUnderRightCounts.get(insertionNode));
                                    pv = insertionNode;
                                    int pvLinkHeight = heights.get(linkedNodes.indexOf(pv));
                                    heights.set(j, pvLinkHeight + 1);
                                    this.incrementLinkHeights(1, orderedList, linkedNodes, heights, r, gn);
                                    nr2 = new NodeRange(insertionNode, nr.getEnd());
                                    this.incrementLinkUnderCounts(nr2, linksUnderRightCounts, orderedList);
                                } else {
                                    orderedList.linkAfter(r, insertionNode);
                                    pv = orderedList.getPrevious(insertionNode);
                                    linksUnderRightCounts.put(insertionNode, linksUnderRightCounts.get(pv));
                                    int nxtLinkHeight = heights.get(linkedNodes.indexOf(insertionNode));
                                    heights.set(j, nxtLinkHeight + 1);
                                    this.incrementLinkHeights(2, orderedList, linkedNodes, heights, r, gn);
                                    nr2 = new NodeRange(nr.getStart(), insertionNode);
                                    this.incrementLinkUnderCounts(nr, linksUnderRightCounts, orderedList);
                                }
                                Vector<PathDiagramNodeLayoutInterface> intermediateNodes = this.getIntermediateNodes(nr, orderedList);
                                this.computeNonIntersectingNodeRange(nr, intermediateNodes, orderedList);
                            }
                        }
                        gn.setMaxLinkDepth(Math.max(gn.getMaxLinkDepth(), heights.get(j)));
                        linkedNodesMap.put(r, Boolean.TRUE);
                        if (!linkProcessedMap.containsKey(r)) {
                            linkProcessedMap.put(r, new Hashtable());
                        }
                        ((Hashtable)linkProcessedMap.get(r)).put(n, Boolean.TRUE);
                        queue.add(r);
                    }
                }
                if (this.secondaryLinksType == P3_SECONDARY_LINKS) {
                    PathDiagramNodeLayoutInterface listNode = (PathDiagramNodeLayoutInterface)orderedList.getFirst();
                    while (listNode != null) {
                        PathDiagramNodeLayoutInterface p2n = this.p2Top3LinksMap.get(listNode);
                        if (p2n != null) {
                            completeList.linkLast(p2n);
                        }
                        listNode = orderedList.getNext(listNode);
                    }
                    continue;
                }
                completeList.linkLast(orderedList);
            }
            gn.computeSize();
        }
        for (int i = 0; i < this.links.size(); ++i) {
            PFDPathDiagramGroupNode gn;
            PathDiagramLinkLayoutInterface pdli = this.links.get(i);
            PathDiagramNodeLayoutInterface toNode = (PathDiagramNodeLayoutInterface)pdli.getToNode();
            PathDiagramNodeLayoutInterface fromNode = (PathDiagramNodeLayoutInterface)pdli.getFromNode();
            if (this.subsetNodes.contains(fromNode) && this.subsetNodes.contains(toNode)) {
                this.subsetLinks.add(this.links.elementAt(i));
                continue;
            }
            PFDAbstractNode fn = null;
            PFDAbstractNode tn = null;
            if (!this.subsetNodes.contains(fromNode)) {
                gn = this.groupNodeMap.get(fromNode);
                fn = gn;
            } else {
                fn = (PFDAbstractNode)((Object)fromNode);
            }
            if (!this.subsetNodes.contains(toNode)) {
                gn = this.groupNodeMap.get(toNode);
                tn = gn;
            } else {
                tn = (PFDAbstractNode)((Object)toNode);
            }
            if (fn == null || tn == null) continue;
            PathDiagramLinkLayoutInterface link = null;
            PFDLink pl = null;
            if (pdli instanceof PFDPathDiagramLink) {
                PFDPathDiagramLink pdl = new PFDPathDiagramLink(fn.getOutputPort(), tn.getInputPort());
                PFDPathDiagramLink pl2 = (PFDPathDiagramLink)pdli;
                pdl.addPropertyChangeListener(pl2);
                this.subsetLinks.add(pdl);
                link = pdl;
            } else if (pdli instanceof PFDPathDiagramCurvedLink) {
                PFDPathDiagramCurvedLink pdcl = new PFDPathDiagramCurvedLink(fn.getOutputPort(), tn.getInputPort(), new Point(0, 0));
                this.subsetLinks.add(pdcl);
                link = pdcl;
                pl = pdcl;
            } else if (pdli instanceof PFDPathDiagramSelfLink) {
                PFDPathDiagramSelfLink pdsl = new PFDPathDiagramSelfLink(fn.getOutputPort(), 2);
                this.subsetLinks.add(pdsl);
                link = pdsl;
                pl = pdsl;
            }
            link.setLinkDirection(pdli.getLinkDirection());
            if (link == null) continue;
            PFDLink ol = (PFDLink)((Object)pdli);
            PFDLink nl = (PFDLink)((Object)link);
            nl.setFromArrowVisible(ol.isFromArrowVisible());
            nl.setToArrowVisible(ol.isToArrowVisible());
            nl.setMiddleLabel(ol.getMiddleLabel());
            nl.setMiddleLabelVisible(ol.isMiddleLabelVisible());
        }
        this.subsetModel = new PFDPathDiagramModel(this.subsetNodes, this.subsetLinks);
        this.layoutStrategy = new LayeredLayoutStrategy();
        this.layoutStrategy.setModel(this.subsetModel);
        this.layoutStrategy.setGridHeight((int)Math.ceil((double)this.layoutStrategy.getGridHeight() * this.gridScaleFactor));
        this.layoutStrategy.setGridWidth((int)Math.ceil((double)this.layoutStrategy.getGridWidth() * this.gridScaleFactor));
    }

    private int getMaximumContainedHeight(NodeRange nr, CustomLinkedList<PathDiagramNodeLayoutInterface> orderedList) {
        int maxHeight = 0;
        PathDiagramNodeLayoutInterface node = nr.getStart();
        while (node != nr.getEnd()) {
            Vector<Integer> linkHeights = this.secondaryNodesHeightMap.get(node);
            Vector<PathDiagramNodeLayoutInterface> linkedNodes = this.secondaryNodesMap.get(node);
            for (int i = 0; i < linkedNodes.size(); ++i) {
                PathDiagramNodeLayoutInterface node2 = linkedNodes.elementAt(i);
                if (!orderedList.contains(node2) || !orderedList.isBetween(nr.getStart(), nr.getEnd(), node2)) continue;
                maxHeight = Math.max(maxHeight, linkHeights.elementAt(i));
            }
            node = orderedList.getNext(node);
        }
        return maxHeight;
    }

    private Vector<PathDiagramNodeLayoutInterface> getIntermediateNodes(NodeRange nr, CustomLinkedList<PathDiagramNodeLayoutInterface> orderedList) {
        Vector<PathDiagramNodeLayoutInterface> intermediateNodes = new Vector<PathDiagramNodeLayoutInterface>();
        PathDiagramNodeLayoutInterface t = orderedList.getNext(nr.getStart());
        while (t != nr.getEnd()) {
            intermediateNodes.add(t);
            t = orderedList.getNext(t);
        }
        return intermediateNodes;
    }

    private void computeNonIntersectingNodeRange(NodeRange nr, Vector<PathDiagramNodeLayoutInterface> intermediateNodes, CustomLinkedList<PathDiagramNodeLayoutInterface> orderedList) {
        int startIndex = orderedList.indexOf(nr.getStart());
        int endIndex = orderedList.indexOf(nr.getEnd());
        for (int c = 0; c < intermediateNodes.size(); ++c) {
            PathDiagramNodeLayoutInterface t = intermediateNodes.elementAt(c);
            Vector<PathDiagramNodeLayoutInterface> ln = this.secondaryNodesMap.get(t);
            int nCount = ln == null ? 0 : ln.size();
            for (int cnt = 0; cnt < nCount; ++cnt) {
                PathDiagramNodeLayoutInterface q = ln.elementAt(cnt);
                int idx = orderedList.indexOf(q);
                if (idx < 0 || idx >= startIndex && idx <= endIndex) continue;
                if (idx < startIndex) {
                    nr.setStart(t);
                    continue;
                }
                nr.setEnd(t);
            }
        }
    }

    private boolean isConnected(PathDiagramNodeLayoutInterface n1, PathDiagramNodeLayoutInterface n2) {
        Vector<PathDiagramNodeLayoutInterface> ln1 = this.secondaryNodesMap.get(n1);
        Vector<PathDiagramNodeLayoutInterface> ln2 = this.secondaryNodesMap.get(n2);
        return ln1 != null && ln1.contains(n2) || ln2 != null && ln2.contains(n1);
    }

    private Vector<PathDiagramNodeLayoutInterface> sortNodesByConnectivity(Vector<PathDiagramNodeLayoutInterface> inputVector) {
        Vector<PathDiagramNodeLayoutInterface> sortedVector = new Vector<PathDiagramNodeLayoutInterface>();
        for (int i = 0; i < inputVector.size(); ++i) {
            PathDiagramNodeLayoutInterface n;
            int nc;
            PathDiagramNodeLayoutInterface node = inputVector.elementAt(i);
            int numConnections = this.getNumberOfConnections(node);
            int index = 0;
            for (index = 0; index < sortedVector.size() && numConnections <= (nc = this.getNumberOfConnections(n = sortedVector.elementAt(index))); ++index) {
            }
            if (index == sortedVector.size()) {
                sortedVector.add(node);
                continue;
            }
            sortedVector.insertElementAt(node, index);
        }
        return sortedVector;
    }

    private int getNumberOfConnections(PathDiagramNodeLayoutInterface node) {
        Vector<PathDiagramNodeLayoutInterface> linkedNodes = this.secondaryNodesMap.get(node);
        int numConnections = linkedNodes == null ? 0 : linkedNodes.size();
        return numConnections;
    }

    private void incrementLinkHeights(int direction, CustomLinkedList<PathDiagramNodeLayoutInterface> list, Vector<PathDiagramNodeLayoutInterface> linkedNodes, Vector<Integer> linkHeights, PathDiagramNodeLayoutInterface node, PFDPathDiagramGroupNode gn) {
        block3: for (int i = 0; i < linkedNodes.size(); ++i) {
            PathDiagramNodeLayoutInterface n = linkedNodes.elementAt(i);
            switch (direction) {
                default: {
                    if (!list.isBefore(node, n)) continue block3;
                    linkHeights.set(i, linkHeights.get(i) + 1);
                    gn.setMaxLinkDepth(Math.max(gn.getMaxLinkDepth(), linkHeights.get(i)));
                    continue block3;
                }
                case 2: {
                    if (!list.isAfter(node, n)) continue block3;
                    linkHeights.set(i, linkHeights.get(i) + 1);
                    gn.setMaxLinkDepth(Math.max(gn.getMaxLinkDepth(), linkHeights.get(i)));
                }
            }
        }
    }

    private void incrementLinkUnderCounts(NodeRange nr, Hashtable<PathDiagramNodeLayoutInterface, Integer> linksUnderRightCounts, CustomLinkedList<PathDiagramNodeLayoutInterface> orderedList) {
        PathDiagramNodeLayoutInterface t = nr.getStart();
        while (t != nr.getEnd()) {
            int prevCount = linksUnderRightCounts.get(t);
            linksUnderRightCounts.put(t, prevCount + 1);
            t = orderedList.getNext(t);
        }
    }

    private class NodeRange {
        PathDiagramNodeLayoutInterface start;
        PathDiagramNodeLayoutInterface end;

        public NodeRange(PathDiagramNodeLayoutInterface start, PathDiagramNodeLayoutInterface end) {
            this.start = start;
            this.end = end;
        }

        public void setStart(PathDiagramNodeLayoutInterface start) {
            this.start = start;
        }

        public PathDiagramNodeLayoutInterface getStart() {
            return this.start;
        }

        public void setEnd(PathDiagramNodeLayoutInterface end) {
            this.end = end;
        }

        public PathDiagramNodeLayoutInterface getEnd() {
            return this.end;
        }
    }
}

