/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.util.layout.GraphDistance;
import java.util.ArrayList;

public class PQueue {
    private ArrayList elements = null;
    private int count = 0;

    public PQueue(int size) {
        this.elements = new ArrayList(size);
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.elements.size();
    }

    private GraphDistance getPair(int index) {
        if (this.elements != null && this.elements.size() > index) {
            return (GraphDistance)this.elements.get(index);
        }
        return null;
    }

    private void setPair(int index, GraphDistance vdp) {
        if (this.elements != null && this.elements.size() > index) {
            this.elements.set(index, vdp);
        }
    }

    private void removePair(int index) {
        if (this.elements != null && this.elements.size() > index) {
            this.elements.remove(index);
        }
    }

    public void enqueue(int entry, double distance) {
        this.count = this.insert(this.count, entry, distance);
    }

    public int dequeueMin(GraphDistance vdp) {
        if (this.count > 0) {
            return this.extractMin(vdp);
        }
        return -1;
    }

    private int insert(int heapSize, int element, double orderElem) {
        int i = heapSize;
        while (i != 0 && this.getPair(i) != null && this.getPair(i).getDistance() > orderElem) {
            this.setPair(i, this.getPair(this.prev(i)));
            i = this.prev(i);
        }
        if (this.getPair(i) == null) {
            this.elements.add(i, new GraphDistance(element, orderElem));
        } else {
            this.getPair(i).setVertex(element);
            this.getPair(i).setDistance(orderElem);
        }
        return ++heapSize;
    }

    private int prev(int i) {
        return i >> 1;
    }

    private int extractMin(GraphDistance vdp) {
        int erg = this.getPair(0).getVertex();
        vdp.setVertex(this.getPair(0).getVertex());
        vdp.setDistance(this.getPair(0).getDistance());
        --this.count;
        this.setPair(0, this.getPair(this.count));
        this.removePair(this.count);
        this.heapify(this.count, 0);
        return erg;
    }

    public void heapify(int heapSize, int index) {
        int maxIndex = index;
        GraphDistance dummy = null;
        if (2 * index < heapSize && this.getPair(index).getDistance() > this.getPair(2 * index).getDistance()) {
            maxIndex = 2 * index;
        }
        if (2 * index + 1 < heapSize && this.getPair(maxIndex).getDistance() > this.getPair(2 * index + 1).getDistance()) {
            maxIndex = 2 * index + 1;
        }
        if (maxIndex != index) {
            dummy = this.getPair(index);
            this.setPair(index, this.getPair(maxIndex));
            this.setPair(maxIndex, dummy);
            this.heapify(heapSize, maxIndex);
        }
    }

    public void freeQueue() {
        this.elements.clear();
        this.count = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PQueue size=" + this.count);
        if (this.count > 0) {
            sb.append("\nelements={ ");
            for (int i = 0; i < this.count; ++i) {
                GraphDistance gd = this.getPair(i);
                sb.append("[" + gd.getVertex() + ", " + gd.getDistance() + "]");
                if (i >= this.count - 1) continue;
                sb.append(", ");
            }
            sb.append(" }\n");
        } else {
            sb.append(" elements=null\n");
        }
        return sb.toString();
    }
}

