/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public abstract class LayoutStrategy
implements LayoutStrategyInterface {
    Vector nodes = null;
    Vector links = null;
    NodeLinkDiagramLayoutInterface model;
    Rectangle bbox = new Rectangle(0, 0, 640, 480);
    int numNodes;
    int numLinks;
    boolean ortho = false;
    int numIterations;

    @Override
    public void setBoundingBox(int x, int y, int w, int h) {
        this.bbox = new Rectangle(x, y, w, h);
    }

    @Override
    public void setBoundingBox(Rectangle box) {
        this.bbox = box;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setMaxIterations(int num) {
        this.numIterations = num;
    }

    @Override
    public int getMaxIterations() {
        return this.numIterations;
    }

    @Override
    public void setOrthogonalLinks(boolean flag) {
        this.ortho = flag;
    }

    @Override
    public boolean isOrthogonalLinks() {
        return this.ortho;
    }

    @Override
    public void setModel(NodeLinkDiagramLayoutInterface m) {
        this.model = m;
    }

    void doSetupModel() {
        this.links = this.model.getAllLinks();
        this.nodes = this.model.getAllLayoutNodes();
        this.numNodes = this.nodes.size();
        this.numLinks = this.links.size();
    }

    @Override
    public boolean arrange() {
        return true;
    }

    double[] getNormalizedCoord(Point pos) {
        double[] normal = new double[]{2.0 * (double)(pos.x - this.bbox.width / 2) / (double)this.bbox.width, 2.0 * (double)(pos.y - this.bbox.height / 2) / (double)this.bbox.height};
        return normal;
    }

    Point getScreenCoord(double[] pos) {
        int x = (int)(pos[0] * (double)this.bbox.width / 2.0 + (double)(this.bbox.width / 2));
        int y = (int)(pos[1] * (double)this.bbox.height / 2.0 + (double)(this.bbox.height / 2));
        return new Point(x, y);
    }

    Point getScreenCoord(double posx, double posy) {
        int x = (int)(posx * (double)this.bbox.width / 2.0 + (double)(this.bbox.width / 2));
        int y = (int)(posy * (double)this.bbox.height / 2.0 + (double)(this.bbox.height / 2));
        return new Point(x, y);
    }
}

