/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.util.layout;

import com.sas.graphics.components.pfd.PFDPathDiagramNode;
import com.sas.graphics.components.util.layout.AdjacencyInfo;
import com.sas.graphics.components.util.layout.GraphComponentInterface;
import com.sas.graphics.interfaces.LinkLayoutInterface;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import com.sas.graphics.interfaces.NodeLinkDiagramLayoutInterface;
import java.util.Vector;

public class GraphInformation
implements GraphComponentInterface {
    private NodeLinkDiagramLayoutInterface model = null;
    private Vector[] adjacencyList = null;
    private int nVisNodes = 0;
    private double[] nodeSizes;
    private double[] linkWeights;
    private double maxNodeSize = 0.0;
    private int nErrNodes = 0;

    public GraphInformation(NodeLinkDiagramLayoutInterface model) {
        this.model = model;
        int nNodes = model.getAllLayoutNodes().size();
        this.nodeSizes = new double[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            NodeLayoutInterface n = (NodeLayoutInterface)model.getAllLayoutNodes().elementAt(i);
            if (n.isVisible()) {
                ++this.nVisNodes;
            }
            this.nodeSizes[i] = Math.sqrt(n.getHeight() * n.getHeight() + n.getWidth() * n.getWidth()) * 0.5;
            if (this.maxNodeSize < this.nodeSizes[i]) {
                this.maxNodeSize = this.nodeSizes[i];
            }
            if (!(n instanceof PFDPathDiagramNode) || ((PFDPathDiagramNode)n).getNodePriority() != PFDPathDiagramNode.NODE_PRIORITY_3) continue;
            ++this.nErrNodes;
        }
        this.init();
    }

    public boolean isNodeVisible(int nodeIdx) {
        if (nodeIdx < 0 || nodeIdx >= this.model.getAllLayoutNodes().size()) {
            return false;
        }
        return ((NodeLayoutInterface)this.model.getAllLayoutNodes().elementAt(nodeIdx)).isVisible();
    }

    private void init() {
        this.adjacencyList = new Vector[this.model.getAllLayoutNodes().size()];
        this.linkWeights = new double[this.model.getAllLinks().size()];
        for (int i = 0; i < this.model.getAllLinks().size(); ++i) {
            AdjacencyInfo adjI;
            LinkLayoutInterface link = (LinkLayoutInterface)this.model.getAllLinks().get(i);
            int from = this.getNodeIndex(link.getFromNode());
            int to = this.getNodeIndex(link.getToNode());
            if (from >= 0 && this.isNodeVisible(from)) {
                if (this.adjacencyList[from] == null) {
                    this.adjacencyList[from] = new Vector();
                }
                if (to >= 0 && this.isNodeVisible(to) && !this.isInfoPresent(from, adjI = new AdjacencyInfo(to, i))) {
                    this.adjacencyList[from].addElement(adjI);
                }
            }
            if (to >= 0 && this.isNodeVisible(to)) {
                if (this.adjacencyList[to] == null) {
                    this.adjacencyList[to] = new Vector();
                }
                if (from >= 0 && this.isNodeVisible(from) && !this.isInfoPresent(to, adjI = new AdjacencyInfo(from, i))) {
                    this.adjacencyList[to].addElement(adjI);
                }
            }
            double weight = 1.0;
            if (link.getFromNode() instanceof PFDPathDiagramNode && link.getToNode() instanceof PFDPathDiagramNode) {
                double d2;
                double d1;
                PFDPathDiagramNode n1 = (PFDPathDiagramNode)link.getFromNode();
                PFDPathDiagramNode n2 = (PFDPathDiagramNode)link.getToNode();
                if (n1.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3 || n2.getNodePriority() == PFDPathDiagramNode.NODE_PRIORITY_3) {
                    d1 = n1.getShape() == 0 ? 0.0 : Math.sqrt(n1.getHeight() * n1.getHeight() + n1.getWidth() * n1.getWidth()) * 0.5;
                    double d = d2 = n2.getShape() == 0 ? 0.0 : Math.sqrt(n2.getHeight() * n2.getHeight() + n2.getWidth() * n2.getWidth()) * 0.5;
                    weight = d1 == 0.0 || d2 == 0.0 ? (d1 + d2) / (this.maxNodeSize * 2.0) : 0.9 * (d1 + d2) / (this.maxNodeSize * 2.0);
                } else if (n1.getNodePriority() != n2.getNodePriority()) {
                    d1 = Math.sqrt(n1.getHeight() * n1.getHeight() + n1.getWidth() * n1.getWidth()) * 0.5;
                    d2 = Math.sqrt(n2.getHeight() * n2.getHeight() + n2.getWidth() * n2.getWidth()) * 0.5;
                    weight = 0.9 * (d1 + d2) / (this.maxNodeSize * 2.0);
                } else {
                    weight = 1.0;
                }
            }
            this.linkWeights[i] = weight;
        }
    }

    private boolean isInfoPresent(int nodeIdx, AdjacencyInfo adjI) {
        if (nodeIdx < 0 || nodeIdx > this.adjacencyList.length) {
            return false;
        }
        Vector vec = this.adjacencyList[nodeIdx];
        for (int i = 0; i < vec.size(); ++i) {
            AdjacencyInfo oneInfo = (AdjacencyInfo)vec.elementAt(i);
            if (adjI.getNodeIndex() != oneInfo.getNodeIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberNodes() {
        return this.model.getAllLayoutNodes().size();
    }

    public int getVisibleNodeCount() {
        return this.nVisNodes;
    }

    public int getErrorNodeCount() {
        return this.nErrNodes;
    }

    @Override
    public int getDegree(int nodeIndex) {
        int degree = 0;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null && this.isNodeVisible(nodeIndex)) {
            degree = this.adjacencyList[nodeIndex].size();
        }
        return degree;
    }

    @Override
    public double getNodeSize(int nodeIndex) {
        if (nodeIndex < 0 || nodeIndex > this.nodeSizes.length) {
            return 0.0;
        }
        return this.nodeSizes[nodeIndex];
    }

    public double[] getNodeSizes() {
        return this.nodeSizes;
    }

    public double[] getLinkWeights() {
        return this.linkWeights;
    }

    public double getMaximumNodeSize() {
        return this.maxNodeSize;
    }

    @Override
    public double getLinkWeight(int nodeIndex, int i) {
        AdjacencyInfo info = this.getAdjacencyInfo(nodeIndex, i);
        if (info == null) {
            return 1.0;
        }
        return this.linkWeights[info.getLinkIndex()];
    }

    public Vector[] getAdjacencyList() {
        return this.adjacencyList;
    }

    @Override
    public int getAdjacentVertex(int nodeIndex, int i) {
        AdjacencyInfo info = this.getAdjacencyInfo(nodeIndex, i);
        if (info == null) {
            return -1;
        }
        return info.getNodeIndex();
    }

    public AdjacencyInfo getAdjacencyInfo(int nodeIndex, int i) {
        AdjacencyInfo info = null;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null && i >= 0 && i < this.adjacencyList[nodeIndex].size() && this.isNodeVisible(nodeIndex)) {
            info = (AdjacencyInfo)this.adjacencyList[nodeIndex].elementAt(i);
        }
        return info;
    }

    private int getNodeIndex(NodeLayoutInterface theNode) {
        Vector nodes = this.model.getAllLayoutNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) != theNode) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number of nodes = " + this.adjacencyList.length + "\n\n");
        for (int i = 0; i < this.adjacencyList.length; ++i) {
            sb.append("Node = " + i + " adjList = {");
            for (int j = 0; j < this.getDegree(i); ++j) {
                sb.append(this.getAdjacentVertex(i, j));
                if (j >= this.getDegree(i) - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

