/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDScrollView;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDUniqueItemInterface;
import com.sas.graphics.components.pfd.xml.PFDParserFactory;
import com.sas.graphics.components.pfd.xml.parsers.LayoutParser;
import com.sas.graphics.components.pfd.xml.parsers.PFDElementInfoReader;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.xml.GraphParser;
import com.sas.graphics.xml.GraphParserUtils;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class PFDViewParser
implements ElementParserInterface {
    public static final String TAG_NAME = "PFD";
    public final String CONFIG = "com/sas/graphics/components/pfd/xml/parsers/config/pfdView.config";
    public final String CONFIG_SCROLL = "com/sas/graphics/components/pfd/xml/parsers/config/pfdScrollView.config";
    protected PFDElementInfoReader viewInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/pfdScrollView.config");

    public PFDViewParser() {
        this(null);
    }

    public PFDViewParser(PropertyInterface pi) {
        this.viewInfoReader.setInstance(pi);
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        Element childElement;
        String flowDirection;
        boolean usingScrollView = true;
        if (element.getAttribute("useScrollView").equals("false") || GraphicsEnvironment.isHeadless()) {
            this.viewInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/pfdView.config");
            this.viewInfoReader.setInstance(null);
            usingScrollView = false;
        }
        this.setObject(instance);
        PFDParserUtils.parseElement(context, element, this.viewInfoReader);
        if (this.getObject() == null || !(this.getObject() instanceof PFDView) && !(this.getObject() instanceof PFDScrollView) || context == null) {
            return null;
        }
        PFDUniqueItemInterface uii = (PFDUniqueItemInterface)this.getObject();
        if (uii.getPFDItemId() == null || context.get(uii.getPFDItemId()) != null) {
            uii.setPFDItemId("PFDView_" + uii.hashCode());
        }
        String dataPoundColumn = element.getAttribute("pfditems");
        String data = GraphParserUtils.getDataID((String)dataPoundColumn);
        String column = GraphParserUtils.getVariableID((String)dataPoundColumn);
        SourceInterface si = (SourceInterface)this.getObject();
        if (data != null && data.length() > 0) {
            if (column == null || column.length() <= 0 || column.equalsIgnoreCase(data)) {
                column = "pfditem";
            }
            si.setDataSource(GraphParser.getData((String)data, (Hashtable)context), (Object)column);
        }
        if (!(flowDirection = element.getAttribute("flowDirection")).equals("")) {
            PropertyInterface pi = (PropertyInterface)this.getObject();
            pi.setPropertyValue(15, (Object)"Right");
            pi.applyPropertyChanges();
            pi.setPropertyValue(15, (Object)flowDirection);
            pi.applyPropertyChanges();
        }
        LayeredLayoutStrategy layout = new LayeredLayoutStrategy();
        boolean applyLayout = false;
        if (element.getAttribute("layoutActivated").equalsIgnoreCase("true")) {
            applyLayout = true;
        }
        if ((childElement = PFDParserUtils.getChildWithTagName((String)"Layout", (Element)element)) != null) {
            new LayoutParser().getFromXML(context, childElement, layout);
        }
        if (!usingScrollView) {
            PFDView v = (PFDView)this.getObject();
            v.setPFDLayout(layout);
            if (applyLayout) {
                v.doPFDLayout(true);
            } else {
                v.setHoldDisplay(true);
                v.disableChangeUpdate();
                v.getModel().crop();
                v.enableChangeUpdate();
                v.setHoldDisplay(false);
            }
            v.setScaleToFit(true);
        } else {
            PFDScrollView v = (PFDScrollView)this.getObject();
            v.setPFDLayout(layout);
            if (applyLayout) {
                v.doPFDLayout(true);
            }
        }
        context.put(uii.getPFDItemId(), this.getObject());
        GraphParser.addChart((Hashtable)context, (String)uii.getPFDItemId());
        return this.getObject();
    }

    public Element putToXML(Hashtable context, Object instance) {
        if (!(instance instanceof PFDView) && !(instance instanceof PFDScrollView) || context == null) {
            return null;
        }
        PFDUniqueItemInterface uii = (PFDUniqueItemInterface)instance;
        String id = uii.getPFDItemId();
        if (id == null || context.containsKey(id) || context.containsValue(id)) {
            uii.setPFDItemId(PFDParserUtils.getUniqueID(context));
        }
        Element element = PFDParserUtils.toXML(TAG_NAME, context, instance, this.viewInfoReader);
        Object source = ((SourceInterface)instance).getDataSource();
        if (source != null) {
            String dataName = PFDParserUtils.getNameForDataObject((Object)source, (Hashtable)context);
            context.put(dataName, source);
            if (dataName != null) {
                element.setAttribute("pfditems", dataName);
            }
        }
        LayoutStrategyInterface layout = null;
        layout = instance instanceof PFDView ? ((PFDView)instance).getPFDLayout() : ((PFDScrollView)instance).getPFDLayout();
        Element childElement = new LayoutParser().putToXML(context, layout);
        if (childElement != null && childElement.getAttributes() != null && childElement.getAttributes().getLength() > 0) {
            element.appendChild(childElement);
        }
        if (!(instance instanceof PFDScrollView)) {
            element.setAttribute("useScrollView", "false");
        }
        return element;
    }

    public Object getObject() {
        return this.viewInfoReader.getXmlTarget();
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.viewInfoReader != null) {
            this.viewInfoReader.setInstance(instance);
        }
        return true;
    }

    static {
        PFDParserFactory.loadPFDParsers();
    }
}

