/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.xml.PFDParser;
import com.sas.graphics.components.pfd.xml.PFDParserFactory;
import com.sas.graphics.components.pfd.xml.parsers.GroupParser;
import com.sas.graphics.silk.interfaces.ElementInfoInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.graphics.xml.GraphParserUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PFDParserUtils
extends GraphParserUtils {
    protected static PFDParser xmlParser = null;
    private static int uniqueID = 0;

    public static PFDParser getPFDParser() {
        if (xmlParser == null) {
            xmlParser = new PFDParser();
        }
        return xmlParser;
    }

    public static String getUniqueID(Hashtable context) {
        if (context == null) {
            return "contextWasNull";
        }
        String id = String.valueOf(uniqueID);
        while (context.containsKey(id) || context.containsValue(id)) {
            id = String.valueOf(++uniqueID);
        }
        ++uniqueID;
        return id;
    }

    public static List getListFromXML(Hashtable context, Element element, ElementParserInterface itemParser) {
        Vector<Object> list = new Vector<Object>();
        NodeList children = element.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element e = (Element)child;
            Object obj = itemParser.getFromXML(context, e, null);
            if (obj != null) {
                list.add(obj);
            }
            obj = null;
        }
        return list;
    }

    public static Element putListToXML(Hashtable context, List list, String tagName, ElementParserInterface itemParser) {
        Element element = GraphParserUtils.newElement((Hashtable)context, (String)tagName);
        for (int i = 0; i < list.size(); ++i) {
            Element child = itemParser.putToXML(context, list.get(i));
            if (child == null) continue;
            element.appendChild(child);
        }
        return element;
    }

    public static Element toXML(String elementName, Hashtable context, Object obj, ElementInfoInterface info) {
        if (elementName == null || info == null || obj == null) {
            return null;
        }
        Element rc = PFDParserUtils.newElement((Hashtable)context, (String)elementName);
        if (obj instanceof PropertyInterface) {
            PropertyInterface pi = (PropertyInterface)obj;
            String[] properties = info.getAttributeNames();
            for (int i = 0; i < properties.length; ++i) {
                Object prop;
                if (!pi.hasUserSetValue(info.getPropertyIndex(properties[i])) || (prop = pi.getPropertyValue(info.getPropertyIndex(properties[i]))) == null) continue;
                rc.setAttribute(properties[i], PFDParserUtils.getString((Object)prop));
            }
        }
        return rc;
    }

    public static void parseElement(Hashtable context, Element element, ElementInfoInterface info) {
        if (context == null || element == null || info == null) {
            return;
        }
        Object xmlTarget = info.getXmlTarget();
        if (xmlTarget instanceof PropertyInterface) {
            PropertyInterface pfdItem = (PropertyInterface)xmlTarget;
            String[] attrs = info.getAttributeNames();
            if (attrs == null) {
                return;
            }
            for (int i = 0; i < attrs.length; ++i) {
                String value = element.getAttribute(attrs[i]);
                if (value == null || value.trim().length() == 0) continue;
                value = PFDParserUtils.convertValidXMLString((String)value);
                int index = info.getPropertyIndex(attrs[i]);
                Object valids = info.getValidValues(attrs[i]);
                Object obj = PFDParserUtils.validateAndConvert((Object)valids, (String)value, (Hashtable)context);
                if (obj == null || value == null) continue;
                pfdItem.setPropertyValue(index, obj);
            }
            pfdItem.applyPropertyChanges();
        }
    }

    public static PFDPrimitive getPrimitiveFromDOMString(Hashtable context, String dom) {
        PFDParserUtils.getPFDParser();
        Element element = PFDParser.getElement((InputStream)new ByteArrayInputStream(dom.getBytes()));
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("PFDGroup")) {
            GroupParser.addToUnparsedGroupList(element);
            return null;
        }
        ElementParserInterface parser = GraphParserFactory.loadParser((String)tagName);
        PFDPrimitive primitive = (PFDPrimitive)parser.getFromXML(context, element, null);
        return primitive;
    }

    public static PFDPrimitive getPrimitiveFromDOMElement(Hashtable context, Element element) {
        String tagName = element.getTagName();
        if (tagName.equalsIgnoreCase("PFDGroup")) {
            GroupParser.addToUnparsedGroupList(element);
            return null;
        }
        ElementParserInterface parser = GraphParserFactory.loadParser((String)tagName);
        if (parser == null) {
            return null;
        }
        PFDPrimitive primitive = (PFDPrimitive)parser.getFromXML(context, element, null);
        return primitive;
    }

    public static Element getElementFromPrimitive(Hashtable context, Object primitive) {
        ElementParserInterface parser = PFDParserFactory.loadParser((Object)primitive);
        Element element = parser.putToXML(context, primitive);
        return element;
    }
}

