/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.xml.parsers.ButtonParser;
import com.sas.graphics.components.pfd.xml.parsers.PFDElementInfoReader;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LinkParser
implements ElementParserInterface {
    public static final String TAG_NAME = "PFDLink";
    public final String CONFIG = "com/sas/graphics/components/pfd/xml/parsers/config/link.config";
    protected PFDElementInfoReader linkInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/link.config");

    public LinkParser() {
        this(null);
    }

    public LinkParser(PropertyInterface pi) {
        this.linkInfoReader.setInstance(pi);
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        this.setObject(instance);
        String id = element.getAttribute("id");
        String fromId = element.getAttribute("fromId");
        String toId = element.getAttribute("toId");
        Object fromObj = context.get(fromId);
        Object toObj = context.get(toId);
        if (id == null || context.contains(id) || fromObj == null || toObj == null) {
            return null;
        }
        PFDPort fromPort = null;
        if (fromObj instanceof PFDPort) {
            fromPort = (PFDPort)fromObj;
        } else if (fromObj instanceof PFDAbstractNode) {
            fromPort = ((PFDAbstractNode)fromObj).getOutputPort();
        } else {
            return null;
        }
        PFDPort toPort = null;
        if (toObj instanceof PFDPort) {
            toPort = (PFDPort)toObj;
        } else if (toObj instanceof PFDAbstractNode) {
            toPort = ((PFDAbstractNode)toObj).getInputPort();
        } else {
            return null;
        }
        PFDLink link = (PFDLink)this.getObject();
        link.setIsControl(fromPort.isControl());
        link.setFromPort(fromPort);
        link.setToPort(toPort);
        link.setPFDItemId(id);
        Element childElement = PFDParserUtils.getChildWithTagName((String)"Buttons", (Element)element);
        if (childElement != null) {
            ButtonParser.initButtonsFromXML(context, childElement, link);
        }
        return link;
    }

    public Element putToXML(Hashtable context, Object instance) {
        if (!(instance instanceof PFDLink)) {
            return null;
        }
        PFDLink link = (PFDLink)instance;
        String id = link.getPFDItemId();
        if (id == null || context.containsKey(id) || context.containsValue(id)) {
            link.setPFDItemId(PFDParserUtils.getUniqueID(context));
        }
        if (link.isCollapsed()) {
            return null;
        }
        Element element = PFDParserUtils.toXML(TAG_NAME, context, instance, this.linkInfoReader);
        if (link.getIndicatorButtons().getNumButtons() > 0) {
            element.appendChild(ButtonParser.getButtonsElement(context, link));
        }
        context.put(link.getPFDItemId(), GraphParserUtils.toString((Node)element).trim());
        return element;
    }

    public Object getObject() {
        return this.linkInfoReader.getXmlTarget();
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.linkInfoReader != null) {
            this.linkInfoReader.setInstance(instance);
        }
        return true;
    }
}

