/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.xml.parsers;

import com.sas.graphics.components.pfd.PFDCollapsableNodeGroup;
import com.sas.graphics.components.pfd.xml.parsers.PFDElementInfoReader;
import com.sas.graphics.components.pfd.xml.parsers.PFDParserUtils;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupParser
implements ElementParserInterface {
    public static final String TAG_NAME = "PFDGroup";
    public final String CONFIG = "com/sas/graphics/components/pfd/xml/parsers/config/group.config";
    protected PFDElementInfoReader groupInfoReader = new PFDElementInfoReader("com/sas/graphics/components/pfd/xml/parsers/config/group.config");
    private static Hashtable unparsedGroupList = null;

    public GroupParser() {
        this(null);
    }

    public GroupParser(PropertyInterface pi) {
        this.groupInfoReader.setInstance(pi);
    }

    public static boolean hasUnparsedGroups() {
        return unparsedGroupList != null && unparsedGroupList.size() != 0;
    }

    public static void addToUnparsedGroupList(Element unparsedGroup) {
        if (unparsedGroupList == null) {
            unparsedGroupList = new Hashtable();
        }
        unparsedGroupList.put(unparsedGroup.getAttribute("id"), unparsedGroup);
    }

    public void parseGroups(Hashtable context) {
        Enumeration ids = unparsedGroupList.keys();
        Element unparsedGroup = null;
        Object id = null;
        while (ids.hasMoreElements()) {
            id = ids.nextElement();
            if (context.containsKey(id)) continue;
            unparsedGroup = (Element)unparsedGroupList.get(id);
            this.getFromXML(context, unparsedGroup, null);
            unparsedGroupList.remove(id);
        }
        unparsedGroupList = null;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        this.setObject(instance);
        if (element == null || element.getAttribute("id").equals("") || context == null || context.contains(element.getAttribute("id"))) {
            return null;
        }
        Element groupItemsElement = PFDParserUtils.getChildWithTagName((String)"GroupItems", (Element)element);
        if (groupItemsElement == null) {
            return null;
        }
        NodeList groupItems = groupItemsElement.getChildNodes();
        Element groupItemElement = null;
        int numberOfChildren = groupItems.getLength();
        Vector parsedGroupItems = new Vector();
        for (int i = 0; i < numberOfChildren; ++i) {
            if (groupItems.item(i).getNodeType() != 1 || !(groupItemElement = (Element)groupItems.item(i)).getTagName().equalsIgnoreCase("GroupItem")) continue;
            String groupItemID = groupItemElement.getTextContent();
            Object pfdItem = context.get(groupItemID);
            if (pfdItem == null) {
                pfdItem = unparsedGroupList.remove(groupItemID);
                if (pfdItem == null) {
                    return null;
                }
                pfdItem = this.getFromXML(context, (Element)pfdItem, (Object)this.groupInfoReader);
            }
            context.remove(groupItemID);
            parsedGroupItems.add(pfdItem);
        }
        PFDCollapsableNodeGroup group = PFDCollapsableNodeGroup.createGroup(parsedGroupItems);
        this.setObject(group);
        PFDParserUtils.parseElement(context, element, this.groupInfoReader);
        if (context != null && this.getObject() != null) {
            context.put(group.getPFDItemId(), group);
        }
        return group;
    }

    public Element putToXML(Hashtable context, Object instance) {
        if (!(instance instanceof PFDCollapsableNodeGroup) || context == null) {
            return null;
        }
        PFDCollapsableNodeGroup group = (PFDCollapsableNodeGroup)instance;
        int numberOfGroupItems = group.getGroupPrimitiveCount();
        if (numberOfGroupItems <= 0) {
            return null;
        }
        Element groupItemElement = null;
        Element groupItemsElement = PFDParserUtils.newElement((Hashtable)context, (String)"GroupItems");
        for (int i = 0; i < numberOfGroupItems; ++i) {
            groupItemElement = PFDParserUtils.newElement((Hashtable)context, (String)"GroupItem");
            groupItemElement.setTextContent(group.getGroupPrimitive(i).getPFDItemId());
            groupItemsElement.appendChild(groupItemElement);
        }
        String id = group.getPFDItemId();
        if (id == null || context.containsKey(id) || context.containsValue(id)) {
            group.setPFDItemId(PFDParserUtils.getUniqueID(context));
        }
        Element element = PFDParserUtils.toXML(TAG_NAME, context, group, this.groupInfoReader);
        element.appendChild(groupItemsElement);
        context.put(group.getPFDItemId(), GraphParserUtils.toString((Node)element).trim());
        return element;
    }

    public Object getObject() {
        return this.groupInfoReader.getXmlTarget();
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.groupInfoReader != null) {
            this.groupInfoReader.setInstance(instance);
        }
        return true;
    }
}

