/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.menu;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RB {
    private static RB rb = new RB();
    private ResourceBundle resourceBundle;
    private Hashtable localeBundles;
    private static String ResourceBundleName = "Resources";

    protected RB() {
    }

    public static String getStringResource(String classKey, String subKey) {
        return rb._getStringResource(classKey + subKey);
    }

    public static String getStringResource(String key) {
        return rb._getStringResource(key);
    }

    public static ResourceBundle getResources() {
        return rb._getResources();
    }

    protected final String _getStringResource(String key) {
        return this._getStringResource(key, Locale.getDefault());
    }

    protected final String _getStringResource(String key, Locale locale) {
        try {
            return this._getResources(locale).getString(key);
        }
        catch (MissingResourceException r) {
            System.out.println("Missing resource " + key + " for " + this.resourceName());
            throw r;
        }
        catch (Exception e) {
            System.out.println("Caught exception trying to load resource " + key);
            throw new MissingResourceException(e.getMessage(), this.resourceName(), key);
        }
    }

    protected final ResourceBundle _getResources() {
        return this._getResources(Locale.getDefault());
    }

    protected final ResourceBundle _getResources(Locale locale) {
        try {
            if (locale == null || locale.equals(Locale.getDefault())) {
                if (this.resourceBundle == null) {
                    this.resourceBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
                }
                return this.resourceBundle;
            }
            ResourceBundle localeBundle = null;
            if (this.localeBundles == null) {
                this.localeBundles = new Hashtable();
            } else {
                localeBundle = (ResourceBundle)this.localeBundles.get(locale);
            }
            if (localeBundle != null) {
                return localeBundle;
            }
            localeBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
            this.localeBundles.put(locale, localeBundle);
            return localeBundle;
        }
        catch (MissingResourceException r) {
            System.out.println("Missing resource bundle " + this.resourceName() + " for locale " + locale);
            throw r;
        }
    }

    private String resourceName() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        return (dot == -1 ? ResourceBundleName : className.substring(0, dot)) + "." + ResourceBundleName;
    }
}

