/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.actions;

import com.sas.graphics.components.pfd.PFDImageFileFilter;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.PFDPlaceholderIcon;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.actions.RB;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public class PFDSaveAsImageAction
extends PFDAbstractAction {
    private static String lastFileIOPath;

    public PFDSaveAsImageAction(PFDView v) {
        super(v);
        this.putValue("SmallIcon", new PFDPlaceholderIcon());
        this.putValue("Name", RB.getStringResource("PFDSaveAsImageAction.name.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.view != null) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(new PFDImageFileFilter(1));
            fc.setFileSelectionMode(0);
            if (lastFileIOPath != null) {
                fc.setCurrentDirectory(new File(lastFileIOPath));
            }
            if ((returnVal = fc.showSaveDialog(this.view)) == 0) {
                File file = fc.getSelectedFile();
                String fileExtension = PFDImageFileFilter.getExtension(file);
                if (fileExtension == null) {
                    fileExtension = "bmp";
                    file = PFDImageFileFilter.addFileExtention(file, fileExtension);
                }
                if (fileExtension.equals("bmp")) {
                    this.view.saveToBitmap(file);
                } else if (fileExtension.equals("gif")) {
                    this.view.saveToGif(file);
                }
                lastFileIOPath = file.getAbsolutePath();
            }
            this.view.repaint();
        }
    }
}

