/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.actions;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.actions.PFDAbstractAction;
import com.sas.graphics.components.pfd.ui.actions.PFDAddNoteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCopyAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCreateGroupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDCutAction;
import com.sas.graphics.components.pfd.ui.actions.PFDDeleteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDGridStyleDotAction;
import com.sas.graphics.components.pfd.ui.actions.PFDGridStyleSolidAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutDownAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutLeftAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutRightAction;
import com.sas.graphics.components.pfd.ui.actions.PFDLayoutUpAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPageSetupAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPanModeAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPasteAction;
import com.sas.graphics.components.pfd.ui.actions.PFDPrintAction;
import com.sas.graphics.components.pfd.ui.actions.PFDRunLayoutAction;
import com.sas.graphics.components.pfd.ui.actions.PFDSaveAsImageAction;
import com.sas.graphics.components.pfd.ui.actions.PFDSelectModeAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleGridAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleOverviewAction;
import com.sas.graphics.components.pfd.ui.actions.PFDTogglePageBoundariesAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleSnapToGridAction;
import com.sas.graphics.components.pfd.ui.actions.PFDToggleToolbarAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomCustomScaleAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomDecreaseAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitHeightAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomFitWidthAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomIncreaseAction;
import com.sas.graphics.components.pfd.ui.actions.PFDZoomModeAction;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.Action;

public class PFDActionFactory {
    private PFDView view;
    private Hashtable actionTable;

    public PFDActionFactory(PFDView v) {
        this.view = v;
        this.actionTable = new Hashtable();
    }

    public Action getAction(String actionString) {
        if (actionString == null || this.view == null || this.actionTable == null) {
            return null;
        }
        Action value = (Action)this.actionTable.get(actionString);
        if (value == null && (value = this.createAction(actionString)) != null) {
            this.actionTable.put(actionString, value);
        }
        return value;
    }

    public boolean setAction(String actionString, Action a) {
        if (actionString == null || a == null || this.actionTable == null) {
            return false;
        }
        this.actionTable.put(actionString, a);
        return true;
    }

    private Action createAction(String actionString) {
        if (actionString == null) {
            return null;
        }
        if (actionString.equals("ACTION_MODE_SELECT")) {
            return new PFDSelectModeAction(this.view);
        }
        if (actionString.equals("ACTION_MODE_PAN")) {
            return new PFDPanModeAction(this.view);
        }
        if (actionString.equals("ACTION_MODE_ZOOM")) {
            return new PFDZoomModeAction(this.view);
        }
        if (actionString.equals("ACTION_ZOOM_DECREASE")) {
            return new PFDZoomDecreaseAction(this.view);
        }
        if (actionString.equals("ACTION_ZOOM_INCREASE")) {
            return new PFDZoomIncreaseAction(this.view);
        }
        if (actionString.equals("ACTION_RUN_LAYOUT")) {
            return new PFDRunLayoutAction(this.view);
        }
        if (actionString.equals("ACTION_LAYOUT_RIGHT")) {
            return new PFDLayoutRightAction(this.view);
        }
        if (actionString.equals("ACTION_LAYOUT_LEFT")) {
            return new PFDLayoutLeftAction(this.view);
        }
        if (actionString.equals("ACTION_LAYOUT_UP")) {
            return new PFDLayoutUpAction(this.view);
        }
        if (actionString.equals("ACTION_LAYOUT_DOWN")) {
            return new PFDLayoutDownAction(this.view);
        }
        if (actionString.equals("ACTION_TOGGLE_OVERVIEW")) {
            return new PFDToggleOverviewAction(this.view);
        }
        if (actionString.equals("ACTION_TOGGLE_GRID")) {
            return new PFDToggleGridAction(this.view);
        }
        if (actionString.equals("ACTION_TOGGLE_SNAP_TO_GRID")) {
            return new PFDToggleSnapToGridAction(this.view);
        }
        if (actionString.equals("ACTION_GRID_STYLE_SOLID")) {
            return new PFDGridStyleSolidAction(this.view);
        }
        if (actionString.equals("ACTION_GRID_STYLE_DOT")) {
            return new PFDGridStyleDotAction(this.view);
        }
        if (actionString.equals("ACTION_ZOOM_10")) {
            return new PFDZoomCustomScaleAction(this.view, 0.1);
        }
        if (actionString.equals("ACTION_ZOOM_25")) {
            return new PFDZoomCustomScaleAction(this.view, 0.25);
        }
        if (actionString.equals("ACTION_ZOOM_50")) {
            return new PFDZoomCustomScaleAction(this.view, 0.5);
        }
        if (actionString.equals("ACTION_ZOOM_75")) {
            return new PFDZoomCustomScaleAction(this.view, 0.75);
        }
        if (actionString.equals("ACTION_ZOOM_100")) {
            return new PFDZoomCustomScaleAction(this.view, 1.0);
        }
        if (actionString.equals("ACTION_ZOOM_150")) {
            return new PFDZoomCustomScaleAction(this.view, 1.5);
        }
        if (actionString.equals("ACTION_ZOOM_200")) {
            return new PFDZoomCustomScaleAction(this.view, 2.0);
        }
        if (actionString.equals("ACTION_ZOOM_NO_SELECTION")) {
            return new PFDAbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
        if (actionString.equals("ACTION_ZOOM_FIT")) {
            return new PFDZoomFitAction(this.view);
        }
        if (actionString.equals("ACTION_ZOOM_FIT_WIDTH")) {
            return new PFDZoomFitWidthAction(this.view);
        }
        if (actionString.equals("ACTION_ZOOM_FIT_HEIGHT")) {
            return new PFDZoomFitHeightAction(this.view);
        }
        if (actionString.equals("ACTION_ADD_NOTE")) {
            return new PFDAddNoteAction(this.view);
        }
        if (actionString.equals("ACTION_TOGGLE_TOOLBAR")) {
            return new PFDToggleToolbarAction(this.view);
        }
        if (actionString.equals("ACTION_CREATE_GROUP")) {
            return new PFDCreateGroupAction(this.view);
        }
        if (actionString.equals("ACTION_CUT")) {
            return new PFDCutAction(this.view);
        }
        if (actionString.equals("ACTION_COPY")) {
            return new PFDCopyAction(this.view);
        }
        if (actionString.equals("ACTION_PASTE")) {
            return new PFDPasteAction(this.view);
        }
        if (actionString.equals("ACTION_DELETE")) {
            return new PFDDeleteAction(this.view);
        }
        if (actionString.equals("ACTION_SAVE_AS_IMAGE")) {
            return new PFDSaveAsImageAction(this.view);
        }
        if (actionString.equals("ACTION_PRINT")) {
            return new PFDPrintAction(this.view);
        }
        if (actionString.equals("ACTION_PAGE_SETUP")) {
            return new PFDPageSetupAction(this.view);
        }
        if (actionString.equals("ACTION_TOGGLE_PAGE_BOUNDARIES")) {
            return new PFDTogglePageBoundariesAction(this.view);
        }
        return null;
    }
}

