/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui.actions;

import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.ui.actions.PFDActionGroup;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;

public abstract class PFDAbstractAction
extends AbstractAction {
    public static final String SELECTED_KEY = "pfdAbstractAction.selected";
    protected transient PFDView view;
    private Hashtable buttonTable;
    private PFDActionGroup group;

    public PFDAbstractAction() {
        this((PFDView)null);
    }

    public PFDAbstractAction(PFDView v) {
        this.init();
        this.view = v;
    }

    private void init() {
        this.buttonTable = new Hashtable();
        this.putValue(SELECTED_KEY, Boolean.FALSE);
    }

    public void setView(PFDView v) {
        this.view = v;
    }

    public PFDView getView() {
        return this.view;
    }

    public void addButton(AbstractButton button) {
        button.setSelected(this.isSelected());
        SelectionStateAdapter adapter = new SelectionStateAdapter(this, button);
        this.addPropertyChangeListener(adapter);
        button.addItemListener(adapter);
        this.buttonTable.put(button, adapter);
    }

    public void removeButton(AbstractButton button) {
        SelectionStateAdapter adapter = (SelectionStateAdapter)this.buttonTable.remove(button);
        if (adapter == null) {
            return;
        }
        this.removePropertyChangeListener(adapter);
        button.removeItemListener(adapter);
    }

    public void setSelected(boolean selected) {
        this.putValue(SELECTED_KEY, selected);
    }

    public boolean isSelected() {
        return (Boolean)this.getValue(SELECTED_KEY);
    }

    public String toString() {
        String name = (String)this.getValue("Name");
        if (name != null) {
            return name;
        }
        return super.toString();
    }

    public void setGroup(PFDActionGroup g) {
        this.group = g;
    }

    public PFDActionGroup getGroup() {
        return this.group;
    }

    private static class SelectionStateAdapter
    implements PropertyChangeListener,
    ItemListener,
    Serializable {
        private PFDAbstractAction action;
        private AbstractButton button;
        private boolean update = true;

        public SelectionStateAdapter(PFDAbstractAction theAction, AbstractButton theButton) {
            this.action = theAction;
            this.button = theButton;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.update) {
                this.update = false;
                boolean value = e.getStateChange() == 1;
                Boolean valueObj = value;
                if (!value && this.action.getGroup() != null) {
                    this.button.setSelected(true);
                } else {
                    this.action.putValue(PFDAbstractAction.SELECTED_KEY, valueObj);
                }
                this.update = true;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.update && evt.getPropertyName().equals(PFDAbstractAction.SELECTED_KEY)) {
                Boolean newSelectedState = (Boolean)evt.getNewValue();
                this.update = false;
                this.button.setSelected(newSelectedState);
                this.update = true;
            }
        }
    }
}

