/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;

public class SplitButton
extends JButton
implements ActionListener {
    private JButton mainButton;
    private JButton dropDownButton;
    private JPopupMenu dropDownMenu;

    public SplitButton() {
        this(" ");
    }

    public SplitButton(String text) {
        this(new JButton(text), 5);
    }

    public SplitButton(String text, int orientation) {
        this(new JButton(text), orientation);
    }

    public SplitButton(JButton mainButton, int orientation) {
        this.mainButton = mainButton;
        mainButton.setContentAreaFilled(false);
        this.setContentAreaFilled(false);
        this.dropDownButton = new BasicArrowButton(orientation);
        this.dropDownButton.addActionListener(this);
        Dimension mbdim = mainButton.getSize();
        Dimension dddim = this.dropDownButton.getSize();
        dddim.height = mbdim.height;
        this.dropDownButton.setMinimumSize(dddim);
        this.setBorderPainted(false);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(50, 40));
        this.setMaximumSize(new Dimension(50, 40));
        this.setMinimumSize(new Dimension(50, 40));
        this.setLayout(new BorderLayout());
        this.setMargin(new Insets(3, 3, 3, 3));
        this.add((Component)mainButton, "Center");
        this.add((Component)this.dropDownButton, "East");
    }

    public void setMenu(JPopupMenu menu) {
        this.dropDownMenu = menu;
    }

    public JButton getMainButton() {
        return this.mainButton;
    }

    public JButton getDropDownButton() {
        return this.dropDownButton;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dropDownMenu == null) {
            return;
        }
        if (!this.dropDownMenu.isVisible()) {
            Point p = this.dropDownButton.getLocationOnScreen();
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w != null) {
                Point bottomRightCorner = new Point((int)p.getX() + this.dropDownMenu.getWidth(), (int)(p.getY() + (double)this.dropDownButton.getHeight() + (double)this.dropDownMenu.getHeight()));
                if (w.contains(bottomRightCorner)) {
                    this.dropDownMenu.setLocation((int)p.getX(), (int)p.getY() + this.dropDownButton.getHeight());
                    this.dropDownMenu.setVisible(true);
                } else {
                    this.dropDownMenu.setLocation((int)p.getX(), (int)p.getY() - this.dropDownMenu.getHeight());
                    this.dropDownMenu.setVisible(true);
                }
            }
        } else {
            this.dropDownMenu.setVisible(false);
        }
    }

    @Override
    public void addActionListener(ActionListener al) {
        this.mainButton.addActionListener(al);
        super.addActionListener(al);
    }
}

