/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.interfaces.PFDCollapsableInterface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;

public class PFDUtil {
    public static PFDCollapsableInterface getParentCollapsable(PFDPrimitive p) {
        if (p == null) {
            return null;
        }
        PFDGroup g = p.getParent();
        if (g instanceof PFDCollapsableInterface) {
            return (PFDCollapsableInterface)((Object)g);
        }
        if (g != null) {
            return PFDUtil.getParentCollapsable(g);
        }
        return null;
    }

    public static void updateParentCollapsable(PFDPrimitive p) {
        PFDCollapsableInterface collapsable = PFDUtil.getParentCollapsable(p);
        if (collapsable == null) {
            return;
        }
        collapsable.updateCollapsed();
        if (collapsable instanceof PFDPrimitive) {
            PFDUtil.updateParentCollapsable((PFDPrimitive)((Object)collapsable));
        }
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.isHeadlessInstance()) {
            BufferedImage compatibleImage = new BufferedImage(width, height, 2);
            return compatibleImage;
        }
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static FontRenderContext getFontRenderContext() {
        BufferedImage image = PFDUtil.createCompatibleImage(2, 2, 3);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext frc = g.getFontRenderContext();
        g.dispose();
        return frc;
    }

    public static BufferedImage getScaledImage(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        int prevW = w;
        int prevH = h;
        BufferedImage oldScratchImage = null;
        BufferedImage newScratchImage = null;
        Graphics2D oldScratchGraphics = null;
        Graphics2D newScratchGraphics = null;
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (oldScratchImage == null) {
                oldScratchImage = new BufferedImage(w, h, type);
                newScratchImage = new BufferedImage(w, h, type);
                oldScratchGraphics = oldScratchImage.createGraphics();
                oldScratchGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                newScratchGraphics = newScratchImage.createGraphics();
                newScratchGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                newScratchGraphics.drawImage(img, 0, 0, w, h, 0, 0, prevW, prevH, null);
            } else {
                Composite oldComposite = newScratchGraphics.getComposite();
                newScratchGraphics.setComposite(AlphaComposite.Clear);
                newScratchGraphics.fillRect(0, 0, w, h);
                newScratchGraphics.setComposite(oldComposite);
                newScratchGraphics.drawImage(oldScratchImage, 0, 0, w, h, 0, 0, prevW, prevH, null);
            }
            ret = newScratchImage;
            prevW = w;
            prevH = h;
            BufferedImage tempImage = oldScratchImage;
            oldScratchImage = newScratchImage;
            newScratchImage = tempImage;
            Graphics2D tempGraphics = oldScratchGraphics;
            oldScratchGraphics = newScratchGraphics;
            newScratchGraphics = tempGraphics;
        } while (w != targetWidth || h != targetHeight);
        if (oldScratchGraphics != null) {
            oldScratchGraphics.dispose();
        }
        if (newScratchGraphics != null) {
            newScratchGraphics.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            BufferedImage buffer = new BufferedImage(targetWidth, targetHeight, type);
            Graphics2D bufferGraphics = buffer.createGraphics();
            bufferGraphics.drawImage((Image)ret, 0, 0, null);
            bufferGraphics.dispose();
            ret = buffer;
        }
        return ret;
    }

    public static Color brighter(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newBrightness = brightness + brightness * (float)percentage;
        newBrightness = (float)Math.min(1.0, (double)newBrightness);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static Color darker(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newBrightness = brightness - brightness * (float)percentage;
        newBrightness = (float)Math.max(0.0, (double)newBrightness);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static Color softer(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newSat = saturation - saturation * (float)percentage;
        newSat = (float)Math.max(0.0, (double)newSat);
        return Color.getHSBColor(hue, newSat, brightness);
    }

    public static Color sharper(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        float[] vals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float hue = vals[0];
        float saturation = vals[1];
        float brightness = vals[2];
        float newSat = saturation + saturation * (float)percentage;
        newSat = (float)Math.min(1.0, (double)newSat);
        return Color.getHSBColor(hue, newSat, brightness);
    }

    public static Color blend(Color c1, Color c2, double percentage) {
        if (c1 == null || c2 == null) {
            return null;
        }
        float[] c1Comps = c1.getRGBColorComponents(null);
        float[] c2Comps = c2.getRGBColorComponents(null);
        float red = (float)((1.0 - percentage) * (double)c1Comps[0] + percentage * (double)c2Comps[0]);
        float green = (float)((1.0 - percentage) * (double)c1Comps[1] + percentage * (double)c2Comps[1]);
        float blue = (float)((1.0 - percentage) * (double)c1Comps[2] + percentage * (double)c2Comps[2]);
        return new Color(red, green, blue);
    }
}

