/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDComponentWindow;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.ui.PFDScrollPane;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PFDTextPaneWindow
extends PFDComponentWindow
implements DocumentListener,
PropertyChangeListener {
    private static final String RB_KEY = "PFDTextPaneWindow.";
    protected transient JTextPane textEditPane;
    protected transient JScrollPane scrollPane;
    protected static final int maxNumChars = 256;
    protected boolean textEditable = true;
    protected boolean needsVerticalScrollbar = false;

    public PFDTextPaneWindow() {
        this.initialize();
    }

    private void initialize() {
        this.textEditPane = new JTextPane();
        this.textEditPane.setBackground(defaultFillColor);
        String fontName = RB.getStringResource(RB_KEY, "defaultFontName.txt");
        this.textEditPane.setFont(new Font(fontName, 0, 11));
        this.scrollPane = new PFDScrollPane(this.textEditPane);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.componentPrimitive.setComponent(this.scrollPane);
    }

    protected void setupTextPane(String text) {
        this.textEditPane.setText(text);
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("fillColor") || property.equals("all")) {
            this.textEditPane.setBackground(this.backgroundRect.getBrush().getColor());
        }
        super.update(property, v);
    }

    public void setText(String text) {
        this.textEditPane.setText(text);
        this.textEditPane.setCaretPosition(0);
    }

    public String getText() {
        return this.textEditPane.getText();
    }

    public JTextPane getTextPane() {
        return this.textEditPane;
    }

    public void pack() {
        Dimension minComponentSize = this.getContentSize(this.minWindowSize);
        Dimension maxComponentSize = this.getContentSize(this.maxWindowSize);
        Dimension newCompSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Dimension oldSize = this.textEditPane.getSize();
        Dimension prefSize = this.textEditPane.getPreferredSize();
        newCompSize.width = Math.max(Math.min(maxComponentSize.width, prefSize.width), minComponentSize.width);
        this.textEditPane.setSize(newCompSize);
        prefSize = this.textEditPane.getPreferredSize();
        newCompSize.height = Math.max(Math.min(maxComponentSize.height, prefSize.height), minComponentSize.height);
        if (prefSize.height > maxComponentSize.height) {
            this.needsVerticalScrollbar = true;
        }
        this.textEditPane.setSize(oldSize);
        this.setPreferredSize(this.getWindowSize(newCompSize));
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        if (this.textEditable) {
            v.addPropertyChangeListener("editMode", this);
            this.textEditPane.setEditable(v.isEditMode());
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        if (this.textEditable && v != null) {
            v.removePropertyChangeListener("editMode", this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof Boolean) {
            this.textEditPane.setEditable((Boolean)evt.getNewValue());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.textEditPane.getText());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize();
        Object text = in.readObject();
        if (text instanceof String) {
            this.setupTextPane((String)text);
        } else {
            this.setupTextPane(null);
        }
    }
}

