/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDHTMLParser;
import com.sas.graphics.components.pfd.PFDLineBreakMeasurer;
import com.sas.graphics.components.pfd.PFDOverview;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.parser.ParserDelegator;

public class PFDText
extends PFDDrawablePrimitive {
    public static final String RB_KEY = "PFDText.";
    public static final int HALIGN_CENTER = 0;
    public static final int HALIGN_LEFT = 1;
    public static final int HALIGN_RIGHT = 2;
    public static final int VALIGN_CENTER = 0;
    public static final int VALIGN_TOP = 1;
    public static final int VALIGN_BOTTOM = 2;
    protected String text;
    private String fontName = "Tahoma";
    private int fontStyle = 0;
    private int fontSize = 12;
    private Font font = null;
    private boolean userSetFont = false;
    private boolean transparent = true;
    private Color foreground = Color.black;
    private Color background = Color.lightGray;
    private boolean outlineOn = true;
    private Color outlineColor = Color.lightGray;
    private int hAlignment = 0;
    private int vAlignment = 0;
    private boolean clipping = false;
    private boolean multiline = false;
    private int wrapWidth = 50;
    private int clipHeight = Integer.MAX_VALUE;
    private int maxNumLines = Integer.MAX_VALUE;
    private transient AttributedString paragraph;
    private transient TextLayout singleLineLayout;
    private transient Vector multiLineLayouts = new Vector();
    private Point[] drawPoint;
    private transient Rectangle fillArea = new Rectangle();
    private boolean emptyText = true;
    private boolean html = false;
    private transient Vector htmlTextLayouts = new Vector();
    private transient Vector htmlTextDrawPoints = new Vector();
    private transient Vector htmlLineText = null;
    private Rectangle clipRect = null;
    private boolean truncateLines = false;
    private transient FontRenderContext frc = null;

    public PFDText() {
        this.createFontRenderContext();
        this.shadowSize = 1;
        this.shadowShift = 1;
        this.shadowOpacity = 0.35f;
        this.fontName = RB.getStringResource(RB_KEY, "defaultFontName.txt");
    }

    public PFDText(String s) {
        this();
        this.text = s;
    }

    protected void createFontRenderContext() {
        this.frc = PFDUtil.getFontRenderContext();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String s) {
        if (this.text != null && this.text.equals(s)) {
            return;
        }
        this.text = s;
        this.firePropertyChange("text");
    }

    public boolean isEmpty() {
        return this.emptyText;
    }

    public int getClipHeight() {
        return this.clipHeight;
    }

    public void setClipHeight(int height) {
        if (this.clipHeight == height) {
            return;
        }
        this.clipHeight = height;
        this.firePropertyChange("clipHeight");
    }

    public void setMaxLines(int max) {
        if (this.maxNumLines == max) {
            return;
        }
        this.maxNumLines = max;
        this.firePropertyChange("maxNumLines");
    }

    public int getMaxLines() {
        return this.maxNumLines;
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setHorizontalAlignment(int aInt) {
        if (this.hAlignment == aInt) {
            return;
        }
        this.checkHAlign(aInt);
        this.hAlignment = aInt;
        this.firePropertyChange("horizontalAlignment");
    }

    private void checkHAlign(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "halign.ex.txt"));
            }
        }
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public void setVerticalAlignment(int aInt) {
        if (this.vAlignment == aInt) {
            return;
        }
        this.checkVAlign(aInt);
        this.vAlignment = aInt;
        this.bbox.height = 0;
        this.firePropertyChange("verticalAlignment");
    }

    private void checkVAlign(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "valign.ex.txt"));
            }
        }
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean b) {
        if (this.clipping == b) {
            return;
        }
        this.clipping = b;
        this.firePropertyChange("clipping");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFont(Font font) {
        if (font == null) {
            if (!this.userSetFont) return;
            this.userSetFont = false;
            this.font = null;
        } else {
            this.userSetFont = true;
            if (font.equals(this.font)) {
                return;
            }
            this.font = font;
        }
        this.firePropertyChange("font");
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String name) {
        if (this.fontName.equals(name)) {
            return;
        }
        this.fontName = name;
        this.firePropertyChange("fontName");
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int style) {
        if (this.fontStyle == style) {
            return;
        }
        this.fontStyle = style;
        this.firePropertyChange("fontStyle");
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        if (this.fontSize == size) {
            return;
        }
        this.fontSize = size;
        this.firePropertyChange("fontSize");
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean b) {
        if (this.transparent == b) {
            return;
        }
        this.transparent = b;
        this.firePropertyChange("transparent");
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color c) {
        if (this.foreground != null && this.foreground.equals(c)) {
            return;
        }
        this.foreground = c;
        this.firePropertyChange("foreground");
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        if (this.background != null && this.background.equals(c)) {
            return;
        }
        this.background = c;
        this.firePropertyChange("background");
    }

    public void setOutlineColor(Color c) {
        if (this.outlineColor != null && this.outlineColor.equals(c)) {
            return;
        }
        this.outlineColor = c;
        this.firePropertyChange("background");
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean b) {
        if (this.multiline == b) {
            return;
        }
        this.multiline = b;
        this.firePropertyChange("multiline");
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int width) {
        if (this.wrapWidth == width) {
            return;
        }
        this.wrapWidth = Math.max(width, 0);
        this.firePropertyChange("wrapWidth");
    }

    public Rectangle getClipRectangle() {
        return this.clipRect;
    }

    public void setClipRectangle(Rectangle rect) {
        if (this.clipRect == rect) {
            return;
        }
        this.clipRect = rect;
        this.firePropertyChange("clipRect");
    }

    public boolean isTruncateLines() {
        return this.truncateLines;
    }

    public void setTruncateLines(boolean b) {
        if (this.truncateLines == b) {
            return;
        }
        this.truncateLines = b;
        this.firePropertyChange("truncateLines");
    }

    public int getNumLines() {
        if (this.html) {
            if (this.htmlTextLayouts == null) {
                return 0;
            }
            return this.htmlTextLayouts.size();
        }
        if (this.multiline) {
            if (this.multiLineLayouts == null) {
                return 0;
            }
            return this.multiLineLayouts.size();
        }
        return 1;
    }

    public float getLineHeight() {
        if (this.font == null) {
            return 0.0f;
        }
        String measureText = this.text == null ? "W" : this.text;
        LineMetrics lm = this.font.getLineMetrics(measureText, this.frc);
        return lm.getHeight();
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        int i;
        if (this.emptyText) {
            return;
        }
        if (!this.transparent) {
            g2d.setColor(this.background);
            g2d.fillRect(this.fillArea.x, this.fillArea.y, this.fillArea.width, this.fillArea.height);
            if (this.outlineOn) {
                g2d.setColor(this.outlineColor);
                g2d.drawRect(this.fillArea.x, this.fillArea.y, this.fillArea.width - 1, this.fillArea.height - 1);
            }
        }
        if (this.shadowOn) {
            boolean oldTransparent = this.transparent;
            this.transparent = true;
            boolean oldClipping = this.clipping;
            this.clipping = false;
            this.drawShadow(g2d, v);
            this.clipping = oldClipping;
            this.transparent = oldTransparent;
        }
        g2d.setColor(this.foreground);
        if (this.html) {
            for (i = 0; i < this.htmlTextLayouts.size(); ++i) {
                TextLayout layout = (TextLayout)this.htmlTextLayouts.elementAt(i);
                Point p = (Point)this.htmlTextDrawPoints.elementAt(i);
                layout.draw(g2d, p.x, p.y);
            }
        } else if (this.multiline) {
            for (i = 0; i < this.multiLineLayouts.size(); ++i) {
                TextLayout layout = (TextLayout)this.multiLineLayouts.elementAt(i);
                layout.draw(g2d, this.drawPoint[i].x, this.drawPoint[i].y);
            }
        } else {
            this.singleLineLayout.draw(g2d, this.drawPoint[0].x, this.drawPoint[0].y);
        }
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
    }

    @Override
    protected void update(String property, PFDView v) {
        if (v instanceof PFDOverview) {
            return;
        }
        if (property.equals("fontName") || property.equals("fontStyle") || property.equals("fontSize") || property.equals("font") || property.equals("all")) {
            this.fontChanged();
            this.textChanged();
            this.layoutText();
            this.updateVisualBBox();
        } else if (property.equals("text") || property.equals("multiline") || property.equals("wrapWidth") || property.equals("truncateLines")) {
            this.textChanged();
            this.layoutText();
            this.updateVisualBBox();
        } else if (property.equals("bbox") || property.equals("transparent") || property.equals("verticalAlignment") || property.equals("horizontalAlignment") || property.equals("clipHeight") || property.equals("clipRect") || property.equals("maxNumLines")) {
            this.layoutText();
            this.updateVisualBBox();
        }
        super.update(property, v);
    }

    public void forceUpdate() {
        this.fontChanged();
        this.textChanged();
        this.layoutText();
        this.updateVisualBBox();
    }

    public boolean isHTML() {
        if (this.text == null) {
            return false;
        }
        return BasicHTML.isHTMLString(this.text);
    }

    protected void fontChanged() {
        if (!this.userSetFont) {
            this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
        }
    }

    private boolean computeEmptyText() {
        if (this.text == null || this.text.length() == 0) {
            return true;
        }
        for (int i = 0; i < this.text.length(); ++i) {
            if (Character.isWhitespace(this.text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void textChanged() {
        this.emptyText = this.computeEmptyText();
        if (this.emptyText) {
            this.bbox.width = 0;
            this.bbox.height = 0;
            if (this.getGroup() != null) {
                this.getGroup().markBBoxDirty();
            }
            if (this.getModel() != null) {
                this.getModel().updateSize(this);
            }
            return;
        }
        this.html = BasicHTML.isHTMLString(this.text);
        if (this.html) {
            PFDHTMLParser htmlParser = new PFDHTMLParser();
            htmlParser.setDefaultFont(this.font);
            htmlParser.setDefaultColor(this.foreground);
            StringReader htmlReader = new StringReader(this.text);
            try {
                new ParserDelegator().parse(htmlReader, htmlParser, true);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            this.htmlLineText = htmlParser.getStyledLineText();
        } else if (this.multiline) {
            this.paragraph = new AttributedString(this.text);
        } else {
            this.singleLineLayout = new TextLayout(this.text, this.font, this.frc);
        }
    }

    private void padEllipses() {
        if (this.clipHeight == Integer.MAX_VALUE && this.maxNumLines == Integer.MAX_VALUE) {
            return;
        }
        if (this.paragraph == null) {
            this.textChanged();
        }
        this.paragraph.addAttribute(TextAttribute.FONT, this.font);
        AttributedCharacterIterator styledText = this.paragraph.getIterator();
        PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
        int totalHeight = 0;
        int lastStartPos = 0;
        int lastCharPos = lineMeasurer.getPosition();
        int numLines = 0;
        while (lineMeasurer.getPosition() < styledText.getEndIndex()) {
            TextLayout layout = lineMeasurer.nextLayout(this.wrapWidth);
            if (layout == null) continue;
            int lineHeight = (int)Math.ceil(layout.getAscent() + layout.getDescent() + layout.getLeading());
            if (totalHeight + lineHeight > this.clipHeight || ++numLines > this.maxNumLines) {
                if (lastCharPos >= 1 && this.text.charAt(lastCharPos - 1) == '\n') {
                    --lastCharPos;
                }
                float lineWidth = Float.MAX_VALUE;
                while (lineWidth > (float)this.wrapWidth && lastCharPos > lastStartPos) {
                    String lastLine = this.text.substring(lastStartPos, lastCharPos) + "...";
                    AttributedString line = new AttributedString(lastLine);
                    line.addAttribute(TextAttribute.FONT, this.font);
                    AttributedCharacterIterator iterator = line.getIterator();
                    TextMeasurer tm = new TextMeasurer(iterator, this.frc);
                    lineWidth = tm.getAdvanceBetween(0, lastLine.length());
                    --lastCharPos;
                }
                String newText = this.text.substring(0, lastCharPos + 1) + "...";
                this.paragraph = new AttributedString(newText);
                break;
            }
            totalHeight += lineHeight;
            lastStartPos = lastCharPos;
            lastCharPos = lineMeasurer.getPosition();
        }
    }

    private void padEllipsesTruncate() {
        int startIndex;
        int newLineIndex;
        if (this.clipHeight == Integer.MAX_VALUE && this.maxNumLines == Integer.MAX_VALUE) {
            return;
        }
        if (this.paragraph == null) {
            this.textChanged();
        }
        if ((newLineIndex = this.text.indexOf(10, startIndex = 0)) < 0) {
            this.padEllipses();
            return;
        }
        StringBuffer newText = new StringBuffer();
        do {
            String ellipsesString = this.padSingleLineEllipses(this.text.substring(startIndex, newLineIndex));
            newText.append(ellipsesString);
            newText.append('\n');
        } while ((newLineIndex = this.text.indexOf(10, startIndex = newLineIndex + 1)) >= 0);
        if (startIndex < this.text.length()) {
            String lastLine = this.padSingleLineEllipses(this.text.substring(startIndex));
            newText.append(lastLine);
        }
        this.paragraph = new AttributedString(newText.toString());
    }

    private String padSingleLineEllipses(String lineText) {
        AttributedString line = new AttributedString(lineText);
        line.addAttribute(TextAttribute.FONT, this.font);
        AttributedCharacterIterator styledText = line.getIterator();
        PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
        TextLayout layout = lineMeasurer.nextLayout(this.wrapWidth, false);
        int lastCharPos = lineMeasurer.getPosition();
        if (lastCharPos < styledText.getEndIndex() && lastCharPos > 2) {
            String newText = lineText.substring(0, lastCharPos - 2) + "...";
            return newText;
        }
        return lineText;
    }

    private void padLineEllipses(Vector lineText) {
        Point textPosition = new Point(0, 0);
        for (int i = 0; i < lineText.size(); ++i) {
            int runEnd;
            int runStart;
            AttributedCharacterIterator styledText = ((AttributedString)lineText.elementAt(i)).getIterator();
            PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
            int numChars = this.getNumLineChars(styledText, textPosition);
            if (numChars == 0 || numChars >= styledText.getEndIndex()) continue;
            if (!this.truncateLines) {
                lineText.set(i, new AttributedString(styledText, 0, numChars));
                lineText.insertElementAt(new AttributedString(styledText, numChars, styledText.getEndIndex()), i + 1);
                continue;
            }
            AttributedCharacterIterator newStyledText = ((AttributedString)lineText.elementAt(i)).getIterator(null, 0, numChars);
            Vector<Map<AttributedCharacterIterator.Attribute, Object>> attributes = new Vector<Map<AttributedCharacterIterator.Attribute, Object>>();
            Vector<Integer> runLengths = new Vector<Integer>();
            StringBuffer text = new StringBuffer(numChars);
            char currChar = newStyledText.current();
            while (currChar != '\uffff') {
                runStart = newStyledText.getRunStart();
                runEnd = newStyledText.getRunLimit();
                Map<AttributedCharacterIterator.Attribute, Object> runAttribute = newStyledText.getAttributes();
                while (newStyledText.getIndex() < runEnd) {
                    text.append(currChar);
                    currChar = newStyledText.next();
                }
                attributes.add(runAttribute);
                runLengths.add(new Integer(runEnd - runStart));
            }
            if (text.length() >= 3) {
                int nextLastRun;
                int numRuns = runLengths.size();
                int lastRun = numRuns == 0 ? 0 : (Integer)runLengths.elementAt(numRuns - 1);
                int n = nextLastRun = numRuns < 2 ? 0 : (Integer)runLengths.elementAt(numRuns - 2);
                if (lastRun < 3) {
                    attributes.remove(numRuns - 1);
                    runLengths.remove(numRuns - 1);
                    runLengths.set(numRuns - 2, new Integer(lastRun + nextLastRun));
                }
                text.replace(text.length() - 3, text.length(), "...");
            }
            AttributedString newLineText = new AttributedString(text.toString());
            runStart = 0;
            for (int j = 0; j < attributes.size(); ++j) {
                runEnd = runStart + (Integer)runLengths.get(j);
                newLineText.addAttributes((Map)attributes.get(j), runStart, runEnd);
                runStart = runEnd;
            }
            lineText.set(i, newLineText);
        }
    }

    protected void layoutText() {
        if (this.emptyText) {
            return;
        }
        int oldX = this.bbox.x;
        int oldY = this.bbox.y;
        int oldWidth = this.bbox.width;
        int oldHeight = this.bbox.height;
        if (this.html) {
            if (this.htmlLineText == null || this.htmlLineText.size() < 1) {
                return;
            }
            Vector workingLineText = (Vector)this.htmlLineText.clone();
            this.padLineEllipses(workingLineText);
            this.htmlTextLayouts.removeAllElements();
            this.htmlTextDrawPoints.removeAllElements();
            int totalHeight = 0;
            int maxAdvance = 0;
            int drawPosX = 0;
            int drawPosY = 0;
            for (int i = 0; i < workingLineText.size(); ++i) {
                float leading;
                float descent;
                AttributedCharacterIterator styledText = ((AttributedString)workingLineText.elementAt(i)).getIterator();
                if (styledText.getEndIndex() == 1 && styledText.first() == ' ') {
                    Font lineFont = (Font)styledText.getAttribute(TextAttribute.FONT);
                    if (lineFont == null) continue;
                    LineMetrics lm = lineFont.getLineMetrics(" ", this.frc);
                    int lineHeight = (int)Math.ceil(lm.getAscent() + lm.getDescent() + lm.getLeading());
                    if (totalHeight + lineHeight > this.clipHeight) break;
                    totalHeight += lineHeight;
                    drawPosY += lineHeight;
                    continue;
                }
                PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
                TextLayout heightLayout = lineMeasurer.nextLayout(this.wrapWidth);
                if (heightLayout == null) continue;
                float ascent = heightLayout.getAscent();
                int lineHeight = (int)Math.ceil(ascent + (descent = heightLayout.getDescent()) + (leading = heightLayout.getLeading()));
                if (totalHeight + lineHeight > this.clipHeight && totalHeight != 0) break;
                drawPosX = 0;
                boolean currentPosition = false;
                lineMeasurer.setPosition(0);
                Rectangle lineBBox = this.calculateLayoutBBox(new Rectangle(drawPosX, drawPosY, this.wrapWidth, lineHeight));
                if (lineBBox == null || lineBBox.isEmpty()) {
                    drawPosY += lineHeight;
                    totalHeight += lineHeight;
                    continue;
                }
                drawPosX = lineBBox.x;
                int lineWidth = lineBBox.width;
                TextLayout layout = lineMeasurer.nextLayout(lineWidth);
                if (layout == null) continue;
                if ((int)layout.getVisibleAdvance() + drawPosX > maxAdvance) {
                    maxAdvance = (int)layout.getVisibleAdvance() + drawPosX;
                }
                this.htmlTextLayouts.addElement(layout);
                this.htmlTextDrawPoints.addElement(new Point(drawPosX, drawPosY + (int)ascent));
                drawPosY += lineHeight;
                totalHeight += lineHeight;
            }
            this.bbox.width = maxAdvance;
            this.bbox.height = totalHeight;
            int w = this.bbox.width;
            int h = this.bbox.height;
            if (this.hAlignment == 0) {
                this.bbox.x += -(this.bbox.width - oldWidth) / 2;
            } else if (this.hAlignment == 2) {
                this.bbox.x += -(this.bbox.width - oldWidth);
            }
            if (this.vAlignment == 0) {
                this.bbox.y += -(this.bbox.height - oldHeight) / 2;
            } else if (this.vAlignment == 2) {
                this.bbox.y += -(this.bbox.height - oldHeight);
            }
            if (!this.transparent) {
                this.fillArea.setRect(this.bbox.x - 3, this.bbox.y - 3, w + 6, h + 6);
            }
            for (int i = 0; i < this.htmlTextDrawPoints.size(); ++i) {
                Point currPoint = (Point)this.htmlTextDrawPoints.get(i);
                currPoint.x = this.hAlignment == 0 ? (currPoint.x += this.bbox.x + (this.bbox.width - maxAdvance) / 2) : (this.hAlignment == 1 ? (currPoint.x += this.bbox.x) : (currPoint.x += this.bbox.x + this.bbox.width - maxAdvance));
                currPoint.y += this.bbox.y;
            }
            if (this.getGroup() != null) {
                this.getGroup().markBBoxDirty();
            }
            if (this.getModel() != null) {
                this.getModel().updateSize(this);
            }
        } else if (this.multiline) {
            TextLayout layout;
            this.paragraph = new AttributedString(this.text);
            if (this.truncateLines) {
                this.padEllipsesTruncate();
            } else {
                this.padEllipses();
            }
            this.paragraph.addAttribute(TextAttribute.FONT, this.font);
            AttributedCharacterIterator styledText = this.paragraph.getIterator();
            this.multiLineLayouts.removeAllElements();
            PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
            int totalHeight = 0;
            int maxAdvance = 0;
            while (lineMeasurer.getPosition() < styledText.getEndIndex()) {
                layout = lineMeasurer.nextLayout(this.wrapWidth);
                if (layout == null) continue;
                int lineHeight = (int)Math.ceil(layout.getAscent() + layout.getDescent() + layout.getLeading());
                if (totalHeight + lineHeight > this.clipHeight) {
                    if (totalHeight != 0) break;
                    totalHeight = lineHeight;
                    maxAdvance = (int)layout.getVisibleAdvance();
                    this.multiLineLayouts.addElement(layout);
                    break;
                }
                totalHeight += lineHeight;
                if (layout.getVisibleAdvance() > (float)maxAdvance) {
                    maxAdvance = (int)layout.getVisibleAdvance();
                }
                this.multiLineLayouts.addElement(layout);
            }
            this.bbox.width = maxAdvance;
            this.bbox.height = totalHeight;
            this.drawPoint = new Point[this.multiLineLayouts.size()];
            int w = this.bbox.width;
            int h = this.bbox.height;
            if (this.hAlignment == 0) {
                this.bbox.x += -(this.bbox.width - oldWidth) / 2;
            } else if (this.hAlignment == 2) {
                this.bbox.x += -(this.bbox.width - oldWidth);
            }
            if (this.vAlignment == 0) {
                this.bbox.y += -(this.bbox.height - oldHeight) / 2;
            } else if (this.vAlignment == 2) {
                this.bbox.y += -(this.bbox.height - oldHeight);
            }
            if (!this.transparent) {
                this.fillArea.setRect(this.bbox.x - 3, this.bbox.y - 3, w + 6, h + 6);
            }
            int drawPosY = this.bbox.y;
            for (int i = 0; i < this.multiLineLayouts.size(); ++i) {
                layout = (TextLayout)this.multiLineLayouts.elementAt(i);
                int drawPosX = this.hAlignment == 0 ? this.bbox.x + (int)((float)this.bbox.width - layout.getVisibleAdvance()) / 2 : (this.hAlignment == 1 ? this.bbox.x : this.bbox.x + (int)((float)this.bbox.width - layout.getVisibleAdvance()));
                this.drawPoint[i] = new Point(drawPosX, drawPosY + (int)layout.getAscent());
                drawPosY += (int)Math.ceil(layout.getAscent() + layout.getDescent() + layout.getLeading());
            }
            if (this.getGroup() != null) {
                this.getGroup().markBBoxDirty();
            }
            if (this.getModel() != null) {
                this.getModel().updateSize(this);
            }
        } else {
            if (this.clipping) {
                String newText = this.padSingleLineEllipses(this.text);
                this.singleLineLayout = new TextLayout(newText, this.font, this.frc);
            }
            TextLayout layout = this.singleLineLayout;
            Rectangle2D bounds = layout.getBounds();
            int dx = 0;
            int dy = 0;
            int w = (int)bounds.getWidth();
            int h = (int)bounds.getHeight();
            this.bbox.width = (int)layout.getVisibleAdvance();
            this.bbox.height = (int)Math.ceil(layout.getAscent() + layout.getDescent() + layout.getLeading());
            dx = 0;
            if (this.hAlignment == 0) {
                this.bbox.x += -(this.bbox.width - oldWidth) / 2;
            } else if (this.hAlignment == 2) {
                this.bbox.x += -(this.bbox.width - oldWidth);
            }
            dy = (int)layout.getAscent();
            if (this.vAlignment == 0) {
                this.bbox.y += -(this.bbox.height - oldHeight) / 2;
            } else if (this.vAlignment == 2) {
                this.bbox.y += -(this.bbox.height - oldHeight);
            }
            if (!this.transparent) {
                this.fillArea.setRect(this.bbox.x + dx + (int)bounds.getX() - 3, this.bbox.y + dy + (int)bounds.getY() - 3, w + 6, h + 6);
            }
            this.drawPoint = new Point[1];
            this.drawPoint[0] = new Point(this.bbox.x + dx, this.bbox.y + dy);
            if (this.getGroup() != null) {
                this.getGroup().markBBoxDirty();
            }
            if (this.getModel() != null) {
                this.getModel().updateSize(this);
            }
        }
    }

    private Rectangle calculateLayoutBBox(Rectangle rect) {
        if (this.clipRect == null || this.hAlignment != 1 || this.vAlignment != 1) {
            return rect;
        }
        Rectangle intersection = this.clipRect.intersection(rect);
        if (intersection.isEmpty()) {
            return rect;
        }
        if (intersection.x > rect.x) {
            return new Rectangle(rect.x, rect.y, intersection.x - rect.x, rect.height);
        }
        if (intersection.x + intersection.width < rect.x + rect.width) {
            return new Rectangle(intersection.x + intersection.width, rect.y, rect.x + rect.width - intersection.x - intersection.width, rect.height);
        }
        return new Rectangle();
    }

    private int getNumLineChars(AttributedCharacterIterator styledText, Point p) {
        int drawPosX = p.x;
        int drawPosY = p.y;
        int lineHeight = 0;
        int lineWidth = this.wrapWidth - drawPosX;
        if (styledText.getEndIndex() == 1 && styledText.first() == ' ') {
            Font lineFont = (Font)styledText.getAttribute(TextAttribute.FONT);
            if (lineFont != null) {
                LineMetrics lm = lineFont.getLineMetrics(" ", this.frc);
                lineHeight = (int)Math.ceil(lm.getAscent() + lm.getDescent() + lm.getLeading());
                p.y += lineHeight;
            }
            return 1;
        }
        PFDLineBreakMeasurer lineMeasurer = new PFDLineBreakMeasurer(styledText, this.frc);
        lineWidth = this.wrapWidth - drawPosX;
        TextLayout heightLayout = lineMeasurer.nextLayout(this.wrapWidth);
        if (heightLayout == null) {
            return 0;
        }
        lineHeight = (int)Math.ceil(heightLayout.getAscent() + heightLayout.getDescent() + heightLayout.getLeading());
        lineMeasurer.setPosition(0);
        Rectangle lineBBox = this.calculateLayoutBBox(new Rectangle(drawPosX, drawPosY, lineWidth, lineHeight));
        p.y = drawPosY + lineHeight;
        if (lineBBox == null || lineBBox.isEmpty()) {
            return 0;
        }
        TextLayout layout = lineMeasurer.nextLayout(lineBBox.width, !this.truncateLines);
        return lineMeasurer.getPosition();
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDText clone = new PFDText();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDText toObject) {
        super.copyObject(toObject);
        toObject.setText(this.getText());
        toObject.setHorizontalAlignment(this.getHorizontalAlignment());
        toObject.setVerticalAlignment(this.getVerticalAlignment());
        toObject.setClipping(this.isClipping());
        toObject.setFontName(this.getFontName());
        toObject.setFontStyle(this.getFontStyle());
        toObject.setFontSize(this.getFontSize());
        toObject.setTransparent(this.isTransparent());
        toObject.setForeground(this.getForeground());
        toObject.setBackground(this.getBackground());
        toObject.setMultiline(this.isMultiline());
        toObject.setWrapWidth(this.getWrapWidth());
    }

    @Override
    protected void updateVisualBBox() {
        super.updateVisualBBox();
        if (!this.transparent) {
            this.visualBBox.add(this.fillArea);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createFontRenderContext();
        this.multiLineLayouts = new Vector();
        this.htmlTextLayouts = new Vector();
        this.htmlTextDrawPoints = new Vector();
        this.fillArea = new Rectangle();
        this.fontChanged();
        this.textChanged();
        this.layoutText();
        this.updateVisualBBox();
    }
}

