/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDTablePrimitive;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PFDTableNode
extends PFDAbstractNode
implements AdjustmentListener {
    public static final String RB_KEY = "PFDTableNode.";
    private PFDText label = null;
    private PFDTablePrimitive table = null;
    private PFDPort[][] inPort = null;
    private PFDPort[][] outPort = null;
    String text;
    boolean showPorts = true;
    Point tableLocation;
    Dimension tableSize;
    TableModel[] tableModel;
    private transient JTable[] jtable;
    transient JScrollPane js;
    int scrolledY = 0;
    double verticalScale = 1.0;

    public PFDTableNode(Point loc, Dimension size, TableModel tm, String label) {
        if (tm == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "tableModel.ex.txt"));
        }
        this.setBreakable(false);
        this.tableLocation = loc;
        this.tableSize = size;
        this.tableModel = new TableModel[1];
        this.tableModel[0] = tm;
        this.text = label;
        this.initialize();
    }

    public PFDTableNode(Point loc, Dimension size, TableModel[] tm, String label) {
        if (tm == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "tableModel.ex.txt"));
        }
        this.setBreakable(false);
        this.tableLocation = loc;
        this.tableSize = size;
        this.tableModel = tm;
        this.text = label;
        this.initialize();
    }

    public JTable getTableComponent(int index) {
        if (index < 0 || index >= this.jtable.length) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "tableIndex.ex.txt"));
        }
        return this.jtable[index];
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public boolean isForceShowPorts() {
        return this.showPorts;
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.showPorts == b) {
            return;
        }
        this.showPorts = b;
        for (int i = 0; i < this.jtable.length; ++i) {
            int rows = this.jtable[i].getModel().getRowCount();
            for (int j = 0; j < rows; ++j) {
                this.inPort[i][j].setVisible(b);
                this.outPort[i][j].setVisible(b);
            }
        }
    }

    private void checkPort(int index, int row) {
        if (index < 0 || index >= this.jtable.length) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "tableIndex.ex.txt"));
        }
        int rows = this.jtable[index].getModel().getRowCount();
        if (row < 0 || row >= rows) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "tableRow.ex.txt"));
        }
    }

    public PFDPort getInPort(int index, int row) {
        this.checkPort(index, row);
        return this.inPort[index][row];
    }

    public PFDPort getOutPort(int index, int row) {
        this.checkPort(index, row);
        return this.outPort[index][row];
    }

    protected void initialize() {
        int j;
        int i;
        this.label = new PFDText(this.text);
        if (this.tableModel == null) {
            this.jtable = new JTable[1];
            this.jtable[0] = new JTable();
        } else {
            this.jtable = new JTable[this.tableModel.length];
            for (int i2 = 0; i2 < this.tableModel.length; ++i2) {
                this.jtable[i2] = new JTable(this.tableModel[i2]);
            }
        }
        if (this.jtable.length > 1) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            for (int i3 = 0; i3 < this.jtable.length; ++i3) {
                this.jtable[i3].getTableHeader().setBackground(new Color(95, 98, 139));
                this.jtable[i3].getTableHeader().setForeground(Color.white);
                this.jtable[i3].sizeColumnsToFit(-1);
                JPanel tabPanel = new JPanel(new BorderLayout());
                tabPanel.add((Component)this.jtable[i3].getTableHeader(), "North");
                tabPanel.add((Component)this.jtable[i3], "Center");
                Dimension d = new Dimension(this.tableSize.width, tabPanel.getPreferredSize().height);
                tabPanel.setPreferredSize(d);
                panel.add(tabPanel);
            }
            this.js = new JScrollPane(panel);
        } else {
            this.jtable[0].getTableHeader().setBackground(new Color(95, 98, 139));
            this.jtable[0].getTableHeader().setForeground(Color.white);
            this.jtable[0].sizeColumnsToFit(-1);
            Dimension d = new Dimension(this.tableSize.width, this.jtable[0].getPreferredSize().height);
            this.jtable[0].setPreferredSize(d);
            this.js = new JScrollPane(this.jtable[0]);
        }
        this.js.setHorizontalScrollBarPolicy(30);
        this.js.setVerticalScrollBarPolicy(20);
        int rh = this.jtable[0].getRowHeight();
        this.js.getVerticalScrollBar().setBlockIncrement(rh);
        this.js.getVerticalScrollBar().setUnitIncrement(rh);
        this.js.getVerticalScrollBar().addAdjustmentListener(this);
        this.table = new PFDTablePrimitive(this.js);
        this.table.setDraggable(false);
        this.table.setSelectable(false);
        this.table.setBBox(this.tableLocation, this.tableSize);
        int tables = this.jtable.length;
        this.inPort = new PFDPort[tables][];
        this.outPort = new PFDPort[tables][];
        for (i = 0; i < tables; ++i) {
            int rows = this.jtable[i].getModel().getRowCount();
            this.inPort[i] = new PFDPort[rows];
            this.outPort[i] = new PFDPort[rows];
            for (j = 0; j < rows; ++j) {
                this.inPort[i][j] = new PFDPort();
                this.inPort[i][j].setName("table" + i + " input" + j);
                this.inPort[i][j].setValidFromPort(false);
                this.inPort[i][j].setValidToPort(true);
                this.inPort[i][j].setToLinkDirection(0.0);
                this.inPort[i][j].setType(0);
                this.inPort[i][j].setToLinkSpot(8);
                this.inPort[i][j].getBrush().setColor(Color.black);
                this.outPort[i][j] = new PFDPort();
                this.outPort[i][j].setName("table" + i + " output" + j);
                this.outPort[i][j].setValidFromPort(true);
                this.outPort[i][j].setValidToPort(false);
                this.outPort[i][j].setFromLinkDirection(0.0);
                this.outPort[i][j].setType(0);
                this.outPort[i][j].setFromLinkSpot(4);
                this.outPort[i][j].getBrush().setColor(Color.black);
            }
        }
        this.addPrimitive(this.label);
        this.addPrimitive(this.table);
        for (i = 0; i < tables; ++i) {
            int rows = this.jtable[i].getModel().getRowCount();
            for (j = 0; j < rows; ++j) {
                this.addPrimitive(this.inPort[i][j]);
                this.addPrimitive(this.outPort[i][j]);
            }
        }
        this.layoutChildren();
    }

    protected void reInitialize() {
        if (this.tableModel == null) {
            this.jtable = new JTable[1];
            this.jtable[0] = new JTable();
        } else {
            this.jtable = new JTable[this.tableModel.length];
            for (int i = 0; i < this.tableModel.length; ++i) {
                this.jtable[i] = new JTable(this.tableModel[i]);
            }
        }
        if (this.jtable.length > 1) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            for (int i = 0; i < this.jtable.length; ++i) {
                this.jtable[i].getTableHeader().setBackground(new Color(95, 98, 139));
                this.jtable[i].getTableHeader().setForeground(Color.white);
                this.jtable[i].sizeColumnsToFit(-1);
                JPanel tabPanel = new JPanel(new BorderLayout());
                tabPanel.add((Component)this.jtable[i].getTableHeader(), "North");
                tabPanel.add((Component)this.jtable[i], "Center");
                Dimension d = new Dimension(this.tableSize.width, tabPanel.getPreferredSize().height);
                tabPanel.setPreferredSize(d);
                panel.add(tabPanel);
            }
            this.js = new JScrollPane(panel);
        } else {
            this.jtable[0].getTableHeader().setBackground(new Color(95, 98, 139));
            this.jtable[0].getTableHeader().setForeground(Color.white);
            this.jtable[0].sizeColumnsToFit(-1);
            Dimension d = new Dimension(this.tableSize.width, this.jtable[0].getPreferredSize().height);
            this.jtable[0].setPreferredSize(d);
            this.js = new JScrollPane(this.jtable[0]);
        }
        this.js.setHorizontalScrollBarPolicy(30);
        this.js.setVerticalScrollBarPolicy(20);
        int rh = this.jtable[0].getRowHeight();
        this.js.getVerticalScrollBar().setBlockIncrement(rh);
        this.js.getVerticalScrollBar().setUnitIncrement(rh);
        this.js.getVerticalScrollBar().addAdjustmentListener(this);
        this.table = new PFDTablePrimitive(this.js);
        this.table.setDraggable(false);
        this.table.setSelectable(false);
        this.table.setBBox(this.tableLocation, this.tableSize);
        int tables = this.jtable.length;
        this.addPrimitive(this.table);
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        super.setForcedBBox(x, y, w, h);
        this.layoutPorts();
    }

    protected void layoutChildren() {
        Rectangle bb = this.table.getRBBox();
        Point p = new Point();
        this.table.getSpotLocation(2, p);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(2);
        this.label.setBBox(p.x, p.y, 0, 0);
        this.layoutPorts();
        this.calculateBBox();
    }

    protected void layoutPorts() {
        Rectangle bb = this.table.getRBBox();
        boolean clipped = false;
        int tables = this.jtable.length;
        int tabHeight = 0;
        for (int i = 0; i < tables; ++i) {
            int rows = this.jtable[i].getModel().getRowCount();
            int rh = this.jtable[i].getRowHeight();
            rh = (int)((double)rh / this.verticalScale + 0.5);
            int th = this.jtable[i].getTableHeader().getHeight();
            if (th == 0) {
                Dimension d = this.jtable[i].getTableHeader().getPreferredSize();
                th = d.height;
            }
            th = (int)((double)th / this.verticalScale + 0.5);
            for (int j = 0; j < rows; ++j) {
                Rectangle r = this.jtable[i].getCellRect(j, 0, true);
                int xi = bb.x + r.x - 1;
                int xo = bb.x + bb.width + r.x - 1;
                int y = tabHeight + bb.y + th + (int)(((double)j + 0.5) * (double)rh) + this.scrolledY;
                if (y < bb.y || y > bb.y + bb.height) {
                    this.inPort[i][j].setVisible(false);
                    this.outPort[i][j].setVisible(false);
                    clipped = true;
                } else {
                    this.inPort[i][j].setVisible(true);
                    this.outPort[i][j].setVisible(true);
                    clipped = false;
                }
                y = Math.max(y, bb.y);
                y = Math.min(y, bb.y + bb.height);
                if (clipped) {
                    this.inPort[i][j].setBBox(xi - 3, y - 3, 3, 3);
                    this.outPort[i][j].setBBox(xo + 3, y - 3, 3, 3);
                    continue;
                }
                this.inPort[i][j].setBBox(xi, y, 1, 1);
                this.outPort[i][j].setBBox(xo, y, 1, 1);
            }
            tabHeight += (int)((double)this.jtable[i].getPreferredSize().height / this.verticalScale + 0.5) + th;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar sb = (JScrollBar)e.getAdjustable();
        this.scrolledY = -sb.getValue();
        this.layoutPorts();
    }

    @Override
    public Object cloneObject(Hashtable cloneTable) {
        PFDTableNode clone = new PFDTableNode(this.table.getLocation(), this.table.getSize(), this.tableModel, this.text);
        clone.setForceShowPorts(this.isForceShowPorts());
        this.label.copyObject(clone.getLabel());
        cloneTable.put(this, clone);
        cloneTable.put(this.table, clone.table);
        for (int i = 0; i < this.jtable.length; ++i) {
            int r = this.jtable[i].getModel().getRowCount();
            for (int j = 0; j < r; ++j) {
                cloneTable.put(this.getInPort(i, j), clone.getInPort(i, j));
                cloneTable.put(this.getOutPort(i, j), clone.getOutPort(i, j));
            }
        }
        return clone;
    }

    @Override
    public PFDPort getPort(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.jtable.length; ++i) {
            int r = this.jtable[i].getModel().getRowCount();
            for (int j = 0; j < r; ++j) {
                if (this.getInPort(i, j) != null && name.equals(this.getInPort(i, j).getName())) {
                    return this.getInPort(i, j);
                }
                if (this.getOutPort(i, j) == null || !name.equals(this.getOutPort(i, j).getName())) continue;
                return this.getOutPort(i, j);
            }
        }
        return null;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        boolean scaleChanged;
        boolean bl = scaleChanged = this.verticalScale != v.getScale();
        if (scaleChanged) {
            this.verticalScale = v.getScale();
        }
        super.render(g2d, v);
        if (scaleChanged) {
            this.layoutPorts();
        }
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.inPort[0][0];
    }

    @Override
    public PFDPort getOutputPort() {
        return this.outPort[0][0];
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        for (int i = 0; i < this.jtable.length; ++i) {
            this.jtable[i].getTableHeader().setVisible(b);
            this.jtable[i].setVisible(b);
        }
        this.js.setVisible(b);
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.tableModel.length; ++i) {
            for (int j = 0; j < this.inPort[i].length; ++j) {
                PFDPort p = this.inPort[i][j];
                if (!p.isValidToPort()) continue;
                Vector inLinks = p.getToLinks();
                for (int k = 0; k < inLinks.size(); ++k) {
                    PFDLink l = (PFDLink)inLinks.elementAt(k);
                    if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
                    pv.addElement(l.getFromNode());
                }
            }
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        for (int i = 0; i < this.tableModel.length; ++i) {
            for (int j = 0; j < this.outPort[i].length; ++j) {
                PFDPort p = this.outPort[i][j];
                if (!p.isValidFromPort()) continue;
                Vector outLinks = p.getFromLinks();
                for (int k = 0; k < outLinks.size(); ++k) {
                    PFDLink l = (PFDLink)outLinks.elementAt(k);
                    if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
                    cv.addElement(l.getToNode());
                }
            }
        }
        return cv;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.removePrimitive(this.table);
        this.reInitialize();
    }
}

