/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDEllipse;
import com.sas.graphics.components.pfd.PFDFlowChartShapes;
import com.sas.graphics.components.pfd.PFDImage;
import com.sas.graphics.components.pfd.PFDLabeledNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDPolygon;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDRoundRectangle;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.interfaces.NodeLayoutInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PFDSimpleShapeNode
extends PFDAbstractNode
implements PFDLabeledNodeInterface {
    public static final String RB_KEY = "PFDSimpleShapeNode.";
    protected PFDDrawablePrimitive drawable = null;
    protected PFDText label = null;
    protected PFDPort port = null;
    protected int shape = 2;
    protected int labelPosition = 0;
    protected boolean gradientColor = false;
    protected Point location;
    protected Dimension size;
    protected String text;
    protected int labelXPadding = 3;
    protected int labelYPadding = 1;
    protected PFDImage icon = null;
    protected ImageIcon image = null;
    protected int iconPosition = 0;
    protected int iconPadding = 0;

    public PFDSimpleShapeNode() {
        this(new Point(0, 0), new Dimension(0, 0), null);
    }

    public PFDSimpleShapeNode(Point loc, Dimension size, String label) {
        this(loc, size, 2, label);
    }

    public PFDSimpleShapeNode(Point loc, Dimension size, int shape, String label) {
        this.checkShape(shape);
        this.setBreakable(false);
        this.location = loc;
        this.size = size;
        this.shape = shape;
        this.text = label;
        this.initialize();
    }

    public PFDDrawablePrimitive getDrawable() {
        return this.drawable;
    }

    public boolean isGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(boolean b) {
        String hctString = System.getProperty("HIGH_CONTRAST_TESTING");
        this.gradientColor = hctString != null ? false : b;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        if (this.shape == shape) {
            return;
        }
        this.checkShape(shape);
        this.shape = shape;
        this.removePrimitive(this.drawable);
        this.createDrawable();
        this.addPrimitive(0, this.drawable);
        this.layoutChildren();
    }

    protected void checkShape(int shape) {
        switch (shape) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "shape.ex.txt"));
            }
        }
    }

    @Override
    public boolean isForceShowPorts() {
        return this.port.isVisible();
    }

    @Override
    public void setForceShowPorts(boolean b) {
        if (this.isForceShowPorts() == b) {
            return;
        }
        this.port.setVisible(b);
    }

    public PFDPort getPort() {
        return this.port;
    }

    public PFDText getLabel() {
        return this.label;
    }

    @Override
    public int getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        if (this.labelPosition == position) {
            return;
        }
        this.checkLabelPosition(position);
        this.labelPosition = position;
        this.layoutChildren();
    }

    protected void checkLabelPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "label.ex.txt"));
            }
        }
    }

    protected void initialize() {
        this.createDrawable();
        this.label = new PFDText(this.text);
        this.port = new PFDPort();
        this.port.setName("port");
        this.port.setFromLinkSpot(9);
        this.port.setToLinkSpot(9);
        this.port.setValidFromPort(true);
        this.port.setValidToPort(true);
        this.port.setType(0);
        this.addPrimitive(this.drawable);
        this.addPrimitive(this.label);
        this.addPrimitive(this.port);
        this.layoutChildren();
    }

    protected void createDrawable() {
        PFDBrush brush = null;
        PFDPen pen = null;
        if (this.drawable != null) {
            brush = this.drawable.getBrush();
            pen = this.drawable.getPen();
            this.location = this.drawable.getLocation();
            this.size = this.drawable.getSize();
        }
        switch (this.shape) {
            default: {
                this.drawable = new PFDRectangle();
                break;
            }
            case 3: {
                this.drawable = new PFDRoundRectangle();
                break;
            }
            case 5: {
                this.drawable = new PFDEllipse();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.drawable = new PFDPolygon();
            }
        }
        this.drawable.setBBox(this.location, this.size);
        if (brush != null) {
            this.drawable.setBrush(brush);
        }
        if (pen != null) {
            this.drawable.setPen(pen);
        }
    }

    protected void layoutChildren() {
        switch (this.shape) {
            default: {
                break;
            }
            case 6: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createDiamond(new Rectangle(this.location, this.size)));
                break;
            }
            case 7: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createHexagon(new Rectangle(this.location, this.size)));
                break;
            }
            case 8: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createParallelogram(new Rectangle(this.location, this.size)));
                break;
            }
            case 9: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createRightPentagon(new Rectangle(this.location, this.size)));
                break;
            }
            case 10: {
                PFDPolygon poly = (PFDPolygon)this.drawable;
                poly.setVertices(PFDFlowChartShapes.createOctagon(new Rectangle(this.location, this.size)));
            }
        }
        Point p = new Point();
        Rectangle r = this.drawable.getRBBox();
        int iw = 0;
        int ih = 0;
        if (this.icon != null) {
            iw = this.image.getIconWidth();
            ih = this.image.getIconHeight();
            int dx = 0;
            int dy = 0;
            if (r.width > iw + 2 * this.iconPadding && r.height > ih + 2 * this.iconPadding) {
                switch (this.iconPosition) {
                    default: {
                        dx = (r.width - iw) / 2;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 1: {
                        dx = this.iconPadding;
                        dy = this.iconPadding;
                        break;
                    }
                    case 2: {
                        dx = (r.width - iw) / 2;
                        dy = this.iconPadding;
                        break;
                    }
                    case 3: {
                        dx = r.width - this.iconPadding - iw;
                        dy = this.iconPadding;
                        break;
                    }
                    case 8: {
                        dx = this.iconPadding;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 4: {
                        dx = r.width - this.iconPadding - iw;
                        dy = (r.height - ih) / 2;
                        break;
                    }
                    case 7: {
                        dx = this.iconPadding;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                    case 6: {
                        dx = (r.width - iw) / 2;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                    case 5: {
                        dx = r.width - this.iconPadding - iw;
                        dy = r.height - this.iconPadding - ih;
                        break;
                    }
                }
            } else {
                iw = 0;
                ih = 0;
            }
            this.icon.setBBox(r.x + dx, r.y + dy, iw, ih);
        }
        switch (this.labelPosition) {
            default: {
                if (this.label.isHTML()) {
                    this.label.setTruncateLines(true);
                    int wrap = Math.max(0, r.width - this.labelXPadding * 2);
                    int clip = Math.max(0, r.height - this.labelYPadding * 2);
                    this.drawable.getSpotLocation(1, p);
                    this.label.setHorizontalAlignment(1);
                    this.label.setVerticalAlignment(1);
                    this.label.setBBox(p.x + this.labelXPadding, p.y + this.labelYPadding, 0, 0);
                    this.label.setWrapWidth(wrap);
                    this.label.setClipHeight(clip);
                    if (this.icon == null) break;
                    Rectangle iconBBox = this.icon.getBBox();
                    Rectangle clipBBox = new Rectangle(iconBBox.x - this.iconPadding - r.x, iconBBox.y - this.iconPadding - r.y, iconBBox.width + 2 * this.iconPadding, iconBBox.height + 2 * this.iconPadding);
                    if (!iconBBox.isEmpty()) {
                        this.label.setClipRectangle(clipBBox);
                        break;
                    }
                    this.label.setClipRectangle(null);
                    break;
                }
                this.drawable.getSpotLocation(0, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                this.label.setClipHeight(r.height);
                break;
            }
            case 1: {
                this.drawable.getSpotLocation(2, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(2);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 2: {
                this.drawable.getSpotLocation(6, p);
                this.label.setHorizontalAlignment(0);
                this.label.setVerticalAlignment(1);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(2 * r.width);
                break;
            }
            case 3: {
                this.drawable.getSpotLocation(8, p);
                this.label.setHorizontalAlignment(2);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
                break;
            }
            case 4: {
                this.drawable.getSpotLocation(4, p);
                this.label.setHorizontalAlignment(1);
                this.label.setVerticalAlignment(0);
                this.label.setBBox(p.x, p.y, 0, 0);
                this.label.setWrapWidth(r.width);
            }
        }
        this.drawable.getSpotLocation(0, p);
        this.port.setBBox(p.x, p.y, 0, 0);
        switch (this.shape) {
            case 5: {
                this.port.setFreeSpotBox(false);
                break;
            }
            default: {
                this.port.setFreeSpotBox(true);
            }
        }
        this.port.setFreeSpotOffsetX(r.width / 2 + 1);
        this.port.setFreeSpotOffsetY(r.height / 2 + 1);
        this.port.setSnapBox(true);
        this.port.setSnapXDistance(r.width / 2);
        this.port.setSnapYDistance(r.height / 2);
        this.calculateBBox();
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        Rectangle r = this.drawable.getRBBox();
        PFDBrush brush = this.drawable.getBrush();
        if (this.gradientColor) {
            GradientPaint gp = new GradientPaint(new Point(r.x, r.y + r.height / 2), new Color(102, 153, 204), new Point(r.x + r.width, r.y + r.height / 2), Color.white, true);
            brush.setStyle(1);
            brush.paint = gp;
        }
        super.render(g2d, v);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDSimpleShapeNode clone = new PFDSimpleShapeNode(this.drawable.getLocation(), this.drawable.getSize(), this.text);
        super.copyObject(clone);
        clone.setShape(this.getShape());
        clone.setLabelPosition(this.getLabelPosition());
        clone.setForceShowPorts(this.isForceShowPorts());
        clone.setGradientColor(this.isGradientColor());
        this.drawable.copyObject(clone.getDrawable());
        this.label.copyObject(clone.getLabel());
        table.put(this, clone);
        table.put(this.drawable, clone.drawable);
        table.put(this.label, clone.label);
        table.put(this.port, clone.port);
        return clone;
    }

    @Override
    public void setForcedBBox(int x, int y, int w, int h) {
        Rectangle r = this.getRBBox();
        if (r.x == x && r.y == y && r.width == w && r.height == h) {
            return;
        }
        this.location = this.drawable.getLocation();
        this.size = this.drawable.getSize();
        x = Math.max(0, x);
        y = Math.max(0, y);
        Dimension labelSize = this.label != null ? this.label.getSize() : new Dimension(0, 0);
        if (w < labelSize.width && !this.label.isMultiline()) {
            return;
        }
        if (h < labelSize.height) {
            return;
        }
        this.location.x += x - r.x;
        this.location.y += y - r.y;
        this.size.width += w - r.width;
        this.size.height += h - r.height;
        this.drawable.setBBox(this.location, this.size);
        this.layoutChildren();
        this.firePropertyChange("bbox");
    }

    @Override
    public PFDPort getPort(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "port.ex.txt"));
        }
        if (name.equals(this.port.getName())) {
            return this.port;
        }
        return null;
    }

    @Override
    public void addPort(String name, int position) {
    }

    @Override
    public void removePort(String name) {
    }

    @Override
    public Point getCenterLocation() {
        return this.getSpotLocation(0, null);
    }

    @Override
    public void setCenterLocation(Point p) {
        this.setLocation(p.x - this.bbox.width / 2, p.y - this.bbox.height / 2);
    }

    @Override
    public PFDPort getInputPort() {
        return this.port;
    }

    @Override
    public PFDPort getOutputPort() {
        return this.port;
    }

    @Override
    protected Vector getParents() {
        Vector<NodeLayoutInterface> pv = new Vector<NodeLayoutInterface>();
        Vector inLinks = this.port.getToLinks();
        for (int j = 0; j < inLinks.size(); ++j) {
            PFDLink l = (PFDLink)inLinks.elementAt(j);
            if (l.getFromNode() == null || pv.contains(l.getFromNode())) continue;
            pv.addElement(l.getFromNode());
        }
        return pv;
    }

    @Override
    protected Vector getChildren() {
        Vector<NodeLayoutInterface> cv = new Vector<NodeLayoutInterface>();
        Vector outLinks = this.port.getFromLinks();
        for (int j = 0; j < outLinks.size(); ++j) {
            PFDLink l = (PFDLink)outLinks.elementAt(j);
            if (l.getToNode() == null || cv.contains(l.getToNode())) continue;
            cv.addElement(l.getToNode());
        }
        return cv;
    }

    public PFDImage getIcon() {
        return this.icon;
    }

    public void setIconImage(ImageIcon image) {
        this.image = image;
        if (this.icon == null) {
            this.icon = new PFDImage(image.getImage());
            this.addPrimitive(this.icon);
        } else {
            this.icon.setImage(image.getImage());
        }
        this.layoutChildren();
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(int position) {
        if (this.iconPosition == position) {
            return;
        }
        this.checkIconPosition(position);
        this.iconPosition = position;
        this.layoutChildren();
    }

    public void setIconPadding(int padding) {
        if (this.iconPadding == padding) {
            return;
        }
        this.iconPadding = padding;
        this.layoutChildren();
    }

    public int getIconPadding() {
        return this.iconPadding;
    }

    protected void checkIconPosition(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "icon.ex.txt"));
            }
        }
    }
}

