/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrushCustomizerPanel;
import com.sas.graphics.components.pfd.PFDPenCustomizerPanel;
import com.sas.graphics.components.pfd.PFDSimpleNode;
import com.sas.graphics.components.pfd.PFDTextCustomizerPanel;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class PFDSimpleNodePropertyDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String RB_KEY = "PFDSimpleNodePropertyDialog.";
    PFDSimpleNode node;
    PFDView view;
    JCheckBox port;
    JButton closeButton;

    public PFDSimpleNodePropertyDialog(Frame aFrame, String title, PFDSimpleNode node, PFDView viewer) {
        super(aFrame, true);
        this.setResizable(false);
        this.node = node;
        this.view = viewer;
        this.setTitle(title);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(new PFDTextCustomizerPanel(node.getLabel()));
        contentPane.add(new PFDPenCustomizerPanel(node.getEllipse().getPen()));
        contentPane.add(new PFDBrushCustomizerPanel(node.getEllipse().getBrush()));
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 0));
        this.port = new JCheckBox(RB.getStringResource(RB_KEY, "port.txt"));
        this.port.addActionListener(this);
        portPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        portPanel.add(this.port);
        portPanel.add(Box.createHorizontalGlue());
        contentPane.add(portPanel);
        JPanel closePanel = new JPanel();
        closePanel.setLayout(new BoxLayout(closePanel, 0));
        this.closeButton = new JButton(RB.getStringResource(RB_KEY, "close.txt"));
        closePanel.add(Box.createHorizontalGlue());
        closePanel.add(this.closeButton);
        contentPane.add(closePanel);
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contentPane);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.port.setSelected(this.node.isForceShowPorts());
        this.node.getEllipse().getPen().addPropertyChangeListener(this);
        this.node.getEllipse().getBrush().addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.port) {
            this.node.setForceShowPorts(this.port.isSelected());
        } else if (source == this.closeButton) {
            this.node.getEllipse().getPen().removePropertyChangeListener(this);
            this.node.getEllipse().getBrush().removePropertyChangeListener(this);
            this.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.node.getEllipse().getBrush() || e.getSource() == this.node.getEllipse().getPen()) {
            this.view.repaint();
        }
    }
}

