/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDSimpleShapeNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class PFDSelfLink
extends PFDLink {
    private static final long serialVersionUID = 138448744004509840L;
    protected int relativeLocation;
    protected Point arcLocation;
    protected Point firstElbowPoint;
    protected Point lastElbowPoint;

    public PFDSelfLink(PFDPort self, int relativeLocation) {
        super(self, self);
        this.relativeLocation = relativeLocation;
        this.firstElbowPoint = new Point();
        this.lastElbowPoint = new Point();
        this.elbowPoints.add(this.firstElbowPoint);
        this.elbowPoints.add(this.lastElbowPoint);
        this.layoutAffected = true;
        this.setSelectable(false);
        this.arcLocation = null;
    }

    public void setRelativeLocation(int relativeLocation, boolean update) {
        this.relativeLocation = relativeLocation;
        if (update) {
            this.arcLocation = null;
            this.linkChanged();
            this.labelChanged();
            this.calculateBBox();
        }
    }

    public void setRelativeLocation(int relativeLocation) {
        this.setRelativeLocation(relativeLocation, false);
    }

    public int getRelativeLocation() {
        return this.relativeLocation;
    }

    @Override
    protected void linkChanged() {
        if (this.fromPort == null && this.toPort == null || this.arcLocation != null) {
            return;
        }
        this.points.removeAllElements();
        this.elbowPoints.removeAllElements();
        this.segments.removeAllElements();
        PFDAbstractNode node = this.fromPort.getParentNode();
        if (node == null) {
            return;
        }
        int arcRadius = this.getArcRadius();
        Arc2D.Double arc = null;
        double slope = 0.0;
        Rectangle2D bounds = null;
        if (node instanceof PFDSimpleShapeNode && ((PFDSimpleShapeNode)node).getShape() == 5) {
            Area ellipseArea = new Area(new Ellipse2D.Double(node.getX(), node.getY(), node.getWidth(), node.getHeight()));
            Area arcArea = null;
            double possibleNaN = Double.NaN;
            double theta = Math.acos(1.0 - Math.pow(1.5 * (double)this.arrowLength, 2.0) / (2.0 * Math.pow(arcRadius, 2.0)));
            int offset = (int)((double)arcRadius * Math.cos(theta));
            switch (this.relativeLocation) {
                case 2: {
                    this.arcLocation = node.getSpotLocation(2, null);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.x = (int)bounds.getMinX();
                    possibleNaN = Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.x - bounds.getMinX(), 2.0));
                    this.toPoint.y = (int)((double)this.arcLocation.y + (!Double.isNaN(possibleNaN) ? possibleNaN : 0.0));
                    this.fromPoint.x = (int)bounds.getMaxX();
                    this.fromPoint.y = this.toPoint.y;
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x - offset;
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                    } else {
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                        this.lastElbowPoint.x = (int)(0.75 * (double)this.arrowLength + ((double)this.lastElbowPoint.y + (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y)) * -slope);
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x + offset;
                        this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                        break;
                    }
                    this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.firstElbowPoint.x = (int)(-0.75 * (double)this.arrowLength + 3.0 + ((double)this.firstElbowPoint.y + (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y)) * -slope);
                    break;
                }
                case 6: {
                    this.arcLocation = node.getSpotLocation(6, null);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.x = (int)bounds.getMaxX();
                    possibleNaN = Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.x - bounds.getMinX(), 2.0));
                    this.toPoint.y = (int)((double)this.arcLocation.y - (!Double.isNaN(possibleNaN) ? possibleNaN : 0.0));
                    this.fromPoint.x = (int)bounds.getMinX();
                    this.fromPoint.y = this.toPoint.y;
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x + offset;
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    } else {
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                        this.lastElbowPoint.x = (int)(-0.75 * (double)this.arrowLength + 3.0 + ((double)this.lastElbowPoint.y + (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y)) * -slope);
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x - offset;
                        this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                        break;
                    }
                    this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.firstElbowPoint.x = (int)(0.75 * (double)this.arrowLength + ((double)this.firstElbowPoint.y + (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y)) * -slope);
                    break;
                }
                case 8: {
                    this.arcLocation = node.getSpotLocation(8, null);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.y = (int)bounds.getMaxY();
                    possibleNaN = Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.y - bounds.getMinY(), 2.0));
                    this.toPoint.x = (int)((double)this.arcLocation.x + (!Double.isNaN(possibleNaN) ? possibleNaN : 0.0));
                    this.fromPoint.y = (int)bounds.getMinY();
                    this.fromPoint.x = this.toPoint.x;
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    this.lastElbowPoint.x = this.arcLocation.x - arcRadius;
                    this.lastElbowPoint.y = (int)(-0.75 * (double)this.arrowLength - 1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    this.firstElbowPoint.x = this.lastElbowPoint.x;
                    this.firstElbowPoint.y = (int)(0.75 * (double)this.arrowLength - 1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    break;
                }
                case 4: {
                    this.arcLocation = node.getSpotLocation(4, null);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.y = (int)bounds.getMinY();
                    possibleNaN = Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.y - bounds.getMinY(), 2.0));
                    this.toPoint.x = (int)((double)this.arcLocation.x - (!Double.isNaN(possibleNaN) ? possibleNaN : 0.0));
                    this.fromPoint.y = (int)bounds.getMaxY();
                    this.fromPoint.x = this.toPoint.x;
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    this.lastElbowPoint.x = this.arcLocation.x + arcRadius;
                    this.lastElbowPoint.y = (int)(0.75 * (double)this.arrowLength + 3.0 - 1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    this.firstElbowPoint.x = this.arcLocation.x + arcRadius;
                    this.firstElbowPoint.y = (int)(-0.75 * (double)this.arrowLength - 1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    break;
                }
                case 1: {
                    Point spotLocation = node.getSpotLocation(1, null);
                    this.arcLocation = new Point(spotLocation);
                    this.toPort.getLinkPointFromPoint(spotLocation, this.arcLocation);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.x = (int)bounds.getMinX();
                    this.toPoint.y = (int)((double)this.arcLocation.y + Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.x - bounds.getMinX(), 2.0)));
                    this.fromPoint.y = (int)bounds.getMinY();
                    this.fromPoint.x = (int)((double)this.arcLocation.x + Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow((double)this.arcLocation.y - bounds.getMinY(), 2.0)));
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x - arcRadius;
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                    } else {
                        this.lastElbowPoint.x = this.arcLocation.x - arcRadius - arcRadius;
                        this.lastElbowPoint.y = (int)(-1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                        this.lastElbowPoint.x += 10;
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    this.firstElbowPoint.x = this.arcLocation.x;
                    this.firstElbowPoint.y = (int)(-1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    this.firstElbowPoint.x -= 10;
                    break;
                }
                case 7: {
                    Point spotLocation = node.getSpotLocation(7, null);
                    this.arcLocation = new Point(spotLocation);
                    this.toPort.getLinkPointFromPoint(spotLocation, this.arcLocation);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.y = (int)Math.ceil(bounds.getMaxY());
                    this.toPoint.x = (int)Math.ceil((double)this.arcLocation.x + Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.y - this.toPoint.y, 2.0)));
                    this.fromPoint.x = (int)Math.floor(bounds.getMinX());
                    this.fromPoint.y = (int)Math.floor((double)this.arcLocation.y - Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.x - this.fromPoint.x, 2.0)));
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x + arcRadius;
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    } else {
                        this.lastElbowPoint.x = this.arcLocation.x;
                        this.lastElbowPoint.y = (int)(-1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                        this.lastElbowPoint.x -= 10;
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x - arcRadius;
                        this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                        break;
                    }
                    this.firstElbowPoint.x = this.arcLocation.x - arcRadius - arcRadius;
                    this.firstElbowPoint.y = (int)(-1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    this.firstElbowPoint.x += 10;
                    break;
                }
                case 3: {
                    Point spotLocation = node.getSpotLocation(3, null);
                    this.arcLocation = new Point(spotLocation);
                    this.toPort.getLinkPointFromPoint(spotLocation, this.arcLocation);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.y = (int)bounds.getMinY();
                    this.toPoint.x = (int)((double)this.arcLocation.x - Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.y - this.toPoint.y, 2.0)));
                    this.fromPoint.x = (int)bounds.getMaxX();
                    this.fromPoint.y = (int)((double)this.arcLocation.y + Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.x - this.fromPoint.x, 2.0)));
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x - arcRadius;
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                    } else {
                        this.lastElbowPoint.x = this.arcLocation.x;
                        this.lastElbowPoint.y = (int)(-1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                        this.lastElbowPoint.x += 10;
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x + arcRadius;
                        this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                        break;
                    }
                    this.firstElbowPoint.x = this.arcLocation.x + arcRadius + arcRadius;
                    this.firstElbowPoint.y = (int)(-1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    this.firstElbowPoint.x -= 10;
                    break;
                }
                case 5: {
                    Point spotLocation = node.getSpotLocation(5, null);
                    this.arcLocation = new Point(spotLocation);
                    this.toPort.getLinkPointFromPoint(spotLocation, this.arcLocation);
                    arcArea = new Area(new Ellipse2D.Double(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius));
                    ellipseArea.intersect(arcArea);
                    bounds = ellipseArea.getBounds2D();
                    this.toPoint.x = (int)bounds.getMaxX();
                    this.toPoint.y = (int)((double)this.arcLocation.y - Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.x - this.toPoint.x, 2.0)));
                    this.fromPoint.y = (int)bounds.getMaxY();
                    this.fromPoint.x = (int)((double)this.arcLocation.x - Math.sqrt(Math.pow(arcRadius, 2.0) - Math.pow(this.arcLocation.y - this.fromPoint.y, 2.0)));
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x + arcRadius;
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    } else {
                        this.lastElbowPoint.x = this.arcLocation.x + 2 * arcRadius;
                        this.lastElbowPoint.y = (int)(-1.0 / slope * (double)this.lastElbowPoint.x - (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y));
                        this.lastElbowPoint.x -= 10;
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x - arcRadius;
                        this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                        break;
                    }
                    this.firstElbowPoint.x = this.arcLocation.x;
                    this.firstElbowPoint.y = (int)(-1.0 / slope * (double)this.firstElbowPoint.x - (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y));
                    this.firstElbowPoint.x += 10;
                }
            }
        } else if (node instanceof PFDSimpleShapeNode && ((PFDSimpleShapeNode)node).getShape() == 4) {
            double theta = Math.acos(1.0 - Math.pow(1.5 * (double)this.arrowLength, 2.0) / (2.0 * Math.pow(arcRadius, 2.0)));
            int offset = (int)((double)arcRadius * Math.cos(theta));
            Point topCenter = node.getSpotLocation(2, null);
            Point bottomLeft = node.getSpotLocation(7, null);
            double triangleTheta = Math.atan(((double)topCenter.y - (double)bottomLeft.y) / ((double)topCenter.x - (double)bottomLeft.x));
            switch (this.relativeLocation) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    this.arcLocation = node.getSpotLocation(2, null);
                    this.toPoint.x = (int)((double)this.arcLocation.x - (double)arcRadius * Math.cos(triangleTheta));
                    this.toPoint.y = (int)((double)this.arcLocation.y - (double)arcRadius * Math.sin(triangleTheta));
                    this.fromPoint.x = (int)((double)this.arcLocation.x + (double)arcRadius * Math.cos(triangleTheta));
                    this.fromPoint.y = this.toPoint.y;
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x + offset;
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    } else {
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                        this.lastElbowPoint.x = (int)(0.75 * (double)this.arrowLength + ((double)this.lastElbowPoint.y + (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y)) * -slope);
                    }
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x - offset;
                        this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                        break;
                    }
                    this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.firstElbowPoint.x = (int)(-0.75 * (double)this.arrowLength + ((double)this.firstElbowPoint.y + (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y)) * -slope);
                    break;
                }
                case 6: {
                    this.arcLocation = node.getSpotLocation(6, null);
                    this.lastElbowPoint.x = this.arcLocation.x + offset;
                    this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.toPoint.x = this.arcLocation.x + arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.firstElbowPoint.x = this.arcLocation.x - offset;
                    this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.fromPoint.x = this.arcLocation.x - arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                    break;
                }
                case 7: {
                    this.arcLocation = node.getSpotLocation(7, null);
                    this.lastElbowPoint.x = this.arcLocation.x + offset;
                    this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.toPoint.x = this.arcLocation.x + arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.fromPoint.x = (int)((double)this.arcLocation.x + (double)arcRadius * Math.cos(triangleTheta));
                    this.fromPoint.y = (int)((double)this.arcLocation.y + (double)arcRadius * Math.sin(triangleTheta));
                    slope = (double)(this.fromPoint.y - this.arcLocation.y) / (double)(this.fromPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.firstElbowPoint.x = this.arcLocation.x - offset;
                        this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                        break;
                    }
                    this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.firstElbowPoint.x = (int)(-0.75 * (double)this.arrowLength + ((double)this.firstElbowPoint.y + (-1.0 / slope * (double)this.fromPoint.x - (double)this.fromPoint.y)) * -slope);
                    break;
                }
                case 5: {
                    this.arcLocation = node.getSpotLocation(5, null);
                    this.toPoint.x = (int)((double)this.arcLocation.x - (double)arcRadius * Math.cos(triangleTheta));
                    this.toPoint.y = (int)((double)this.arcLocation.y + (double)arcRadius * Math.sin(triangleTheta));
                    slope = (double)(this.toPoint.y - this.arcLocation.y) / (double)(this.toPoint.x - this.arcLocation.x);
                    if (slope == 0.0) {
                        this.lastElbowPoint.x = this.arcLocation.x + offset;
                        this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    } else {
                        this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                        this.lastElbowPoint.x = (int)(0.75 * (double)this.arrowLength + ((double)this.lastElbowPoint.y + (-1.0 / slope * (double)this.toPoint.x - (double)this.toPoint.y)) * -slope);
                    }
                    this.firstElbowPoint.x = this.arcLocation.x - offset;
                    this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.fromPoint.x = this.arcLocation.x - arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                }
            }
        } else {
            double theta = Math.acos(1.0 - Math.pow(1.5 * (double)this.arrowLength, 2.0) / (2.0 * Math.pow(arcRadius, 2.0)));
            int offset = (int)((double)arcRadius * Math.cos(theta));
            switch (this.relativeLocation) {
                case 2: {
                    this.arcLocation = node.getSpotLocation(2, null);
                    this.lastElbowPoint.x = this.arcLocation.x - offset;
                    this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.toPoint.x = this.arcLocation.x - arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.firstElbowPoint.x = this.arcLocation.x + offset;
                    this.firstElbowPoint.y = this.lastElbowPoint.y;
                    this.fromPoint.x = this.arcLocation.x + arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                    break;
                }
                case 6: {
                    this.arcLocation = node.getSpotLocation(6, null);
                    this.lastElbowPoint.x = this.arcLocation.x + offset;
                    this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.toPoint.x = this.arcLocation.x + arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.firstElbowPoint.x = this.arcLocation.x - offset;
                    this.firstElbowPoint.y = this.lastElbowPoint.y;
                    this.fromPoint.x = this.arcLocation.x - arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                    break;
                }
                case 8: {
                    this.arcLocation = node.getSpotLocation(8, null);
                    this.lastElbowPoint.x = this.arcLocation.x - arcRadius;
                    this.lastElbowPoint.y = this.arcLocation.y + offset;
                    this.toPoint.x = this.arcLocation.x;
                    this.toPoint.y = this.arcLocation.y + arcRadius;
                    this.firstElbowPoint.x = this.arcLocation.x - arcRadius;
                    this.firstElbowPoint.y = this.arcLocation.y - offset;
                    this.fromPoint.x = this.arcLocation.x;
                    this.fromPoint.y = this.arcLocation.y - arcRadius;
                    break;
                }
                case 4: {
                    this.arcLocation = node.getSpotLocation(4, null);
                    this.lastElbowPoint.x = this.arcLocation.x + arcRadius;
                    this.lastElbowPoint.y = this.arcLocation.y - offset;
                    this.toPoint.x = this.arcLocation.x;
                    this.toPoint.y = this.arcLocation.y - arcRadius;
                    this.firstElbowPoint.x = this.lastElbowPoint.x;
                    this.firstElbowPoint.y = this.arcLocation.y + offset;
                    this.fromPoint.x = this.arcLocation.x;
                    this.fromPoint.y = this.arcLocation.y + arcRadius;
                    break;
                }
                case 1: {
                    this.arcLocation = node.getSpotLocation(1, null);
                    this.lastElbowPoint.x = this.arcLocation.x - arcRadius;
                    this.lastElbowPoint.y = this.arcLocation.y + offset;
                    this.toPoint.x = this.arcLocation.x;
                    this.toPoint.y = this.arcLocation.y + arcRadius;
                    this.firstElbowPoint.x = this.arcLocation.x + offset;
                    this.firstElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.fromPoint.x = this.arcLocation.x + arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                    break;
                }
                case 7: {
                    this.arcLocation = node.getSpotLocation(7, null);
                    this.lastElbowPoint.x = this.arcLocation.x + offset;
                    this.lastElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.toPoint.x = this.arcLocation.x + arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.firstElbowPoint.x = this.arcLocation.x - arcRadius;
                    this.firstElbowPoint.y = this.arcLocation.y - offset;
                    this.fromPoint.x = this.arcLocation.x;
                    this.fromPoint.y = this.arcLocation.y - arcRadius;
                    break;
                }
                case 3: {
                    this.arcLocation = node.getSpotLocation(3, null);
                    this.lastElbowPoint.x = this.arcLocation.x - offset;
                    this.lastElbowPoint.y = this.arcLocation.y - arcRadius;
                    this.toPoint.x = this.arcLocation.x - arcRadius;
                    this.toPoint.y = this.arcLocation.y;
                    this.firstElbowPoint.x = this.arcLocation.x + arcRadius;
                    this.firstElbowPoint.y = this.arcLocation.y + offset;
                    this.fromPoint.x = this.arcLocation.x;
                    this.fromPoint.y = this.arcLocation.y + arcRadius;
                    break;
                }
                case 5: {
                    this.arcLocation = node.getSpotLocation(5, null);
                    this.lastElbowPoint.x = this.arcLocation.x + arcRadius;
                    this.lastElbowPoint.y = this.arcLocation.y - offset;
                    this.toPoint.x = this.arcLocation.x;
                    this.toPoint.y = this.arcLocation.y - arcRadius;
                    this.firstElbowPoint.x = this.arcLocation.x - offset;
                    this.firstElbowPoint.y = this.arcLocation.y + arcRadius;
                    this.fromPoint.x = this.arcLocation.x - arcRadius;
                    this.fromPoint.y = this.arcLocation.y;
                }
            }
        }
        if (this.arcLocation == null) {
            return;
        }
        this.points.addElement(this.fromPoint);
        this.points.addElement(this.toPoint);
        this.elbowPoints.add(this.firstElbowPoint);
        this.elbowPoints.add(this.lastElbowPoint);
        arc = new Arc2D.Double();
        arc.setFrameFromCenter(this.arcLocation, new Point(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius));
        arc.setAngles(this.fromPoint, this.toPoint);
        arc.setArcType(0);
        this.segments.addElement(arc);
    }

    @Override
    protected void labelChanged() {
        super.labelChanged();
        if (this.middleLabel == null) {
            return;
        }
        PFDModel m = this.getModel();
        if (m == null || this.arcLocation == null) {
            return;
        }
        this.middleLabel.disableChangeUpdate();
        this.middleLabel.setHorizontalAlignment(0);
        this.middleLabel.setVerticalAlignment(0);
        this.middleLabel.enableChangeUpdate();
        int arcRadius = this.getArcRadius();
        int posY = 0;
        int posX = 0;
        switch (this.relativeLocation) {
            case 2: {
                posY = this.arcLocation.y - arcRadius;
                if (this.middleLabelPosition != 0) {
                    Rectangle label_bbox = this.middleLabel.getBBox();
                    posY -= label_bbox.height / 2;
                }
                this.middleLabel.setBBox(this.arcLocation.x, posY, 0, 0);
                break;
            }
            case 6: {
                posY = this.arcLocation.y + arcRadius;
                if (this.middleLabelPosition != 0) {
                    Rectangle label_bbox = this.middleLabel.getBBox();
                    posY += label_bbox.height / 2;
                }
                this.middleLabel.setBBox(this.arcLocation.x, posY, 0, 0);
                break;
            }
            case 8: {
                posX = this.arcLocation.x - arcRadius;
                if (this.middleLabelPosition != 0) {
                    Rectangle label_bbox = this.middleLabel.getBBox();
                    posX -= label_bbox.width / 2;
                }
                this.middleLabel.setBBox(posX, this.arcLocation.y, 0, 0);
                break;
            }
            case 4: {
                posX = this.arcLocation.x + arcRadius;
                if (this.middleLabelPosition != 0) {
                    Rectangle label_bbox = this.middleLabel.getBBox();
                    posX += label_bbox.width / 2;
                }
                this.middleLabel.setBBox(posX, this.arcLocation.y, 0, 0);
                break;
            }
            case 1: {
                this.middleLabel.setBBox((int)Math.rint((double)this.arcLocation.x - (double)arcRadius * Math.cos(0.7853981633974483)), (int)Math.rint((double)this.arcLocation.y - (double)arcRadius * Math.cos(0.7853981633974483)), 0, 0);
                break;
            }
            case 3: {
                this.middleLabel.setBBox((int)Math.rint((double)this.arcLocation.x + (double)arcRadius * Math.cos(0.7853981633974483)), (int)Math.rint((double)this.arcLocation.y - (double)arcRadius * Math.cos(0.7853981633974483)), 0, 0);
                break;
            }
            case 7: {
                this.middleLabel.setBBox((int)Math.rint((double)this.arcLocation.x - (double)arcRadius * Math.cos(0.7853981633974483)), (int)Math.rint((double)this.arcLocation.y + (double)arcRadius * Math.cos(0.7853981633974483)), 0, 0);
                break;
            }
            case 5: {
                this.middleLabel.setBBox((int)Math.rint((double)this.arcLocation.x + (double)arcRadius * Math.cos(0.7853981633974483)), (int)Math.rint((double)this.arcLocation.y + (double)arcRadius * Math.cos(0.7853981633974483)), 0, 0);
            }
        }
        if (!m.containsPrimitive(this.middleLabel)) {
            m.addPrimitive(this.middleLabel);
        }
    }

    protected int getArcRadius() {
        PFDAbstractNode node = this.fromPort.getParentNode();
        if (node == null) {
            return 0;
        }
        return Math.max(Math.min(node.getWidth(), node.getHeight()), 52) / 4;
    }

    @Override
    public boolean isLinkSupported(PFDPort from, PFDPort to) {
        if (!super.isLinkSupported(from, to)) {
            return from == to;
        }
        return true;
    }

    @Override
    protected void calculateBBox() {
        if (this.fromPort == null || this.toPort == null || this.arcLocation == null) {
            return;
        }
        int arcRadius = this.getArcRadius();
        this.setBBox(this.arcLocation.x - arcRadius, this.arcLocation.y - arcRadius, 2 * arcRadius, 2 * arcRadius);
        this.updateVisualBBox();
    }

    @Override
    public void move(int dx, int dy) {
        Arc2D.Double arc = (Arc2D.Double)this.segments.get(0);
        arc.setFrame(arc.x + (double)dx, arc.y + (double)dy, arc.width, arc.height);
        this.firstElbowPoint.setLocation(this.firstElbowPoint.x + dx, this.firstElbowPoint.y + dy);
        this.lastElbowPoint.setLocation(this.lastElbowPoint.x + dx, this.lastElbowPoint.y + dy);
        this.fromPoint.setLocation(this.fromPoint.x + dx, this.fromPoint.y + dy);
        this.toPoint.setLocation(this.toPoint.x + dx, this.toPoint.y + dy);
        this.arrowChanged();
        this.arcLocation.x += dx;
        this.arcLocation.y += dy;
        this.labelChanged();
    }
}

