/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAnnotateComponent;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDModelListener;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import com.sas.graphics.components.pfd.interfaces.PFDAnnotateInterface;
import com.sas.graphics.components.pfd.interfaces.PFDUniqueItemInterface;
import com.sas.graphics.components.pfd.ui.PFDControlToolBar;
import com.sas.graphics.data.TemporarySourceInterface;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.OverlayLayout;

public class PFDScrollView
extends JComponent
implements AdjustmentListener,
PFDViewListener,
PFDModelListener,
PropertyChangeListener,
MouseWheelListener,
SourceInterface,
TemporarySourceInterface,
PropertyInterface,
PFDUniqueItemInterface {
    private static final long serialVersionUID = -4385990488732994534L;
    protected PFDView view;
    protected JScrollBar vScrollBar = new JScrollBar(1);
    protected JScrollBar hScrollBar = new JScrollBar(0);
    protected boolean autoScrollOn = false;
    protected PFDControlToolBar pfdControls;
    protected JPanel hScrollPadding;
    protected JPanel cornerPadding;
    protected boolean doViewUpdate = true;
    private static final Integer ANNOTATE_LAYER = new Integer(JLayeredPane.DEFAULT_LAYER + 10);
    private static final Integer OVERVIEW_LAYER = new Integer(JLayeredPane.DEFAULT_LAYER + 20);

    public PFDScrollView() {
        this(new PFDView());
    }

    public PFDScrollView(PFDView v) {
        this.view = v;
        this.view.setAutoscrolls(true);
        this.view.addPFDViewListener(this);
        this.view.addPropertyChangeListener(this);
        this.view.getModel().addPFDModelListener(this);
        this.pfdControls = this.view.getToolBar();
        this.hScrollPadding = new JPanel();
        this.cornerPadding = new JPanel();
        this.cornerPadding.setPreferredSize(new Dimension(this.vScrollBar.getPreferredSize().width, this.hScrollBar.getPreferredSize().height));
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel hscrollPanel = new JPanel(new BorderLayout());
        hscrollPanel.add((Component)this.hScrollBar, "North");
        hscrollPanel.add((Component)this.hScrollPadding, "Center");
        JPanel bottomEast = new JPanel(new BorderLayout());
        bottomEast.add((Component)this.pfdControls, "Center");
        bottomEast.add((Component)this.cornerPadding, "East");
        bottom.add((Component)hscrollPanel, "Center");
        bottom.add((Component)bottomEast, "East");
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setLayout(new OverlayLayout(layeredPane));
        layeredPane.add((Component)this.view, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.view.getOverviewPanel(), OVERVIEW_LAYER);
        PFDAnnotateComponent annotate = this.view.getAnnotateComponent();
        if (annotate != null) {
            layeredPane.add((Component)annotate, ANNOTATE_LAYER);
            annotate.setAutoscrolls(true);
            annotate.getPFDAnnotate().addPropertyChangeListener(this);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)layeredPane, "Center");
        this.add((Component)this.vScrollBar, "East");
        this.add((Component)bottom, "South");
        this.hScrollBar.addAdjustmentListener(this);
        this.vScrollBar.addAdjustmentListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Dimension controlSize = this.pfdControls.getPreferredSize();
        Dimension scrollSize = this.hScrollBar.getPreferredSize();
        Action toolBarAction = this.view.getAction("ACTION_TOGGLE_TOOLBAR");
        if (controlSize.width + scrollSize.width > width) {
            toolBarAction.setEnabled(false);
            this.setToolbarVisible(false);
        } else {
            toolBarAction.setEnabled(true);
            Boolean b = (Boolean)toolBarAction.getValue("pfdAbstractAction.selected");
            this.setToolbarVisible(b == null ? false : b);
        }
        this.hScrollPadding.setVisible(this.pfdControls.isVisible());
    }

    protected void setToolbarVisible(boolean b) {
        if (GraphicsEnvironment.isHeadless()) {
            this.pfdControls.setVisible(false);
        } else {
            this.pfdControls.setVisible(b);
        }
    }

    public LayoutStrategyInterface getPFDLayout() {
        return this.view.getPFDLayout();
    }

    public void setPFDLayout(LayoutStrategyInterface layout) {
        this.view.setPFDLayout(layout);
    }

    public void doPFDLayout(boolean b) {
        this.view.doPFDLayout(b);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar sb = (JScrollBar)e.getAdjustable();
        Point p = this.view.getViewPosition();
        if (sb.getOrientation() == 1) {
            p.y = sb.getValue();
        } else {
            p.x = sb.getValue();
        }
        this.view.setViewPosition(p);
    }

    @Override
    public void modelChanged(PFDModelEvent e) {
        if (this.autoScrollOn && e.getType() == 7 && e.getProperty().equals("bbox")) {
            this.autoscroll();
        }
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        int type = e.getType();
        Object source = e.getSource();
        if (!this.doViewUpdate) {
            return;
        }
        if (source instanceof PFDView && ((PFDView)source).getAutoscrolls()) {
            if (type == 1) {
                this.autoScrollOn = true;
                return;
            }
            if (type == 2) {
                this.autoScrollOn = false;
                return;
            }
        }
        switch (type) {
            case 0: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                if (this.view.getCurrentXfm() == null) {
                    return;
                }
                this.initScrollBars();
                break;
            }
            case 11: {
                this.autoscroll();
                break;
            }
        }
    }

    private void autoscroll() {
        Rectangle vr = this.view.getViewRect();
        Point position = this.view.getViewScrollPosition();
        if (vr.x != position.x || vr.y != position.y) {
            this.initScrollBars();
            this.hScrollBar.setValue(position.x);
            this.vScrollBar.setValue(position.y);
            this.view.setFastRenderEnabled(false);
            this.view.resetRenderMode();
            this.view.setViewPosition(position);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof PFDView) {
            if (e.getPropertyName().equals("model")) {
                this.view.getModel().addPFDModelListener(this);
            }
        } else if (e.getSource() instanceof PFDAnnotateInterface && e.getPropertyName().equals("annotateBounds")) {
            this.initScrollBars();
        }
    }

    private void initScrollBars() {
        boolean needsValidate = false;
        this.hScrollBar.removeAdjustmentListener(this);
        this.vScrollBar.removeAdjustmentListener(this);
        Dimension docSize = this.view.getDocumentSize();
        Point p = this.view.getViewPosition();
        Dimension vs = this.view.getViewSize();
        if (vs.width >= docSize.width) {
            if (this.hScrollBar.isEnabled()) {
                p.x = 0;
                this.doViewUpdate = false;
                this.view.setViewPosition(p);
                this.doViewUpdate = true;
            }
            this.setHorizontalFull();
            this.hScrollBar.setEnabled(false);
        } else {
            this.hScrollBar.setEnabled(true);
            this.hScrollBar.setMinimum(0);
            this.hScrollBar.setMaximum(docSize.width);
            this.hScrollBar.setVisibleAmount(vs.width);
            this.hScrollBar.setBlockIncrement(vs.width);
            this.hScrollBar.setUnitIncrement(this.view.getGridSpaceX());
            this.hScrollBar.setValue(p.x);
        }
        if (vs.height >= docSize.height) {
            if (this.vScrollBar.isVisible()) {
                p.y = 0;
                this.doViewUpdate = false;
                this.view.setViewPosition(p);
                this.doViewUpdate = true;
            }
            this.setVerticalFull();
            this.vScrollBar.setEnabled(false);
        } else {
            this.vScrollBar.setEnabled(true);
            this.vScrollBar.setMinimum(0);
            this.vScrollBar.setMaximum(docSize.height);
            this.vScrollBar.setVisibleAmount(vs.height);
            this.vScrollBar.setBlockIncrement(vs.height);
            this.vScrollBar.setUnitIncrement(this.view.getGridSpaceY());
            this.vScrollBar.setValue(p.y);
        }
        this.hScrollBar.addAdjustmentListener(this);
        this.vScrollBar.addAdjustmentListener(this);
        if (needsValidate) {
            this.invalidate();
            this.validate();
        }
    }

    private void setHorizontalFull() {
        this.hScrollBar.setValue(this.hScrollBar.getMinimum());
        this.hScrollBar.setVisibleAmount(this.hScrollBar.getMaximum() - this.hScrollBar.getMinimum());
    }

    private void setVerticalFull() {
        this.vScrollBar.setValue(this.vScrollBar.getMinimum());
        this.vScrollBar.setVisibleAmount(this.vScrollBar.getMaximum() - this.vScrollBar.getMinimum());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrollAmmount = 0;
        scrollAmmount = e.getScrollType() == 0 ? e.getUnitsToScroll() * this.vScrollBar.getUnitIncrement() : e.getWheelRotation() * this.vScrollBar.getBlockIncrement();
        this.vScrollBar.setValue(this.vScrollBar.getValue() + scrollAmmount);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        return this.view.applyPropertyChanges(source);
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.view.cancelPropertyChanges(source);
    }

    public int getNumberPendingProperties() {
        return this.view.getNumberPendingProperties();
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.view.getPendingChanges(source);
    }

    public Object getPropertyValue(int id) {
        switch (id) {
            case 3: {
                return this.view.isOverviewVisible();
            }
            case 2: {
                return this.view.controlToolBar.isVisible();
            }
        }
        return this.view.getPropertyValue(id);
    }

    public boolean hasUserSetValue(int id) {
        return this.view.hasUserSetValue(id);
    }

    public boolean isPropertyPending(int id) {
        return this.view.isPropertyPending(id);
    }

    public boolean isPropertySupported(int id) {
        return this.view.isPropertySupported(id);
    }

    public boolean setPropertyValue(int id, Object value) {
        return this.view.setPropertyValue(id, value);
    }

    protected void applyChange(int key, Object value) {
        this.view.applyChange(key, value);
    }

    public Object[] getDataIds() {
        return this.view.getDataIds();
    }

    public Object getDataSource() {
        return this.view.getDataSource();
    }

    public Object getDataSource(Object id) {
        return this.view.getDataSource(id);
    }

    public boolean setDataSource(Object source) {
        return this.view.setDataSource(source);
    }

    public boolean setDataSource(Object source, Object id) {
        return this.view.setDataSource(source, id);
    }

    public Object getObsoleteDataSource() {
        return this.view.getObsoleteDataSource();
    }

    public boolean dataSourceIsObsolete() {
        return this.view.dataSourceIsObsolete();
    }

    public void destroyObsoleteDataSource() {
        this.view.destroyObsoleteDataSource();
    }

    @Override
    public String getPFDItemId() {
        return this.view.getPFDItemId();
    }

    @Override
    public void setPFDItemId(String id) {
        this.view.setPFDItemId(id);
    }

    public class OverviewLayer
    extends JComponent
    implements PropertyChangeListener {
        private JComponent overview;
        private int padding = 1;

        public OverviewLayer(JComponent overview) {
            this.overview = overview;
            overview.addPropertyChangeListener(this);
            this.add(overview);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.overview.setLocation(this.getWidth() - this.overview.getWidth() - this.padding, this.getHeight() - this.overview.getHeight() - this.padding);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("size")) {
                this.overview.setLocation(this.getWidth() - this.overview.getWidth() - this.padding, this.getHeight() - this.overview.getHeight() - this.padding);
            }
        }
    }

    public class OverviewLayeredPane
    extends JLayeredPane
    implements PropertyChangeListener {
        JComponent primary;
        JComponent secondary;
        private int padding = 1;

        public OverviewLayeredPane(JComponent primary, JComponent secondary) {
            this.primary = primary;
            this.secondary = secondary;
            secondary.addPropertyChangeListener(this);
            this.add((Component)primary, JLayeredPane.DEFAULT_LAYER);
            this.add((Component)secondary, JLayeredPane.PALETTE_LAYER);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.primary.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.secondary.setLocation(this.getWidth() - this.secondary.getWidth() - this.padding, this.getHeight() - this.secondary.getHeight() - this.padding);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("size")) {
                this.secondary.setLocation(this.getWidth() - this.secondary.getWidth() - this.padding, this.getHeight() - this.secondary.getHeight() - this.padding);
            }
        }
    }
}

