/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.util.ShadowRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class PFDRoundRectangle
extends PFDDrawablePrimitive {
    transient RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
    int arcWidth = 25;
    int arcHeight = 25;

    public PFDRoundRectangle() {
    }

    public PFDRoundRectangle(Point p, Dimension size) {
        super(p, size);
    }

    public PFDRoundRectangle(Rectangle r) {
        super(r);
    }

    public PFDRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        super(r);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int w) {
        this.arcWidth = w;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int h) {
        this.arcHeight = h;
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        this.rr.setRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.arcWidth, this.arcHeight);
        if (this.shadowOn) {
            this.drawShadow(g2d, v);
        }
        if (this.pen.getStyle() == 0) {
            if (this.brush.getStyle() != 0) {
                this.brush.apply(g2d);
                g2d.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height, this.arcWidth, this.arcHeight);
            }
        } else {
            if (this.brush.getStyle() != 0) {
                this.brush.apply(g2d);
                g2d.fillRoundRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1, this.arcWidth, this.arcHeight);
            }
            this.pen.apply(g2d);
            g2d.drawRoundRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1, this.arcWidth, this.arcHeight);
        }
    }

    @Override
    protected void drawShadow(Graphics2D g2d, PFDView v) {
        int width = this.arcWidth * 2 + 1;
        int height = this.arcHeight * 2 + 1;
        BufferedImage primitiveImage = PFDUtil.createCompatibleImage(width, height, 3);
        Graphics2D primitiveGraphics = primitiveImage.createGraphics();
        primitiveGraphics.setColor(Color.BLACK);
        primitiveGraphics.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
        primitiveGraphics.dispose();
        BufferedImage shadowImage = ShadowRenderer.createShadow((BufferedImage)primitiveImage, (int)this.shadowSize, (float)this.shadowOpacity, (Color)Color.BLACK, (int)0);
        int shadowCornerWidth = this.arcWidth + this.shadowSize;
        int shadowCornerHeight = this.arcHeight + this.shadowSize;
        int xPos = this.bbox.x - this.shadowSize + this.shadowShift;
        int yPos = this.bbox.y - this.shadowSize + this.shadowShift;
        int middleWidth = this.bbox.width - 2 * this.arcWidth - 1;
        int middleHeight = this.bbox.height - 2 * this.arcHeight - 1;
        Rectangle drawBounds = new Rectangle(0, 0, shadowCornerWidth, shadowCornerHeight);
        g2d.drawImage(shadowImage, xPos + drawBounds.x, yPos + drawBounds.y, xPos + drawBounds.x + drawBounds.width, yPos + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.x = shadowCornerWidth + 1;
        g2d.drawImage(shadowImage, xPos + middleWidth + drawBounds.x, yPos + drawBounds.y, xPos + middleWidth + drawBounds.x + drawBounds.width, yPos + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.x = 0;
        drawBounds.y = shadowCornerHeight + 1;
        g2d.drawImage(shadowImage, xPos + drawBounds.x, yPos + middleHeight + drawBounds.y, xPos + drawBounds.x + drawBounds.width, yPos + middleHeight + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.x = shadowCornerWidth + 1;
        g2d.drawImage(shadowImage, xPos + middleWidth + drawBounds.x, yPos + middleHeight + drawBounds.y, xPos + middleWidth + drawBounds.x + drawBounds.width, yPos + middleHeight + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.setBounds(0, shadowCornerHeight, shadowCornerWidth, 1);
        g2d.drawImage(shadowImage, xPos + drawBounds.x, yPos + drawBounds.y, xPos + drawBounds.x + drawBounds.width, yPos + middleHeight + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.setBounds(shadowCornerWidth + 1, shadowCornerHeight, shadowCornerWidth, 1);
        g2d.drawImage(shadowImage, xPos + middleWidth + drawBounds.x, yPos + drawBounds.y, xPos + middleWidth + drawBounds.x + drawBounds.width, yPos + middleHeight + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.setBounds(shadowCornerWidth, 0, 1, shadowCornerHeight);
        g2d.drawImage(shadowImage, xPos + drawBounds.x, yPos + drawBounds.y, xPos + middleWidth + drawBounds.x + drawBounds.width, yPos + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
        drawBounds.setBounds(shadowCornerWidth, shadowCornerHeight + 1, 1, shadowCornerHeight);
        g2d.drawImage(shadowImage, xPos + drawBounds.x, yPos + middleHeight + drawBounds.y, xPos + middleWidth + drawBounds.x + drawBounds.width, yPos + middleHeight + drawBounds.y + drawBounds.height, drawBounds.x, drawBounds.y, drawBounds.x + drawBounds.width, drawBounds.y + drawBounds.height, null);
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        return this.rr.contains(x, y);
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDRoundRectangle clone = new PFDRoundRectangle();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDRoundRectangle toObject) {
        super.copyObject(toObject);
        toObject.setArcWidth(this.getArcWidth());
        toObject.setArcHeight(this.getArcHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rr = new RoundRectangle2D.Double();
    }
}

