/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDIconManager;
import com.sas.graphics.components.pfd.PFDTextPaneWindow;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.components.pfd.interfaces.PFDNoteInterface;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;

public class PFDQuickNoteWindow
extends PFDTextPaneWindow {
    private PFDNoteInterface parent;
    private static final String RB_KEY = "PFDQuickNoteWindow.";

    public PFDQuickNoteWindow(PFDNoteInterface parent) {
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.defaultWindowSize = new Dimension(150, 133);
        this.preferredSize.setSize(this.defaultWindowSize);
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        Icon noteIcon = PFDIconManager.getIcon("StickyNote_yellow12.gif");
        this.setIcon(noteIcon);
        this.titleText.setText(RB.getStringResource(RB_KEY, "title.txt"));
    }

    @Override
    protected void closeWindow() {
        this.parent.setNoteVisible(false);
    }

    @Override
    protected void updateStyle(Style style) {
        super.updateStyle(style);
        StyleElement se = style.getStyleElement("NoteStyleYellow");
        if (se != null) {
            this.setFillColor(se.getColorAttribute("fillColor", defaultFillColor));
            Color lineColor = se.getColorAttribute("lineColor", defaultOutlineColor);
            Color contrastColor = se.getColorAttribute("altColor", defaultOutlineColor);
            this.setOutlineColor(lineColor);
            this.setLineColor(contrastColor);
        }
    }
}

