/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDBrush;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.PFDRectangle;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class PFDProgressBar
extends PFDGroup
implements ChangeListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected BoundedRangeModel rangeModel = null;
    protected ChangeListener changeListener = null;
    protected ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private Dimension preferredSize;
    private PFDRectangle outlineRect;
    private PFDRectangle fillRect;
    private int orientation = 0;
    private PFDText text;
    private static final int maxVerticalStringWidth = 100;

    public PFDProgressBar() {
        this((BoundedRangeModel)null);
    }

    public PFDProgressBar(int min, int max) {
        this(new DefaultBoundedRangeModel(min, 0, min, max));
    }

    public PFDProgressBar(BoundedRangeModel newModel) {
        this.rangeModel = newModel == null ? new DefaultBoundedRangeModel() : newModel;
        this.init();
    }

    private void init() {
        this.rangeModel.addChangeListener(this);
        this.changeEvent = new ChangeEvent(this);
        this.preferredSize = new Dimension(100, 4);
        this.outlineRect = new PFDRectangle(new Rectangle(0, 0, this.preferredSize.width, this.preferredSize.height));
        this.outlineRect.getBrush().setStyle(0);
        this.fillRect = new PFDRectangle(new Rectangle(1, 1, 0, 0));
        this.fillRect.getPen().setStyle(0);
        this.text = new PFDText();
        this.text.setFontSize(11);
        this.text.setSelectable(false);
        this.addPrimitive(this.outlineRect);
        this.addPrimitive(this.fillRect);
        this.addPrimitive(this.text);
    }

    private void updateProgressBar() {
        int max;
        int value = this.rangeModel.getValue();
        int min = this.rangeModel.getMinimum();
        double percentageComplete = min >= (max = this.rangeModel.getMaximum()) ? 0.0 : (double)(value - min) / (double)(max - min);
        if (this.orientation == 0) {
            this.fillRect.setLocation(this.outlineRect.getRBBox().x + 1, this.outlineRect.getRBBox().y + 1);
            this.fillRect.setSize((int)(percentageComplete * (double)(this.preferredSize.width - 2)), this.preferredSize.height - 2);
        } else {
            int barLength = (int)(percentageComplete * (double)(this.preferredSize.height - 2));
            this.fillRect.setLocation(this.outlineRect.getRBBox().x + 1, this.outlineRect.getRBBox().y + this.preferredSize.height - 1 - barLength);
            this.fillRect.setSize(this.preferredSize.width - 2, barLength);
        }
    }

    protected void layoutChildren() {
        Point p = this.outlineRect.getSpotLocation(1, null);
        this.outlineRect.setBBox(p, this.preferredSize);
        this.fillRect.setLocation(p.x + 1, p.y + 1);
        this.updateProgressBar();
        if (this.orientation == 0) {
            this.text.setVerticalAlignment(1);
            this.text.setHorizontalAlignment(0);
            this.text.setWrapWidth(this.preferredSize.width);
            this.text.setClipping(true);
            this.text.setBBox(p.x + this.preferredSize.width / 2, p.y + this.preferredSize.height, 0, 0);
            this.text.forceUpdate();
        } else {
            this.text.setVerticalAlignment(0);
            this.text.setHorizontalAlignment(1);
            this.text.setWrapWidth(100);
            this.text.setClipping(true);
            this.text.setBBox(p.x + this.preferredSize.width, p.y + this.preferredSize.height / 2, 0, 0);
            this.text.forceUpdate();
        }
        this.calculateBBox();
    }

    @Override
    public PFDPen getPen() {
        return this.outlineRect.getPen();
    }

    @Override
    public void setPen(PFDPen pen) {
        this.outlineRect.setPen(pen);
    }

    @Override
    public PFDBrush getBrush() {
        return this.fillRect.getBrush();
    }

    @Override
    public void setBrush(PFDBrush brush) {
        this.fillRect.setBrush(brush);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (d == null || d.equals(this.preferredSize)) {
            return;
        }
        this.preferredSize.setSize(d);
        this.firePropertyChange("preferredSize");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public BoundedRangeModel getRangeModel() {
        return this.rangeModel;
    }

    public void setRangeModel(BoundedRangeModel newModel) {
        if (newModel == null) {
            return;
        }
        this.rangeModel.removeChangeListener(this);
        this.rangeModel = newModel;
        this.rangeModel.addChangeListener(this);
        this.updateProgressBar();
        this.fireChangeEvents();
    }

    public int getValue() {
        return this.rangeModel.getValue();
    }

    public void setValue(int n) {
        this.rangeModel.setValue(n);
    }

    public int getMinimum() {
        return this.rangeModel.getMinimum();
    }

    public void setMinimum(int n) {
        this.rangeModel.setMinimum(n);
    }

    public int getMaximum() {
        return this.rangeModel.getMaximum();
    }

    public void setMaximum(int n) {
        this.rangeModel.setMaximum(n);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation == this.orientation || newOrientation != 0 && newOrientation != 1) {
            return;
        }
        this.orientation = newOrientation;
        this.firePropertyChange("orientation");
    }

    public String getString() {
        return this.text.getText();
    }

    public void setString(String newString) {
        if (newString == null ? this.text.getText() == null : newString.equals(this.text.getText())) {
            return;
        }
        this.text.setText(newString);
        if (this.text.isVisible()) {
            this.firePropertyChange("string");
        }
    }

    public void setStringVisible(boolean visible) {
        if (this.text.isVisible() == visible) {
            return;
        }
        this.text.setVisible(visible);
        this.firePropertyChange("stringVisible");
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    private void fireChangeEvents() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("children") || property.equals("preferredSize") || property.equals("string") || property.equals("stringVisible") || property.equals("orientation") || property.equals("all")) {
            this.layoutChildren();
        }
        super.update(property, v);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateProgressBar();
        this.fireChangeEvents();
    }
}

