/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDComponentPrimitive;
import com.sas.graphics.components.pfd.PFDDnDAdapter;
import com.sas.graphics.components.pfd.PFDImageNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDSASNode;
import com.sas.graphics.components.pfd.PFDShapeNode;
import com.sas.graphics.components.pfd.PFDSimpleNode;
import com.sas.graphics.components.pfd.PFDTableNode;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class PFDPrimitiveDnDAdapter
extends PFDDnDAdapter {
    private static int count = 0;

    public PFDPrimitiveDnDAdapter() {
    }

    public PFDPrimitiveDnDAdapter(PFDView view) {
        this.attachView(view);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrag(3);
        } else {
            super.dragEnter(e);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            e.acceptDrag(3);
        } else {
            super.dragOver(e);
        }
    }

    @Override
    public synchronized void drop(DropTargetDropEvent e) {
        Transferable tr = e.getTransferable();
        if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                e.acceptDrop(3);
                String s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                PFDModel m = this.view.getModel();
                Point p = e.getLocation();
                if (this.view.isSnapToGrid()) {
                    this.view.snapViewGrid(p);
                }
                this.view.ViewToModel(p);
                if (s.equals("Image Node")) {
                    URL url = PFDPrimitiveDnDAdapter.class.getResource("res/blankIcon.gif");
                    Image image = Toolkit.getDefaultToolkit().getImage(url);
                    MediaTracker imageTracker = new MediaTracker(this.view);
                    imageTracker.addImage(image, 0);
                    try {
                        imageTracker.waitForAll();
                    }
                    catch (InterruptedException ex) {
                        System.out.println(ex.getMessage());
                    }
                    PFDImageNode sn = new PFDImageNode(p, new Dimension(45, 50), image, "Image Node");
                    m.addPrimitive(sn);
                } else if (s.equals("Rectangle Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(25, 25), Integer.toString(++count));
                    sn.setShape(2);
                    m.addPrimitive(sn);
                } else if (s.equals("Round Rectangle Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(120, 40), "Round Rectangle");
                    sn.setShape(3);
                    m.addPrimitive(sn);
                } else if (s.equals("Oval Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(80, 40), "Oval");
                    sn.setShape(5);
                    m.addPrimitive(sn);
                } else if (s.equals("Diamond Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(80, 60), "Diamond");
                    sn.setShape(6);
                    m.addPrimitive(sn);
                } else if (s.equals("Parallelogram Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(120, 40), "Parallelogram");
                    sn.setShape(8);
                    m.addPrimitive(sn);
                } else if (s.equals("Hexagon Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(80, 60), "Hexagon");
                    sn.setShape(7);
                    m.addPrimitive(sn);
                } else if (s.equals("Pentagon Node")) {
                    PFDShapeNode sn = new PFDShapeNode(p, new Dimension(60, 60), "Pentagon");
                    sn.setShape(9);
                    m.addPrimitive(sn);
                } else if (s.equals("Simple Node")) {
                    PFDSimpleNode sn = new PFDSimpleNode(p, new Dimension(40, 40), "Simple Node");
                    m.addPrimitive(sn);
                } else if (s.equals("Table Node")) {
                    Object[][] data = new String[][]{{"In0", "Out0"}, {"In1", "Out1"}, {"In2", "Out2"}};
                    Object[] names = new String[]{"In", "Out"};
                    DefaultTableModel tm = new DefaultTableModel(data, names);
                    PFDTableNode tab = new PFDTableNode(p, new Dimension(120, 65), tm, "Table Node");
                    m.addPrimitive(tab);
                } else if (s.equals("JButton")) {
                    PFDComponentPrimitive cp = new PFDComponentPrimitive(new JButton("JButton"));
                    cp.setBBox(p, new Dimension(80, 20));
                    m.addPrimitive(cp);
                } else if (s.equals("JTextField")) {
                    PFDComponentPrimitive cp = new PFDComponentPrimitive(new JTextField("JTextField"));
                    cp.setBBox(p, new Dimension(100, 20));
                    m.addPrimitive(cp);
                } else if (s.equals("Link")) {
                    PFDPort from = new PFDPort();
                    from.setType(0);
                    PFDPort to = new PFDPort();
                    to.setType(0);
                    to.setToLinkDirection(0.0);
                    m.addPrimitive(from);
                    m.addPrimitive(to);
                    from.setBBox(p, new Dimension(5, 5));
                    to.setBBox(p.x + 80, p.y + 60, 5, 5);
                    PFDLink link = new PFDLink(from, to);
                    link.setOrthogonal(true);
                    m.addPrimitive(link);
                    link.setFromLabel("from");
                    link.setMiddleLabel("middle");
                    link.setToLabel("to");
                } else if (s.equals("PFDText")) {
                    PFDText label = new PFDText("Enter Your Text Here");
                    label.setFontSize(14);
                    label.setTransparent(false);
                    label.setBackground(new Color(255, 255, 225));
                    label.setBBox(p, new Dimension(50, 12));
                    m.addPrimitive(label);
                } else if (s.equals("PFDSASNode")) {
                    PFDSASNode sasNode = new PFDSASNode(p, 1, "PFDSASNode", "");
                    sasNode.setBorderColor(new Color(102, 153, 204));
                    sasNode.setSeperatorColor(new Color(133, 173, 214));
                    sasNode.setTitleAreaColor(new Color(178, 204, 229));
                    sasNode.setContentAreaColor(Color.WHITE);
                    m.addPrimitive(sasNode);
                }
                e.getDropTargetContext().dropComplete(true);
            }
            catch (IOException exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
                e.rejectDrop();
            }
            catch (UnsupportedFlavorException ufException) {
                ufException.printStackTrace();
                System.err.println(ufException.getMessage());
                e.rejectDrop();
            }
        } else {
            super.drop(e);
        }
    }
}

