/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDEmptyPrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPropertyChangeCache;
import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.PFDViewListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class PFDPortGroup
extends PFDGroup
implements ActionListener,
PFDViewListener,
PropertyChangeListener {
    private static final long serialVersionUID = -5213506028991950614L;
    private static final int RENDER_MODE_INVALID = -1;
    public static final int RENDER_MODE_NONE = 0;
    public static final int RENDER_MODE_STUB = 1;
    public static final int RENDER_MODE_PORTS = 2;
    public static final int PORT_TYPE_INPUT = 0;
    public static final int PORT_TYPE_OUTPUT = 1;
    private static final Color stubColor = PFDLink.defaultColor;
    private static final Color portOutlineColor = new Color(128, 128, 128);
    private static final BasicStroke portOpenStroke = new BasicStroke(1.0f);
    private static final BasicStroke portOpenControlStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 3.0f, 3.0f, 3.0f}, 1.0f);
    private static final List layoutProperties = Arrays.asList("all", "ports", "numVisiblePorts", "anchorPoint", "direction", "forceShowPorts", "renderMode", "multiplePortOffset", "portGroupOffset", "portOffset", "portType", "showMultipleCollapsedPorts", "portMinBoundsOffset", "portMaxBoundsOffset", "showSinglePort");
    protected int renderMode = 0;
    private int timedRenderMode = -1;
    protected int portType = 1;
    private static final int expandedStubOffset = 1;
    private static final int defaultStubWidth = 10;
    private static final int defaultStubHeight = 5;
    private int stubWidth = 10;
    private int stubHeight = 5;
    private int portOffset = 2;
    private int portGroupOffset = 6;
    private int hotspotWidth = this.stubWidth + this.portOffset + 12;
    private int hotspotHeight = this.stubHeight + 20;
    private int hotspotOffset = -6;
    private int portMinBoundsOffset = 0;
    private int portMaxBoundsOffset = 0;
    private int popupDelay = 300;
    private int popdownDelay = 1000;
    private int endSegmentLength = 15;
    protected Vector ports;
    protected Vector visiblePorts;
    protected PFDPort mouseOverPort;
    protected PFDPort highlightPort;
    private Rectangle portHotspotRect = new Rectangle();
    private PFDEmptyPrimitive anchorPoint;
    private PFDEmptyPrimitive hotSpot;
    protected Dimension portSize;
    private int direction = 4;
    private Timer renderTimer;
    private boolean holdRenderMode = false;
    private transient PFDView attachedView;
    protected boolean forceShowPorts = false;
    protected int numVisiblePorts = 0;
    private boolean showMultipleCollapsedPorts = false;
    private int multiplePortOffset = 0;
    private boolean showSinglePort = false;
    private Color portColor = Color.white;
    private Color portHighlightColor = Color.white;
    private Color portFullColor = Color.white;
    private int portSpacing = 1;
    protected int portCornerRadius = 4;
    protected static final float highlightDarken = 0.075f;
    protected static final float fullDarken = 0.2f;
    protected static final float fullSharpen = 0.75f;
    private Hashtable portLinkMap = new Hashtable();

    public PFDPortGroup() {
        this.ports = new Vector();
        this.visiblePorts = new Vector();
        this.portSize = new Dimension(13, 13);
        this.anchorPoint = new PFDEmptyPrimitive();
        this.hotSpot = new PFDEmptyPrimitive();
        this.addPrimitive(this.anchorPoint);
        this.renderTimer = new Timer(2000, this);
        this.renderTimer.setRepeats(false);
        this.computePortColors();
    }

    public PFDPortGroup(int type) {
        this();
        this.setPortType(type);
    }

    public void setPortType(int type) {
        if (this.portType == type) {
            return;
        }
        if (type == 0) {
            this.stubWidth = 0;
            this.stubHeight = 0;
        } else if (type == 1) {
            this.stubWidth = 10;
            this.stubHeight = 5;
        } else {
            return;
        }
        this.portType = type;
        this.firePropertyChange("portType");
    }

    public int getPortType() {
        return this.portType;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction || !this.checkDirection(direction)) {
            return;
        }
        this.direction = direction;
        this.firePropertyChange("direction");
    }

    private boolean checkDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void setPortMinBoundsOffset(int offset) {
        if (offset == this.portMinBoundsOffset) {
            return;
        }
        this.portMinBoundsOffset = offset;
        this.firePropertyChange("portMinBoundsOffset");
    }

    public int getPortMinBoundsOffset() {
        return this.portMinBoundsOffset;
    }

    public int getPortMaxBoundsOffset() {
        return this.portMaxBoundsOffset;
    }

    public void setPortMaxBoundsOffset(int offset) {
        if (offset == this.portMaxBoundsOffset) {
            return;
        }
        this.portMaxBoundsOffset = offset;
        this.firePropertyChange("portMaxBoundsOffset");
    }

    public int getPortGroupOffset() {
        return this.portGroupOffset;
    }

    public void setPortGroupOffset(int offset) {
        if (this.portGroupOffset == offset) {
            return;
        }
        this.portGroupOffset = offset;
        this.firePropertyChange("portGroupOffset");
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int offset) {
        if (this.portOffset == offset) {
            return;
        }
        this.portOffset = offset;
        this.hotspotWidth = 10 + offset;
        this.firePropertyChange("portOffset");
    }

    public void setAnchorPoint(Point anchor) {
        if (this.anchorPoint.getLocation().equals(anchor)) {
            return;
        }
        this.anchorPoint.setLocation(anchor);
        this.firePropertyChange("anchorPoint");
    }

    public Point getAnchorPoint() {
        return this.anchorPoint.getLocation();
    }

    public int getMultiplePortOffset() {
        return this.multiplePortOffset;
    }

    public void setMultiplePortOffset(int multiplePortOffset) {
        if (multiplePortOffset == this.multiplePortOffset) {
            return;
        }
        this.multiplePortOffset = multiplePortOffset;
        this.firePropertyChange("multiplePortOffset");
    }

    public boolean isShowMultipleCollapsedPorts() {
        return this.showMultipleCollapsedPorts;
    }

    public void setShowMultipleCollapsedPorts(boolean showMultipleCollapsedPorts) {
        if (showMultipleCollapsedPorts == this.showMultipleCollapsedPorts) {
            return;
        }
        this.showMultipleCollapsedPorts = showMultipleCollapsedPorts;
        this.firePropertyChange("showMultipleCollapsedPorts");
    }

    public void addPort(PFDPort p) {
        if (p != null) {
            this.ports.add(p);
            if (p.isVisible()) {
                ++this.numVisiblePorts;
            }
            p.addPropertyChangeListener(this);
            this.addLinkListeners(p);
            p.removeMouseListener(p);
            p.removeMouseMotionListener(p);
            this.firePropertyChange("ports");
        }
    }

    public void addPort(int index, PFDPort p) {
        if (p != null) {
            this.ports.add(index, p);
            if (p.isVisible()) {
                ++this.numVisiblePorts;
            }
            p.addPropertyChangeListener(this);
            this.addLinkListeners(p);
            p.removeMouseListener(p);
            p.removeMouseMotionListener(p);
            this.firePropertyChange("ports");
        }
    }

    public boolean removePort(PFDPort p) {
        boolean contained = this.ports.remove(p);
        if (contained) {
            if (p.isVisible()) {
                --this.numVisiblePorts;
            }
            p.removePropertyChangeListener(this);
            this.removeLinkListeners(p);
            this.firePropertyChange("ports");
        }
        return contained;
    }

    public PFDPort removePort(int index) {
        PFDPort retVal = (PFDPort)this.ports.remove(index);
        if (retVal != null) {
            if (retVal.isVisible()) {
                --this.numVisiblePorts;
            }
            retVal.removePropertyChangeListener(this);
            this.removeLinkListeners(retVal);
            this.firePropertyChange("ports");
        }
        return retVal;
    }

    public void removeAllPorts() {
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.get(i);
            p.removePropertyChangeListener(this);
            this.removeLinkListeners(p);
        }
        this.numVisiblePorts = 0;
        this.ports.clear();
    }

    protected void addLinkListeners(PFDPort port) {
        if (port == null) {
            return;
        }
        int numLinks = port.getNumLinks();
        Vector<PFDLink> links = new Vector<PFDLink>();
        for (int i = 0; i < numLinks; ++i) {
            PFDLink l = port.getLink(i);
            links.add(l);
            l.addPropertyChangeListener(this);
        }
        if (numLinks > 0) {
            this.portLinkMap.put(port, links);
        }
    }

    protected void removeLinkListeners(PFDPort port) {
        if (port == null) {
            return;
        }
        Vector links = (Vector)this.portLinkMap.get(port);
        if (links == null) {
            return;
        }
        for (int i = 0; i < links.size(); ++i) {
            PFDLink l = (PFDLink)links.get(i);
            l.removePropertyChangeListener(this);
        }
        this.portLinkMap.remove(port);
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public int getNumVisiblePorts() {
        return this.numVisiblePorts;
    }

    public PFDPort getPort(int index) {
        return (PFDPort)this.ports.get(index);
    }

    public boolean containsPort(PFDPort port) {
        return this.ports.contains(port);
    }

    public int getPortIndex(PFDPort p) {
        return this.ports.indexOf(p);
    }

    public boolean hasNoLinks() {
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = (PFDPort)this.ports.elementAt(i);
            if (port.hasNoLinks()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNoVisibleLinks() {
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = (PFDPort)this.ports.elementAt(i);
            if (!port.isVisible() || port.hasNoVisibleLinks()) continue;
            return false;
        }
        return true;
    }

    public boolean hasValidInteractivePort() {
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort port = (PFDPort)this.ports.elementAt(i);
            if (!port.isVisible() || !(this.portType == 0 ? port.isValidInteractiveToPort() : port.isValidInteractiveFromPort())) continue;
            return true;
        }
        return false;
    }

    public void setForceShowPorts(boolean showPorts) {
        if (this.forceShowPorts == showPorts) {
            return;
        }
        this.forceShowPorts = showPorts;
        this.firePropertyChange("forceShowPorts");
    }

    public boolean getForceShowPorts() {
        return this.forceShowPorts;
    }

    public void setRenderMode(int mode) {
        this.setRenderMode(mode, false);
    }

    public void setRenderMode(int mode, boolean forceImmediate) {
        if (forceImmediate) {
            this.renderTimer.stop();
            this.timedRenderMode = -1;
            this.setRenderMode(mode, 0);
        } else if (this.renderMode == 2) {
            this.setRenderMode(mode, this.popdownDelay);
        } else if (mode == 2) {
            this.setRenderMode(mode, this.popupDelay);
        } else {
            this.setRenderMode(mode, 0);
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    private void setRenderMode(int mode, int delay) {
        if (this.holdRenderMode) {
            return;
        }
        if (mode == this.renderMode) {
            this.renderTimer.stop();
            this.timedRenderMode = -1;
            return;
        }
        if (mode == this.timedRenderMode) {
            return;
        }
        if (delay <= 0) {
            this.renderTimer.stop();
            this.setImmediateRenderMode(mode);
        } else {
            this.timedRenderMode = mode;
            this.renderTimer.setInitialDelay(delay);
            this.renderTimer.restart();
        }
    }

    private void setImmediateRenderMode(int mode) {
        if (this.holdRenderMode || mode == this.renderMode) {
            return;
        }
        int oldValue = this.renderMode;
        this.timedRenderMode = -1;
        this.renderMode = mode;
        this.firePropertyChange("renderMode", new Integer(oldValue), new Integer(this.renderMode));
    }

    protected int getComputedRenderMode() {
        int tempRenderMode = this.renderMode;
        switch (this.renderMode) {
            case 0: {
                if (this.forceShowPorts && this.canShowPorts()) {
                    tempRenderMode = 2;
                    break;
                }
                if (this.portType != 1 || this.numVisiblePorts <= 0 || this.hasNoVisibleLinks()) break;
                tempRenderMode = 1;
                break;
            }
            case 1: {
                if (this.forceShowPorts && this.canShowPorts()) {
                    tempRenderMode = 2;
                    break;
                }
                if (this.portType != 0 && this.numVisiblePorts != 0) break;
                tempRenderMode = 0;
                break;
            }
            case 2: {
                if (this.canShowPorts()) break;
                tempRenderMode = this.portType == 1 && this.numVisiblePorts == 1 && !this.hasNoVisibleLinks() ? 1 : 0;
            }
        }
        return tempRenderMode;
    }

    protected void loadVisiblePorts() {
        this.visiblePorts.clear();
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.get(i);
            if (!p.isVisible()) continue;
            this.visiblePorts.add(p);
        }
        this.numVisiblePorts = this.visiblePorts.size();
    }

    protected void layoutChildren() {
        this.loadVisiblePorts();
        this.removeAllPrimitives();
        this.addPrimitive(this.anchorPoint);
        switch (this.getComputedRenderMode()) {
            case 0: 
            case 1: {
                this.layoutWithoutPorts();
                break;
            }
            case 2: {
                this.layoutWithPorts();
            }
        }
        this.calculateBBox();
    }

    private void layoutWithoutPorts() {
        int x = 0;
        int y = 0;
        double toDir = 0.0;
        double fromDir = 0.0;
        int dx = 0;
        int dy = 0;
        int delta = 0;
        int multiPortXOffset = 0;
        int multiPortYOffset = 0;
        delta = this.ports.size() > 1 ? this.multiplePortOffset * 2 / (this.ports.size() - 1) : 0;
        switch (this.direction) {
            case 3: {
                x = this.anchorPoint.getX() - this.portOffset - this.stubWidth;
                y = this.anchorPoint.getY();
                fromDir = Math.PI;
                toDir = 0.0;
                dy = delta;
                multiPortYOffset = this.multiplePortOffset;
                this.hotSpot.setBBox(this.anchorPoint.getX() - this.hotspotOffset - this.hotspotWidth, this.anchorPoint.getY() - this.hotspotHeight / 2, this.hotspotWidth, this.hotspotHeight);
                this.addPrimitive(this.hotSpot);
                break;
            }
            case 4: {
                x = this.anchorPoint.getX() + this.portOffset + this.stubWidth;
                y = this.anchorPoint.getY();
                fromDir = 0.0;
                toDir = Math.PI;
                dy = delta;
                multiPortYOffset = this.multiplePortOffset;
                this.hotSpot.setBBox(this.anchorPoint.getX() + this.hotspotOffset, this.anchorPoint.getY() - this.hotspotHeight / 2, this.hotspotWidth, this.hotspotHeight);
                this.addPrimitive(this.hotSpot);
                break;
            }
            case 1: {
                x = this.anchorPoint.getX();
                y = this.anchorPoint.getY() - this.portOffset - this.stubWidth;
                fromDir = 1.5707963267948966;
                toDir = 4.71238898038469;
                dx = delta;
                multiPortXOffset = this.multiplePortOffset;
                this.hotSpot.setBBox(this.anchorPoint.getX() - this.hotspotHeight / 2, this.anchorPoint.getY() - this.hotspotOffset - this.hotspotWidth, this.hotspotHeight, this.hotspotWidth);
                this.addPrimitive(this.hotSpot);
                break;
            }
            case 2: {
                x = this.anchorPoint.getX();
                y = this.anchorPoint.getY() + this.portOffset + this.stubWidth;
                fromDir = 4.71238898038469;
                toDir = 1.5707963267948966;
                dx = delta;
                multiPortXOffset = this.multiplePortOffset;
                this.hotSpot.setBBox(this.anchorPoint.getX() - this.hotspotHeight / 2, this.anchorPoint.getY() + this.hotspotOffset, this.hotspotHeight, this.hotspotWidth);
                this.addPrimitive(this.hotSpot);
            }
        }
        Iterator portIterator = this.getPortIterator();
        int i = 0;
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            this.addPrimitive(port);
            port.setType(0);
            if (this.showMultipleCollapsedPorts) {
                port.setLocation(x - multiPortXOffset + dx * i, y - multiPortYOffset + dy * i);
            } else {
                port.setLocation(x, y);
            }
            if (this.portType == 0) {
                port.setValidFromPort(false);
                port.setValidToPort(true);
                port.setToLinkDirection(toDir);
                port.setEndSegmentLength(this.endSegmentLength);
            } else {
                port.setValidFromPort(true);
                port.setValidToPort(false);
                port.setFromLinkDirection(fromDir);
                port.setEndSegmentLength(0);
            }
            ++i;
        }
    }

    private void layoutWithPorts() {
        int bgWidth = this.portSize.width;
        int bgHeight = this.getNumLayoutPorts() * this.portSize.height + (this.getNumLayoutPorts() - 1) * this.portSpacing;
        int centeredHeight = this.getNumCenteredPorts() * this.portSize.height + (this.getNumCenteredPorts() - 1) * this.portSpacing;
        int centerOffset = (this.portMaxBoundsOffset - this.portMinBoundsOffset) / 2;
        int bgOffset = 0;
        int bgX = 0;
        int bgY = 0;
        int portX = 0;
        int portY = 0;
        int deltaX = 0;
        int deltaY = 0;
        double toDir = 0.0;
        switch (this.direction) {
            case 3: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                bgX = this.anchorPoint.getX() - this.portGroupOffset - bgWidth;
                bgY = this.anchorPoint.getY() - bgOffset;
                this.hotSpot.setBBox(bgX, bgY, this.portGroupOffset + bgWidth + this.stubWidth + 1 - this.hotspotOffset, bgHeight);
                this.portHotspotRect.setBounds(this.stubWidth + 1, -this.portSize.height / 2, this.portSize.width, this.portSize.height);
                portX = bgX - 1 - this.stubWidth;
                portY = bgY + this.portSize.height / 2;
                deltaY = this.portSize.height + this.portSpacing;
                deltaX = 0;
                toDir = 0.0;
                break;
            }
            case 4: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                bgX = this.anchorPoint.getX() + this.portGroupOffset;
                bgY = this.anchorPoint.getY() - bgOffset;
                this.hotSpot.setBBox(this.anchorPoint.getX() + this.hotspotOffset, bgY, this.portGroupOffset + bgWidth + this.stubWidth + 1 - this.hotspotOffset, bgHeight);
                this.portHotspotRect.setBounds(-this.stubWidth - 1 - this.portSize.width, -this.portSize.height / 2, this.portSize.width, this.portSize.height);
                portX = bgX + this.portSize.width + 1 + this.stubWidth;
                portY = bgY + this.portSize.height / 2;
                deltaY = this.portSize.height + this.portSpacing;
                deltaX = 0;
                toDir = Math.PI;
                break;
            }
            case 1: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                bgX = this.anchorPoint.getX() - bgOffset;
                bgY = this.anchorPoint.getY() - this.portGroupOffset - bgWidth;
                this.hotSpot.setBBox(bgX, bgY, bgHeight, this.portGroupOffset + bgWidth + this.stubWidth + 1 - this.hotspotOffset);
                this.portHotspotRect.setBounds(-this.portSize.width / 2, this.stubWidth + 1, this.portSize.width, this.portSize.height);
                portX = bgX + this.portSize.width / 2;
                portY = bgY - 1 - this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                toDir = 4.71238898038469;
                break;
            }
            case 2: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                bgX = this.anchorPoint.getX() - bgOffset;
                bgY = this.anchorPoint.getY() + this.portGroupOffset;
                this.hotSpot.setBBox(bgX, this.anchorPoint.getY() + this.hotspotOffset, bgHeight, this.portGroupOffset + bgWidth + this.stubWidth + 1 - this.hotspotOffset);
                this.portHotspotRect.setBounds(-this.portSize.width / 2, -this.stubWidth - 1 - this.portSize.height, this.portSize.width, this.portSize.height);
                portX = bgX + this.portSize.width / 2;
                portY = bgY + this.portSize.height + 1 + this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                toDir = 1.5707963267948966;
            }
        }
        this.addPrimitive(this.hotSpot);
        Iterator portIterator = this.getPortIterator();
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            this.addPrimitive(port);
            port.setLocation(portX, portY);
            port.setType(0);
            if (this.portType == 0) {
                port.setValidFromPort(false);
                port.setValidToPort(true);
                port.setToLinkDirection(toDir);
                port.setEndSegmentLength(this.endSegmentLength);
                continue;
            }
            port.setValidFromPort(true);
            port.setValidToPort(false);
            port.setEndSegmentLength(0);
        }
        portIterator = this.getVisiblePortIterator();
        int di = 0;
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            port.setLocation(portX + deltaX * di, portY + deltaY * di);
            ++di;
        }
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        if (this.ports.isEmpty()) {
            return;
        }
        Stroke stroke = g2d.getStroke();
        switch (this.getComputedRenderMode()) {
            case 1: {
                this.renderStub(g2d, v);
                break;
            }
            case 2: {
                this.renderPorts(g2d, v);
            }
        }
        g2d.setStroke(stroke);
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
        if (!this.visible || this.ports.isEmpty()) {
            return;
        }
        switch (this.getComputedRenderMode()) {
            case 1: {
                this.renderStubOverview(g2d, v);
                break;
            }
            case 2: {
                this.renderPortsOverview(g2d, v);
            }
        }
    }

    private void renderStub(Graphics2D g2d, PFDView v) {
        g2d.setColor(stubColor);
        switch (this.direction) {
            case 3: {
                g2d.fillRect(this.anchorPoint.getX() - this.portOffset - this.stubWidth, this.anchorPoint.getY() - this.stubHeight / 2, this.stubWidth, this.stubHeight);
                break;
            }
            case 1: {
                g2d.fillRect(this.anchorPoint.getX() - this.stubHeight / 2, this.anchorPoint.getY() - this.portOffset - this.stubWidth, this.stubHeight, this.stubWidth);
                break;
            }
            case 2: {
                g2d.fillRect(this.anchorPoint.getX() - this.stubHeight / 2, this.anchorPoint.getY() + this.portOffset, this.stubHeight, this.stubWidth);
                break;
            }
            case 4: {
                g2d.fillRect(this.anchorPoint.getX() + this.portOffset, this.anchorPoint.getY() - this.stubHeight / 2, this.stubWidth, this.stubHeight);
            }
        }
    }

    private void renderStubOverview(Graphics2D g2d, PFDView v) {
        int y2;
        int y1;
        int x2;
        int x1;
        g2d.setColor(stubColor);
        switch (this.direction) {
            case 3: {
                x1 = this.anchorPoint.getX() - this.portOffset - this.stubWidth;
                x2 = this.anchorPoint.getX();
                y2 = y1 = this.anchorPoint.getY();
                break;
            }
            case 1: {
                x2 = x1 = this.anchorPoint.getX();
                y1 = this.anchorPoint.getY() - this.portOffset - this.stubWidth;
                y2 = this.anchorPoint.getY();
                break;
            }
            case 2: {
                x2 = x1 = this.anchorPoint.getX();
                y1 = this.anchorPoint.getY();
                y2 = this.anchorPoint.getY() + this.portOffset + this.stubWidth;
                break;
            }
            default: {
                x1 = this.anchorPoint.getX();
                x2 = this.anchorPoint.getX() + this.portOffset + this.stubWidth;
                y2 = y1 = this.anchorPoint.getY();
            }
        }
        g2d.drawLine(x1, y1, x2, y2);
    }

    private void renderPorts(Graphics2D g2d, PFDView v) {
        int bgWidth = this.portSize.width;
        int centeredHeight = this.getNumCenteredPorts() * this.portSize.height + (this.getNumCenteredPorts() - 1) * this.portSpacing;
        int centerOffset = (this.portMaxBoundsOffset - this.portMinBoundsOffset) / 2;
        int bgOffset = 0;
        int rectX = 0;
        int rectY = 0;
        int stubX = 0;
        int stubY = 0;
        int deltaX = 0;
        int deltaY = 0;
        int stubW = 0;
        int stubH = 0;
        switch (this.direction) {
            case 3: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - this.portGroupOffset - bgWidth;
                rectY = this.anchorPoint.getY() - bgOffset;
                stubX = rectX - 1 - this.stubWidth;
                stubY = rectY + this.portSize.height / 2 - this.stubHeight / 2;
                stubW = this.stubWidth;
                stubH = this.stubHeight;
                deltaX = 0;
                deltaY = this.portSize.height + this.portSpacing;
                break;
            }
            case 1: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - bgOffset;
                rectY = this.anchorPoint.getY() - this.portGroupOffset - bgWidth;
                stubX = rectX + this.portSize.width / 2 - this.stubHeight / 2;
                stubY = rectY - 1 - this.stubWidth;
                stubW = this.stubHeight;
                stubH = this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                break;
            }
            case 2: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - bgOffset;
                rectY = this.anchorPoint.getY() + this.portGroupOffset;
                stubX = rectX + this.portSize.width / 2 - this.stubHeight / 2;
                stubY = rectY + this.portSize.height + 1;
                stubW = this.stubHeight;
                stubH = this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                break;
            }
            case 4: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() + this.portGroupOffset;
                rectY = this.anchorPoint.getY() - bgOffset;
                stubX = rectX + this.portSize.width + 1;
                stubY = rectY + this.portSize.height / 2 - this.stubHeight / 2;
                stubW = this.stubWidth;
                stubH = this.stubHeight;
                deltaY = this.portSize.height + this.portSpacing;
                deltaX = 0;
            }
        }
        g2d.setStroke(portOpenStroke);
        Iterator portIterator = this.getVisiblePortIterator();
        int di = 0;
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            this.drawPortAt(g2d, port, rectX + deltaX * di, rectY + deltaY * di);
            if (this.portType == 1 && !port.hasNoVisibleLinks()) {
                g2d.setColor(stubColor);
                g2d.fillRect(stubX + deltaX * di, stubY + deltaY * di, stubW, stubH);
            }
            ++di;
        }
    }

    private void renderPortsOverview(Graphics2D g2d, PFDView v) {
        int bgWidth = this.portSize.width;
        int centeredHeight = this.getNumCenteredPorts() * this.portSize.height + (this.getNumCenteredPorts() - 1) * this.portSpacing;
        int centerOffset = (this.portMaxBoundsOffset - this.portMinBoundsOffset) / 2;
        int bgOffset = 0;
        int rectX = 0;
        int rectY = 0;
        int stubX = 0;
        int stubY = 0;
        int deltaX = 0;
        int deltaY = 0;
        switch (this.direction) {
            case 3: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - this.portGroupOffset - bgWidth;
                rectY = this.anchorPoint.getY() - bgOffset;
                stubX = rectX - 1 - this.stubWidth;
                stubY = rectY + this.portSize.height / 2 - this.stubHeight / 2;
                deltaX = 0;
                deltaY = this.portSize.height + this.portSpacing;
                break;
            }
            case 1: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - bgOffset;
                rectY = this.anchorPoint.getY() - this.portGroupOffset - bgWidth;
                stubX = rectX + this.portSize.width / 2 - this.stubHeight / 2;
                stubY = rectY - 1 - this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                break;
            }
            case 2: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() - bgOffset;
                rectY = this.anchorPoint.getY() + this.portGroupOffset;
                stubX = rectX + this.portSize.width / 2 - this.stubHeight / 2;
                stubY = rectY + this.portSize.height + 1 + this.stubWidth;
                deltaX = this.portSize.width + this.portSpacing;
                deltaY = 0;
                break;
            }
            case 4: {
                bgOffset = Math.min(centeredHeight / 2 - centerOffset, this.portMinBoundsOffset);
                rectX = this.anchorPoint.getX() + this.portGroupOffset;
                rectY = this.anchorPoint.getY() - bgOffset;
                stubX = rectX + this.portSize.width + 1 + this.stubWidth;
                stubY = rectY + this.portSize.height / 2 - this.stubHeight / 2;
                deltaY = this.portSize.height + this.portSpacing;
                deltaX = 0;
            }
        }
        g2d.setStroke(portOpenStroke);
        g2d.setColor(stubColor);
        Iterator portIterator = this.getVisiblePortIterator();
        int di = 0;
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            if (this.portType == 1 && !port.hasNoVisibleLinks()) {
                g2d.drawLine(this.anchorPoint.getX(), this.anchorPoint.getY(), stubX + deltaX * di, stubY + deltaY * di);
            }
            ++di;
        }
    }

    protected void drawPortAt(Graphics2D g2d, PFDPort port, int x, int y) {
        if (port == this.highlightPort) {
            g2d.setColor(this.portHighlightColor);
        } else {
            g2d.setColor(this.portColor);
        }
        g2d.fillRoundRect(x, y, this.portSize.width, this.portSize.height, this.portCornerRadius, this.portCornerRadius);
        if (port.isControl()) {
            g2d.setStroke(portOpenControlStroke);
        } else {
            g2d.setStroke(portOpenStroke);
        }
        g2d.setColor(portOutlineColor);
        g2d.drawRoundRect(x, y, this.portSize.width - 1, this.portSize.height - 1, this.portCornerRadius, this.portCornerRadius);
        if (port.isFull()) {
            g2d.setColor(this.portFullColor);
            g2d.fillRect(x + 3, y + 3, this.portSize.width - 6, this.portSize.height - 6);
        }
    }

    private PFDPort getMouseOverPort(int x, int y) {
        if (this.getComputedRenderMode() == 2) {
            Iterator portIterator = this.getVisiblePortIterator();
            int padding = 1;
            while (portIterator.hasNext()) {
                PFDPort port = (PFDPort)portIterator.next();
                if (!port.isVisible()) continue;
                int rectX = port.getX() + this.portHotspotRect.x - padding;
                int rectY = port.getY() + this.portHotspotRect.y - padding;
                if (x < rectX || x >= rectX + this.portHotspotRect.width + 2 * padding || y < rectY || y >= rectY + this.portHotspotRect.height + 2 * padding) continue;
                return port;
            }
        }
        return null;
    }

    private void setHighlightPort(PFDPort port) {
        if (this.highlightPort == port) {
            return;
        }
        this.highlightPort = port;
        this.firePropertyChange("highlightPort");
    }

    public void setHoldRenderMode(boolean hold) {
        this.holdRenderMode = hold;
        if (this.holdRenderMode) {
            this.renderTimer.stop();
            this.timedRenderMode = -1;
        }
    }

    private void addAsViewListener() {
        if (this.attachedView != null) {
            this.attachedView.addPFDViewListener(this);
        }
    }

    private void removeAsViewListener() {
        if (this.attachedView != null) {
            this.attachedView.removePFDViewListener(this);
        }
    }

    @Override
    protected void attachView(PFDView v) {
        super.attachView(v);
        if (v != null) {
            this.attachedView = v;
        }
    }

    @Override
    protected void detachView(PFDView v) {
        super.detachView(v);
        this.attachedView = null;
    }

    private void dragFromLink(MouseEvent e) {
        PFDView v = this.theView;
        switch (this.getComputedRenderMode()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.setRenderMode(2);
                PFDLink link = v.getDraggedLink();
                if (this.portType == 0) {
                    if (this.mouseOverPort != null && link != null) {
                        link.setValidationStatus(6);
                        v.rejectLinkDrag(this.getParentNode(), this.mouseOverPort);
                    }
                    this.setHighlightPort(null);
                    break;
                }
                if (this.mouseOverPort != null && this.mouseOverPort.canDropFromLink(link)) {
                    this.setHighlightPort(this.mouseOverPort);
                    v.snapLinkToPort(this.mouseOverPort);
                    break;
                }
                if (this.mouseOverPort != null) {
                    v.rejectLinkDrag(this.getParentNode(), this.mouseOverPort);
                    this.setHighlightPort(null);
                    break;
                }
                this.setHighlightPort(null);
            }
        }
    }

    private void dragToLink(MouseEvent e) {
        PFDView v = this.theView;
        switch (this.getComputedRenderMode()) {
            case 2: {
                this.setRenderMode(2);
                PFDLink link = v.getDraggedLink();
                if (this.portType == 1) {
                    if (this.mouseOverPort != null && link != null && this.mouseOverPort != link.getFromPort()) {
                        link.setValidationStatus(5);
                        v.rejectLinkDrag(this.getParentNode(), this.mouseOverPort);
                    }
                    this.setHighlightPort(null);
                    break;
                }
                if (this.mouseOverPort != null && this.mouseOverPort.canDropToLink(link)) {
                    this.setHighlightPort(this.mouseOverPort);
                    v.snapLinkToPort(this.mouseOverPort);
                    break;
                }
                if (this.mouseOverPort != null) {
                    v.rejectLinkDrag(this.getParentNode(), this.mouseOverPort);
                    this.setHighlightPort(null);
                    break;
                }
                this.setHighlightPort(null);
            }
        }
    }

    @Override
    public String getToolTipText() {
        if (this.getComputedRenderMode() == 2 && this.mouseOverPort != null) {
            return this.mouseOverPort.getToolTipText();
        }
        return this.toolTipText;
    }

    public void snapLinkToPort(PFDLink link, PFDView view) {
        if (link == null || this.portType == 1) {
            return;
        }
        int validationStatus = -1;
        boolean statusFound = false;
        Iterator portIterator = this.getPortIterator();
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            if (!port.isVisible()) continue;
            if (port.canDropToLink(link)) {
                if (this.canShowPorts()) {
                    this.setRenderMode(2, 0);
                }
                view.snapLinkToPort(port);
                return;
            }
            if (statusFound) continue;
            int status = link.getValidationStatus();
            if (status == 9) {
                validationStatus = status;
                continue;
            }
            if (status == 7) continue;
            validationStatus = status;
            statusFound = true;
        }
        if (validationStatus == -1) {
            link.setValidationStatus(7);
        } else {
            link.setValidationStatus(validationStatus);
        }
        view.rejectLinkDrag(this.getParentNode(), null);
    }

    public void snapLinkFromPort(PFDLink link, PFDView view) {
        if (link == null || this.portType == 0) {
            return;
        }
        int validationStatus = -1;
        boolean statusFound = false;
        Iterator portIterator = this.getPortIterator();
        while (portIterator.hasNext()) {
            PFDPort port = (PFDPort)portIterator.next();
            if (!port.isVisible()) continue;
            if (port.canDropFromLink(link)) {
                if (this.canShowPorts()) {
                    this.setRenderMode(2, 0);
                }
                view.snapLinkToPort(port);
                return;
            }
            if (statusFound) continue;
            int status = link.getValidationStatus();
            if (status == 9) {
                validationStatus = status;
                continue;
            }
            if (status == 8) continue;
            validationStatus = status;
            statusFound = true;
        }
        if (validationStatus == -1) {
            link.setValidationStatus(8);
        } else {
            link.setValidationStatus(validationStatus);
        }
        view.rejectLinkDrag(this.getParentNode(), null);
    }

    private PFDPort getVisiblePort(int index) {
        int count = 0;
        for (int i = 0; i < this.ports.size(); ++i) {
            PFDPort p = (PFDPort)this.ports.get(i);
            if (!p.isVisible()) continue;
            if (index == count) {
                return p;
            }
            ++count;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        this.mouseOverPort = this.getMouseOverPort(e.getX(), e.getY());
        PFDView v = this.theView;
        this.attachView(v);
        v.setMouseOverPrimitive(this, e);
        this.portPressed(this.mouseOverPort, e);
        if (this.portType == 0) {
            return;
        }
        if (v.getMouseExtendedMode() == 4) {
            return;
        }
        if (!this.hasValidInteractivePort() || !this.theView.isEditMode()) {
            return;
        }
        switch (this.getComputedRenderMode()) {
            case 0: {
                break;
            }
            case 1: {
                PFDPort port;
                if (this.numVisiblePorts != 1 || !(port = this.getVisiblePort(0)).canDragNewLink()) break;
                if (v.getMouseExtendedMode() == 2) {
                    v.dragNewLink(port, true);
                    break;
                }
                v.dragNewLink(port, false);
                break;
            }
            case 2: {
                if (this.mouseOverPort == null || !this.mouseOverPort.canDragNewLink()) break;
                this.addAsViewListener();
                if (v.getMouseExtendedMode() == 2) {
                    v.dragNewLink(this.mouseOverPort, true);
                    break;
                }
                v.dragNewLink(this.mouseOverPort, false);
            }
        }
    }

    protected void portPressed(PFDPort port, MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int rMode = this.getComputedRenderMode();
        if (this.ports.isEmpty() || this.portType == 0 && rMode == 0) {
            return;
        }
        e.consume();
        this.mouseOverPort = this.getMouseOverPort(e.getX(), e.getY());
        PFDView v = this.theView;
        this.attachView(v);
        v.setMouseOverPrimitive(this, e);
        if (this.portType == 0) {
            return;
        }
        if (!this.hasValidInteractivePort()) {
            return;
        }
        switch (rMode) {
            case 0: {
                if (this.numVisiblePorts == 1 && !this.showSinglePort) {
                    if (!this.theView.isEditMode()) break;
                    this.setRenderMode(1);
                    PFDPort port = this.getVisiblePort(0);
                    if (!port.canDragNewLink()) break;
                    v.setCursor(2);
                    break;
                }
                this.setRenderMode(2);
                break;
            }
            case 1: {
                if (this.numVisiblePorts == 1 && !this.showSinglePort) {
                    if (!this.theView.isEditMode()) break;
                    this.setRenderMode(1);
                    PFDPort port = this.getVisiblePort(0);
                    if (!port.canDragNewLink()) break;
                    v.setCursor(2);
                    break;
                }
                this.setRenderMode(2);
                break;
            }
            case 2: {
                this.setRenderMode(2);
                if (!this.theView.isEditMode()) break;
                if (this.mouseOverPort != null && this.mouseOverPort.canDragNewLink()) {
                    this.setHighlightPort(this.mouseOverPort);
                    v.setCursor(2);
                    break;
                }
                this.setHighlightPort(null);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ports.isEmpty()) {
            return;
        }
        e.consume();
        this.mouseOverPort = this.getMouseOverPort(e.getX(), e.getY());
        PFDView v = this.theView;
        this.attachView(v);
        v.setMouseOverPrimitive(this, e);
        int mode = v.getDragMode();
        if (!this.hasValidInteractivePort() || !this.theView.isEditMode()) {
            return;
        }
        switch (mode) {
            case 2: {
                this.dragFromLink(e);
                break;
            }
            case 1: 
            case 3: {
                this.dragToLink(e);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOverPort = null;
        this.setHighlightPort(null);
        this.setRenderMode(0);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setImmediateRenderMode(this.timedRenderMode);
    }

    @Override
    public void viewChanged(PFDViewEvent e) {
        if (e.getType() == 1) {
            this.setHoldRenderMode(true);
        } else if (e.getType() == 2) {
            this.removeAsViewListener();
            this.setHoldRenderMode(false);
            this.setRenderMode(0);
        }
    }

    @Override
    protected void update(String property, PFDView v) {
        if (this.isLayoutRequired(property)) {
            this.layoutChildren();
        }
        if (property.equals("renderMode") || property.equals("highlightPort")) {
            v.setCleanBufferDirty();
        }
        super.update(property, v);
    }

    @Override
    protected void update(PFDPropertyChangeCache cache, PFDView v) {
        if (this.isLayoutRequired(cache)) {
            this.layoutChildren();
        }
        if (cache.containsProperty("renderMode") || cache.containsProperty("highlightPort")) {
            v.setCleanBufferDirty();
        }
        super.update(cache, v);
    }

    private boolean isLayoutRequired(String property) {
        if (property == null) {
            return false;
        }
        return layoutProperties.contains(property);
    }

    private boolean isLayoutRequired(PFDPropertyChangeCache cache) {
        if (cache == null || cache.isEmpty()) {
            return false;
        }
        for (int i = 0; i < layoutProperties.size(); ++i) {
            String property = (String)layoutProperties.get(i);
            if (!cache.containsProperty(property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("visible".equals(evt.getPropertyName())) {
            if (evt.getSource() instanceof PFDPort) {
                PFDPort port = (PFDPort)evt.getSource();
                this.numVisiblePorts = port.isVisible() ? ++this.numVisiblePorts : --this.numVisiblePorts;
                this.layoutChildren();
            } else if (evt.getSource() instanceof PFDLink) {
                this.layoutChildren();
            }
        } else if ("links".equals(evt.getPropertyName()) && evt.getSource() instanceof PFDPort) {
            PFDPort port = (PFDPort)evt.getSource();
            this.removeLinkListeners(port);
            this.addLinkListeners(port);
            if (this.theView != null) {
                int mode = this.theView.getDragMode();
                if (!this.holdRenderMode && mode != 2 && mode != 1 && mode != 3) {
                    this.layoutChildren();
                }
            }
        }
    }

    public void setShowSinglePort(boolean showSinglePort) {
        if (this.showSinglePort == showSinglePort) {
            return;
        }
        this.showSinglePort = showSinglePort;
        this.firePropertyChange("showSinglePort");
    }

    public boolean isShowSinglePort() {
        return this.showSinglePort;
    }

    public boolean canShowPorts() {
        return this.numVisiblePorts != 0 && (this.numVisiblePorts != 1 || this.showSinglePort);
    }

    private PFDAbstractNode getParentNode() {
        PFDGroup g;
        for (g = this.group; g != null && !(g instanceof PFDAbstractNode); g = g.getGroup()) {
        }
        return (PFDAbstractNode)g;
    }

    public Color getPortColor() {
        return this.portColor;
    }

    public void setPortColor(Color c) {
        if (c == null || c.equals(this.portColor)) {
            return;
        }
        Color oldColor = this.portColor;
        this.portColor = c;
        this.computePortColors();
        this.firePropertyChange("portColor", oldColor, this.portColor);
    }

    private void computePortColors() {
        this.portHighlightColor = PFDUtil.darker(this.portColor, 0.075f);
        this.portFullColor = PFDUtil.darker(this.portColor, 0.2f);
        this.portFullColor = PFDUtil.sharper(this.portFullColor, 0.75);
    }

    protected int getNumLayoutPorts() {
        return this.numVisiblePorts;
    }

    protected int getNumCenteredPorts() {
        return this.numVisiblePorts;
    }

    protected Iterator getPortIterator() {
        return this.ports.iterator();
    }

    protected Iterator getVisiblePortIterator() {
        return new VisiblePortIterator();
    }

    private class VisiblePortIterator
    implements Iterator {
        private int cursor = 0;

        @Override
        public boolean hasNext() {
            return this.cursor < PFDPortGroup.this.visiblePorts.size();
        }

        public Object next() {
            return PFDPortGroup.this.visiblePorts.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

