/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDOverview;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.RB;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PFDPort
extends PFDDrawablePrimitive
implements PropertyInterface {
    private static final long serialVersionUID = -874860924538139191L;
    public static final String RB_KEY = "PFDPort.";
    protected int type = 6;
    protected double fromDirection = 0.0;
    protected double toDirection = Math.PI;
    protected int fromSpot = 4;
    protected int toSpot = 8;
    protected int freeSpotOffsetX = 0;
    protected int freeSpotOffsetY = 0;
    protected int endSegmentLength = 15;
    protected boolean validToPort = true;
    protected boolean validFromPort = true;
    protected Vector links = new Vector();
    protected PFDPrimitive primitive;
    protected transient Shape shape;
    protected int snapRadius = 20;
    protected boolean snapBox = false;
    protected int snapDistX = 20;
    protected int snapDistY = 20;
    protected Rectangle customPortArea = null;
    protected boolean freeSpotBox = false;
    protected int nodeShape = 2;
    protected boolean validInteractiveToPort = true;
    protected boolean validInteractiveFromPort = true;
    protected int maxNumLinks = Integer.MAX_VALUE;
    protected String[] supportedOutputTypes;
    protected String[] supportedInputTypes;
    private int collapsedLinkCount = 0;
    protected boolean isControl = false;
    private transient Area clipArea = null;
    protected transient PropertyList pending = null;

    public PFDPort() {
        this(false);
    }

    public PFDPort(boolean isControl) {
        this.isControl = isControl;
        if (isControl) {
            this.maxNumLinks = 1;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pending = new PropertyList();
    }

    public PFDPort(Point p, Dimension size) {
        super(p, size);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pending = new PropertyList();
    }

    public PFDPort(Rectangle r) {
        super(r);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pending = new PropertyList();
    }

    public boolean setIsControl(boolean isControl) {
        if (this.isControl == isControl) {
            return true;
        }
        if (!this.links.isEmpty()) {
            return false;
        }
        this.isControl = isControl;
        return true;
    }

    public boolean isControl() {
        return this.isControl;
    }

    public int getNumLinks() {
        return this.links.size();
    }

    public int getNumVisibleLinks() {
        int count = 0;
        for (int i = 0; i < this.links.size(); ++i) {
            PFDLink l = (PFDLink)this.links.get(i);
            if (l == null || !l.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void setMaxNumLinks(int maxLinks) {
        if (this.links.size() > maxLinks) {
            return;
        }
        this.maxNumLinks = maxLinks;
    }

    public int getMaxNumLinks() {
        return this.maxNumLinks;
    }

    public boolean isFull() {
        return this.links.size() - this.collapsedLinkCount >= this.maxNumLinks;
    }

    public boolean hasNoLinks() {
        return this.links.isEmpty();
    }

    public boolean hasNoVisibleLinks() {
        return this.getNumVisibleLinks() == 0;
    }

    public PFDLink getLink(int index) {
        if (index >= 0 && index < this.links.size()) {
            return (PFDLink)this.links.elementAt(index);
        }
        return null;
    }

    public Vector getFromLinks() {
        Vector<PFDLink> froms = new Vector<PFDLink>();
        for (int i = 0; i < this.getNumLinks(); ++i) {
            PFDLink l = this.getLink(i);
            if (l.getFromPort() != this) continue;
            froms.addElement(l);
        }
        return froms;
    }

    public Vector getToLinks() {
        Vector<PFDLink> tos = new Vector<PFDLink>();
        for (int i = 0; i < this.getNumLinks(); ++i) {
            PFDLink l = this.getLink(i);
            if (l.getToPort() != this) continue;
            tos.addElement(l);
        }
        return tos;
    }

    public void addLink(PFDLink link) {
        if (!link.isCollapsed() && this.isFull()) {
            return;
        }
        this.links.addElement(link);
        if (link.isCollapsed) {
            ++this.collapsedLinkCount;
        }
        if (this.getModel() == null) {
            this.model = link.getModel();
        }
        this.firePropertyChange("links");
    }

    public void removeLink(PFDLink link) {
        this.links.removeElement(link);
        if (link.isCollapsed()) {
            --this.collapsedLinkCount;
        }
        this.firePropertyChange("links");
    }

    public void removeAllLinks() {
        this.links.removeAllElements();
        this.collapsedLinkCount = 0;
        this.firePropertyChange("links");
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.type == type) {
            return;
        }
        this.checkType(type);
        this.type = type;
        this.firePropertyChange("type");
    }

    private void checkType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "type.ex.txt"));
            }
        }
    }

    public double getFromLinkDirection() {
        if (this.fromSpot == 9) {
            return Double.NaN;
        }
        return this.fromDirection;
    }

    public void setFromLinkDirection(double direction) {
        if (this.fromDirection == direction) {
            return;
        }
        this.fromDirection = direction;
        this.firePropertyChange("fromLinkDirection");
    }

    public double getToLinkDirection() {
        if (this.toSpot == 9) {
            return Double.NaN;
        }
        return this.toDirection;
    }

    public void setToLinkDirection(double direction) {
        if (this.toDirection == direction) {
            return;
        }
        this.toDirection = direction;
        this.firePropertyChange("toLinkDirection");
    }

    public int getFromLinkSpot() {
        return this.fromSpot;
    }

    public void setFromLinkSpot(int spot) {
        if (this.fromSpot == spot) {
            return;
        }
        PFDPort.checkSpot(spot);
        this.fromSpot = spot;
        this.firePropertyChange("fromLinkSpot");
    }

    public int getToLinkSpot() {
        return this.toSpot;
    }

    public void setToLinkSpot(int spot) {
        if (this.toSpot == spot) {
            return;
        }
        PFDPort.checkSpot(spot);
        this.toSpot = spot;
        this.firePropertyChange("toLinkSpot");
    }

    public void getFromLinkPoint(Point p) {
        this.getSpotLocation(this.fromSpot, p);
    }

    public void getToLinkPoint(Point p) {
        this.getSpotLocation(this.toSpot, p);
    }

    public void getLinkPointFromPoint(Point aPoint, Point linkPoint) {
        this.getSpotLocation(0, linkPoint);
        int dx = aPoint.x - linkPoint.x;
        int dy = aPoint.y - linkPoint.y;
        if (this.clipArea != null) {
            int lineDy;
            int lineDx;
            Area intersection = new Area(this.clipArea);
            intersection.transform(AffineTransform.getTranslateInstance(this.bbox.x, this.bbox.y));
            if (dx == 0) {
                lineDx = 1;
                lineDy = 0;
            } else if (dy == 0) {
                lineDx = 0;
                lineDy = 1;
            } else {
                int slope = dy / dx;
                if (slope >= 1) {
                    lineDx = 1;
                    lineDy = 0;
                } else {
                    lineDx = 0;
                    lineDy = 1;
                }
            }
            GeneralPath line = new GeneralPath();
            line.moveTo(aPoint.x, aPoint.y);
            line.lineTo(linkPoint.x, linkPoint.y);
            line.lineTo(aPoint.x + lineDx, aPoint.y + lineDy);
            line.closePath();
            Area lineArea = new Area(line);
            intersection.intersect(lineArea);
            Rectangle2D intersectBounds = intersection.getBounds2D();
            if (!intersectBounds.isEmpty()) {
                double xIntersect = dx > 0 ? intersectBounds.getMaxX() : (double)((int)intersectBounds.getMinX());
                double yIntersect = dy > 0 ? (double)((int)intersectBounds.getMaxY()) : (double)((int)intersectBounds.getMinY());
                linkPoint.setLocation(xIntersect, yIntersect);
            }
        } else if (this.freeSpotBox) {
            if (dx == 0) {
                if (dy > 0) {
                    linkPoint.y += this.freeSpotOffsetY;
                } else if (dy < 0) {
                    linkPoint.y -= this.freeSpotOffsetY;
                }
                return;
            }
            if (dy == 0) {
                if (dx > 0) {
                    linkPoint.x += this.freeSpotOffsetX;
                } else if (dx < 0) {
                    linkPoint.x -= this.freeSpotOffsetX;
                }
                return;
            }
            double dxdyRatio = Math.abs((double)dx) / Math.abs((double)dy);
            double boxRatio = (double)this.freeSpotOffsetX / (double)this.freeSpotOffsetY;
            int xOffset = this.freeSpotOffsetX;
            int yOffset = this.freeSpotOffsetY;
            if (dxdyRatio > boxRatio) {
                if (dx < 0) {
                    xOffset = -this.freeSpotOffsetX;
                }
                yOffset = xOffset * dy / dx;
            } else {
                if (dy < 0) {
                    yOffset = -this.freeSpotOffsetY;
                }
                xOffset = yOffset * dx / dy;
            }
            linkPoint.x += xOffset;
            linkPoint.y += yOffset;
        } else if (this.nodeShape == 4) {
            if (dx == 0) {
                if (dy > 0) {
                    linkPoint.y += this.freeSpotOffsetY + 1;
                } else if (dy < 0) {
                    linkPoint.y -= this.freeSpotOffsetY + 1;
                }
                return;
            }
            if (dy == 0) {
                if (dx > 0) {
                    linkPoint.x += (int)((double)this.freeSpotOffsetX / 2.0 + 1.0);
                } else if (dx < 0) {
                    linkPoint.x -= (int)((double)this.freeSpotOffsetX / 2.0 + 1.0);
                }
                return;
            }
            Point topCenter = new Point(linkPoint.x, linkPoint.y - this.freeSpotOffsetY);
            Point bottomLeft = new Point(linkPoint.x - this.freeSpotOffsetX, linkPoint.y + this.freeSpotOffsetY);
            Point bottomRight = new Point(linkPoint.x + this.freeSpotOffsetX, linkPoint.y + this.freeSpotOffsetY);
            Point intersectionPoint = null;
            intersectionPoint = dx < 0 ? this.getIntersectionPoint(new Line2D.Double(aPoint, linkPoint), new Line2D.Double(bottomLeft, topCenter)) : this.getIntersectionPoint(new Line2D.Double(aPoint, linkPoint), new Line2D.Double(bottomRight, topCenter));
            if (intersectionPoint == null) {
                double dxdyRatio = Math.abs((double)dx) / Math.abs((double)dy);
                double boxRatio = (double)this.freeSpotOffsetX / (double)this.freeSpotOffsetY;
                int xOffset = this.freeSpotOffsetX;
                int yOffset = this.freeSpotOffsetY + 1;
                if (dxdyRatio > boxRatio) {
                    if (dx < 0) {
                        xOffset = -this.freeSpotOffsetX;
                    }
                    yOffset = (int)((double)xOffset * 1.0 / dxdyRatio);
                } else {
                    if (dy < 0) {
                        yOffset = -this.freeSpotOffsetY;
                    }
                    xOffset = (int)((double)yOffset * dxdyRatio);
                }
                linkPoint.x += xOffset;
                linkPoint.y += yOffset;
                return;
            }
            double height = (double)bottomLeft.y - (double)topCenter.y;
            double halfWidth = (double)topCenter.x - (double)bottomLeft.x;
            double hyp = Math.hypot(Math.abs(intersectionPoint.y - topCenter.y), Math.abs(intersectionPoint.x - topCenter.x));
            double theta = Math.atan(height / halfWidth);
            linkPoint.x = dx < 0 ? (int)((double)linkPoint.x - (double)((int)hyp) * Math.cos(theta)) : (linkPoint.x += (int)Math.ceil(hyp * Math.cos(theta)));
            linkPoint.y = (int)((double)topCenter.y + hyp * Math.sin(theta));
        } else {
            if (dx == 0) {
                if (dy > 0) {
                    linkPoint.y += this.freeSpotOffsetY;
                } else if (dy < 0) {
                    linkPoint.y -= this.freeSpotOffsetY;
                }
                return;
            }
            if (dy == 0) {
                if (dx > 0) {
                    linkPoint.x += this.freeSpotOffsetX;
                } else if (dx < 0) {
                    linkPoint.x -= this.freeSpotOffsetX;
                }
                return;
            }
            double theta = Math.atan((double)dy / (double)dx);
            double radius = (double)(this.freeSpotOffsetX * this.freeSpotOffsetY) / Math.sqrt(Math.pow((double)this.freeSpotOffsetY * Math.cos(theta), 2.0) + Math.pow((double)this.freeSpotOffsetX * Math.sin(theta), 2.0));
            if (dx < 0) {
                linkPoint.x -= (int)(radius * Math.cos(theta));
                linkPoint.y -= (int)(radius * Math.sin(theta));
            } else {
                linkPoint.x += (int)(radius * Math.cos(theta));
                linkPoint.y += (int)(radius * Math.sin(theta));
            }
        }
    }

    public Point getIntersectionPoint(Line2D.Double line1, Line2D.Double line2) {
        double sy;
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double px = line1.getX1();
        double py = line1.getY1();
        double rx = line1.getX2() - px;
        double ry = line1.getY2() - py;
        double qx = line2.getX1();
        double qy = line2.getY1();
        double sx = line2.getX2() - qx;
        double det = sx * ry - (sy = line2.getY2() - qy) * rx;
        if (det == 0.0) {
            return null;
        }
        double z = (sx * (qy - py) + sy * (px - qx)) / det;
        if (z == 0.0 || z == 1.0) {
            return null;
        }
        return new Point((int)(px + z * rx), (int)(py + z * ry));
    }

    public void getFromLinkPoint(Point aPoint, Point linkPoint) {
        if (this.fromSpot != 9 || aPoint == null) {
            this.getFromLinkPoint(linkPoint);
            return;
        }
        this.getLinkPointFromPoint(aPoint, linkPoint);
    }

    public void getToLinkPoint(Point aPoint, Point linkPoint) {
        if (this.toSpot != 9 || aPoint == null) {
            this.getToLinkPoint(linkPoint);
            return;
        }
        this.getLinkPointFromPoint(aPoint, linkPoint);
    }

    public int getFreeSpotOffsetX() {
        return this.freeSpotOffsetX;
    }

    public void setFreeSpotOffsetX(int offset) {
        if (this.freeSpotOffsetX == offset) {
            return;
        }
        this.freeSpotOffsetX = offset;
        this.firePropertyChange("freeSpotOffsetX");
    }

    public int getFreeSpotOffsetY() {
        return this.freeSpotOffsetY;
    }

    public void setFreeSpotOffsetY(int offset) {
        if (this.freeSpotOffsetY == offset) {
            return;
        }
        this.freeSpotOffsetY = offset;
        this.firePropertyChange("freeSpotOffsetY");
    }

    public int getEndSegmentLength() {
        return this.endSegmentLength;
    }

    public void setEndSegmentLength(int len) {
        if (this.endSegmentLength == len) {
            return;
        }
        this.endSegmentLength = len;
        this.firePropertyChange("endSegmentLength");
    }

    public boolean isValidFromPort() {
        return this.validFromPort;
    }

    public void setValidFromPort(boolean b) {
        if (this.validFromPort == b) {
            return;
        }
        this.validFromPort = b;
        this.firePropertyChange("validFromPort");
    }

    public boolean isValidToPort() {
        return this.validToPort;
    }

    public void setValidToPort(boolean b) {
        if (this.validToPort == b) {
            return;
        }
        this.validToPort = b;
        this.firePropertyChange("validFromPort");
    }

    public boolean isValidInteractiveFromPort() {
        return this.validInteractiveFromPort;
    }

    public void setValidInteractiveFromPort(boolean b) {
        if (this.validInteractiveFromPort == b) {
            return;
        }
        this.validInteractiveFromPort = b;
        this.firePropertyChange("validInteractiveFromPort");
    }

    public boolean isValidInteractiveToPort() {
        return this.validInteractiveToPort;
    }

    public void setValidInteractiveToPort(boolean b) {
        if (this.validInteractiveToPort == b) {
            return;
        }
        this.validInteractiveToPort = b;
        this.firePropertyChange("validInteractiveToPort");
    }

    public void setFreeSpotBox(boolean isBox) {
        if (this.freeSpotBox == isBox) {
            return;
        }
        this.freeSpotBox = isBox;
        this.nodeShape = this.freeSpotBox ? 2 : 5;
        this.firePropertyChange("freeSpotBox");
    }

    public boolean isFreeSpotBox() {
        return this.freeSpotBox;
    }

    public void setNodeShape(int nodeShape) {
        if (this.nodeShape == nodeShape) {
            return;
        }
        this.setFreeSpotBox(nodeShape == 2);
        this.nodeShape = nodeShape;
        this.firePropertyChange("freeSpotBox");
    }

    public int getNodeShape() {
        return this.nodeShape;
    }

    public void setSnapRadius(int radius) {
        if (this.snapRadius == radius) {
            return;
        }
        this.snapRadius = radius;
        this.firePropertyChange("snapRadius");
    }

    public int getSnapRadius() {
        return this.snapRadius;
    }

    public void setSnapBox(boolean isBox) {
        if (this.snapBox == isBox) {
            return;
        }
        this.snapBox = isBox;
        this.firePropertyChange("snapBox");
    }

    public boolean isSnapBox() {
        return this.snapBox;
    }

    public void setSnapXDistance(int dist) {
        if (this.snapDistX == dist) {
            return;
        }
        this.snapDistX = dist;
        this.firePropertyChange("snapDistX");
    }

    public int getSnapXDistance() {
        return this.snapDistX;
    }

    public void setSnapYDistance(int dist) {
        if (this.snapDistY == dist) {
            return;
        }
        this.snapDistY = dist;
        this.firePropertyChange("snapDistY");
    }

    public int getSnapYDistance() {
        return this.snapDistY;
    }

    public boolean snap(int x, int y, PFDView view) {
        Point modelCenter = this.getSpotLocation(0, null);
        Point viewCenter = this.getSpotLocation(0, null);
        view.ModelToView(viewCenter);
        Point viewPoint = new Point(x, y);
        Point modelPoint = new Point(x, y);
        view.ViewToModel(modelPoint);
        if (this.snapBox) {
            Rectangle snapRect = new Rectangle(modelCenter.x - this.snapDistX, modelCenter.y - this.snapDistY, this.snapDistX * 2, this.snapDistY * 2);
            return snapRect.contains(modelPoint);
        }
        double dist = (viewCenter.x - x) * (viewCenter.x - x) + (viewCenter.y - y) * (viewCenter.y - y);
        return (dist = Math.sqrt(dist)) < (double)this.snapRadius;
    }

    public void setCustomPortArea(Rectangle r) {
        this.customPortArea = r;
        this.firePropertyChange("customPortArea");
    }

    @Override
    protected synchronized void render(Graphics2D g2d, PFDView v) {
        switch (this.type) {
            default: {
                if (this.brush.getStyle() != 0) {
                    this.brush.apply(g2d);
                    g2d.fill(this.shape);
                }
                if (this.pen.getStyle() == 0) break;
                this.pen.apply(g2d);
                g2d.draw(this.shape);
            }
            case 0: 
        }
    }

    @Override
    protected synchronized void renderOverview(Graphics2D g2d, PFDView v) {
    }

    @Override
    protected void update(String property, PFDView v) {
        if (v instanceof PFDOverview) {
            return;
        }
        if (property.equals("all") || property.equals("type")) {
            this.shapeChanged();
            this.updateShape();
            this.updateLinks();
        }
        if (property.equals("bbox")) {
            this.updateShape();
            this.updateLinks();
        }
        if (property.equals("endSegmentLength") || property.equals("fromLinkDirection") || property.equals("toLinkDirection") || property.equals("fromLinkSpot") || property.equals("toLinkSpot") || property.equals("freeSpotOffsetX") || property.equals("freeSpotOffsetY") || property.equals("clipArea")) {
            this.updateLinks();
        }
        super.update(property, v);
    }

    protected void updateLinks() {
        for (int i = 0; i < this.links.size(); ++i) {
            PFDLink l = (PFDLink)this.links.elementAt(i);
            l.firePropertyChange("bbox");
        }
    }

    protected void shapeChanged() {
        switch (this.type) {
            default: {
                this.shape = new GeneralPath(0, 3);
                break;
            }
            case 4: {
                this.shape = new GeneralPath(0, 3);
                break;
            }
            case 5: {
                this.shape = new Ellipse2D.Double();
                break;
            }
            case 2: {
                this.shape = new Rectangle2D.Double();
            }
            case 0: 
        }
    }

    protected void updateShape() {
        int width = this.bbox.width - 1;
        int height = this.bbox.height - 1;
        switch (this.type) {
            default: {
                GeneralPath gp = (GeneralPath)this.shape;
                gp.reset();
                gp.moveTo(this.bbox.x + width / 2, this.bbox.y);
                gp.lineTo(this.bbox.x + width, this.bbox.y + height / 2);
                gp.lineTo(this.bbox.x + width / 2, this.bbox.y + height);
                gp.lineTo(this.bbox.x, this.bbox.y + height / 2);
                gp.closePath();
                break;
            }
            case 4: {
                GeneralPath gp = (GeneralPath)this.shape;
                gp.reset();
                gp.moveTo(this.bbox.x, this.bbox.y);
                gp.lineTo(this.bbox.x + width, this.bbox.y + height / 2);
                gp.lineTo(this.bbox.x, this.bbox.y + height);
                gp.closePath();
                break;
            }
            case 5: {
                Ellipse2D.Double e = (Ellipse2D.Double)this.shape;
                e.setFrame(this.bbox.x, this.bbox.y, width, height);
                break;
            }
            case 2: {
                Rectangle2D.Double r = (Rectangle2D.Double)this.shape;
                r.setFrame(this.bbox.x, this.bbox.y, width, height);
            }
            case 0: 
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDPort clone = new PFDPort();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public void copyObject(PFDPort toObject) {
        super.copyObject(toObject);
        toObject.setIsControl(this.isControl());
        toObject.setMaxNumLinks(this.getMaxNumLinks());
        toObject.setType(this.getType());
        toObject.setFromLinkDirection(this.getFromLinkDirection());
        toObject.setToLinkDirection(this.getToLinkDirection());
        toObject.setFromLinkSpot(this.getFromLinkSpot());
        toObject.setToLinkSpot(this.getToLinkSpot());
        toObject.setFreeSpotOffsetX(this.getFreeSpotOffsetX());
        toObject.setFreeSpotOffsetY(this.getFreeSpotOffsetY());
        toObject.setEndSegmentLength(this.getEndSegmentLength());
        toObject.setValidFromPort(this.isValidFromPort());
        toObject.setValidToPort(this.isValidToPort());
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.customPortArea != null) {
            Point center = this.getSpotLocation(0, null);
            Rectangle containsArea = new Rectangle(center.x + this.customPortArea.x, center.y + this.customPortArea.y, this.customPortArea.width, this.customPortArea.height);
            return containsArea.contains(x, y);
        }
        if (this.bbox.height <= 0 || this.bbox.width <= 0) {
            Rectangle rect = new Rectangle(x - 5, y - 5, 11, 11);
            return rect.contains(this.bbox.x, this.bbox.y);
        }
        return super.intersects(x - 5, y - 5, 11, 11);
    }

    @Override
    protected void removeAssociation() {
        PFDModel m = this.getModel();
        if (m != null) {
            Vector tmp = new Vector();
            for (int i = 0; i < this.links.size(); ++i) {
                tmp.addElement(this.links.elementAt(i));
            }
            Enumeration en = tmp.elements();
            while (en.hasMoreElements()) {
                PFDLink link = (PFDLink)en.nextElement();
                m.removePrimitive(link);
            }
        }
    }

    public PFDAbstractNode getParentNode() {
        PFDGroup g;
        for (g = this.group; g != null && !(g instanceof PFDAbstractNode); g = g.getGroup()) {
        }
        return (PFDAbstractNode)g;
    }

    public PFDAbstractNode getTopParentNode() {
        PFDAbstractNode topNode = null;
        for (PFDGroup g = this.group; g != null; g = g.getGroup()) {
            if (!(g instanceof PFDAbstractNode)) continue;
            topNode = (PFDAbstractNode)g;
        }
        return topNode;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            if (!this.selectable) {
                return;
            }
            if (this.theView.isEditMode() && this.canDragNewLink()) {
                if (this.theView.getMouseExtendedMode() == 2) {
                    this.theView.dragNewLink(this, true);
                } else {
                    this.theView.dragNewLink(this, false);
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this) {
            if (!this.selectable) {
                return;
            }
            int mode = this.theView.getDragMode();
            if (this.theView.isEditMode() && mode == 2 && this.canDropFromLink(this.theView.getDraggedLink()) || (mode == 1 || mode == 3) && this.canDropToLink(this.theView.getDraggedLink())) {
                this.theView.snapLinkToPort(this);
            }
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this) {
            if (!this.selectable) {
                return;
            }
            if (this.theView.isEditMode() && this.canDragNewLink()) {
                this.theView.setCursor(2);
            }
            e.consume();
        }
    }

    public boolean canDragNewLink() {
        return this.validFromPort && this.validInteractiveFromPort && !this.isFull();
    }

    public boolean canAcceptNewLink() {
        return this.validToPort && this.validInteractiveToPort && !this.isFull();
    }

    public boolean canDropToLink(PFDLink link) {
        if (link == null) {
            return false;
        }
        if (link.isOriginalLink(link.getFromPort(), this)) {
            return true;
        }
        if (link.getToPort() == this) {
            link.setValidationStatus(0);
            return true;
        }
        if (!this.validToPort) {
            link.setValidationStatus(5);
            return false;
        }
        if (!this.validInteractiveToPort) {
            link.setValidationStatus(7);
            return false;
        }
        if (this.isFull()) {
            link.setValidationStatus(9);
            return false;
        }
        return link.isLinkSupported(link.getFromPort(), this);
    }

    public boolean canDropFromLink(PFDLink link) {
        if (link == null) {
            return false;
        }
        if (link.isOriginalLink(this, link.getToPort())) {
            return true;
        }
        if (link.getFromPort() == this) {
            link.setValidationStatus(0);
            return true;
        }
        if (!this.validFromPort) {
            link.setValidationStatus(6);
            return false;
        }
        if (!this.validInteractiveFromPort) {
            link.setValidationStatus(8);
            return false;
        }
        if (this.isFull()) {
            link.setValidationStatus(9);
            return false;
        }
        return link.isLinkSupported(this, link.getToPort());
    }

    public boolean isLinkSupported(PFDLink link) {
        if (link == null) {
            return false;
        }
        if (this.isControl) {
            return link.isControl();
        }
        return !link.isControl();
    }

    public PFDLink createDragLink() {
        return new PFDLink(this.isControl);
    }

    public String[] getSupportedOutputTypes() {
        return this.supportedOutputTypes;
    }

    public void setSupportedOutputTypes(String[] types) {
        this.supportedOutputTypes = types;
    }

    public String[] getSupportedInputTypes() {
        return this.supportedInputTypes;
    }

    public void setSupportedInputTypes(String[] types) {
        this.supportedInputTypes = types;
    }

    public static boolean isLinkSupported(PFDPort from, PFDPort to) {
        if (from == null || to == null) {
            return true;
        }
        String[] fromTypes = from.getSupportedOutputTypes();
        String[] toTypes = to.getSupportedInputTypes();
        if (fromTypes == null || toTypes == null) {
            return true;
        }
        for (int i = 0; i < fromTypes.length; ++i) {
            if (fromTypes[i] == null) continue;
            for (int j = 0; j < toTypes.length; ++j) {
                if (!fromTypes[i].equals(toTypes[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void setClipArea(Area clipArea) {
        if (this.clipArea == clipArea) {
            return;
        }
        this.clipArea = clipArea;
        this.firePropertyChange("clipArea");
    }

    public Area getClipArea() {
        return this.clipArea;
    }

    public void updateCollapsedLinkCount(boolean linkCollapsed) {
        this.collapsedLinkCount = linkCollapsed ? ++this.collapsedLinkCount : --this.collapsedLinkCount;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.shapeChanged();
        this.updateShape();
        this.pending = new PropertyList();
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 200: {
                return this.isControl;
            }
            case 201: {
                return this.getPFDItemId();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        switch (id) {
            case 200: {
                if (!this.isControl) {
                    return true;
                }
            }
            case 201: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 200: {
                if (!(value instanceof Boolean)) break;
                this.setIsControl((Boolean)value);
                break;
            }
            case 201: {
                if (!(value instanceof String)) break;
                this.setPFDItemId((String)value);
            }
        }
    }
}

