/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDDrawableLabel;
import com.sas.graphics.components.pfd.PFDPen;
import com.sas.graphics.components.pfd.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PFDPenCustomizerPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "PFDPenCustomizerPanel.";
    PFDPen pen;
    JComboBox lineStyle;
    JComboBox lineWidth;
    JLabel lineColorPreview;
    JButton lineColor;

    public PFDPenCustomizerPanel(PFDPen pen) {
        this.pen = pen;
        this.setLayout(new BoxLayout(this, 1));
        JPanel linePanel1 = new JPanel(new BorderLayout());
        JLabel lineStyleLabel = new JLabel(RB.getStringResource(RB_KEY, "style.txt"));
        lineStyleLabel.setPreferredSize(new Dimension(100, lineStyleLabel.getPreferredSize().height));
        String[] lineStyles = new String[]{"Solid Line", "Dashed Line", "No Line"};
        this.lineStyle = new JComboBox<String>(lineStyles);
        this.lineStyle.setRenderer(new PFDDrawableLabel());
        this.lineStyle.addActionListener(this);
        linePanel1.add((Component)lineStyleLabel, "West");
        linePanel1.add((Component)this.lineStyle, "Center");
        JPanel linePanel2 = new JPanel(new BorderLayout());
        JLabel lineWidthLabel = new JLabel(RB.getStringResource(RB_KEY, "width.txt"));
        lineWidthLabel.setPreferredSize(new Dimension(100, lineWidthLabel.getPreferredSize().height));
        String[] lineWidths = new String[]{"Line 1", "Line 2", "Line 3", "Line 4"};
        this.lineWidth = new JComboBox<String>(lineWidths);
        this.lineWidth.setRenderer(new PFDDrawableLabel());
        this.lineWidth.addActionListener(this);
        linePanel2.add((Component)lineWidthLabel, "West");
        linePanel2.add((Component)this.lineWidth, "Center");
        JPanel linePanel3 = new JPanel(new BorderLayout());
        JLabel lineColorLabel = new JLabel(RB.getStringResource(RB_KEY, "color.txt"));
        lineColorLabel.setPreferredSize(new Dimension(100, lineColorLabel.getPreferredSize().height));
        JPanel lineColorPanel = new JPanel(new BorderLayout());
        this.lineColorPreview = new JLabel();
        this.lineColorPreview.setOpaque(true);
        this.lineColorPreview.setBorder(new BevelBorder(1));
        this.lineColor = new JButton("...");
        this.lineColor.setPreferredSize(new Dimension(this.lineColor.getPreferredSize().height, this.lineColor.getPreferredSize().height));
        this.lineColor.addActionListener(this);
        lineColorPanel.add((Component)this.lineColorPreview, "Center");
        lineColorPanel.add((Component)this.lineColor, "East");
        linePanel3.add((Component)lineColorLabel, "West");
        linePanel3.add((Component)lineColorPanel, "Center");
        this.add(linePanel1);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(linePanel2);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(linePanel3);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(RB_KEY, "line.txt")));
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        switch (this.pen.getStyle()) {
            case 1: {
                this.lineStyle.setSelectedItem("Solid Line");
                break;
            }
            case 2: {
                this.lineStyle.setSelectedItem("Dashed Line");
                break;
            }
            case 0: {
                this.lineStyle.setSelectedItem("No Line");
            }
        }
        this.lineWidth.setSelectedIndex((int)this.pen.getLineWidth() - 1);
        this.lineColorPreview.setBackground(this.pen.getColor());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.lineColor) {
            Color newColor = JColorChooser.showDialog(this, RB.getStringResource(RB_KEY, "colorDialog.txt"), this.pen.getColor());
            this.pen.setColor(newColor);
            this.lineColorPreview.setBackground(newColor);
        }
        if (e.getSource() == this.lineWidth) {
            int w = this.lineWidth.getSelectedIndex();
            this.pen.setLineWidth(w + 1);
        }
        if (e.getSource() == this.lineStyle) {
            String s = (String)this.lineStyle.getSelectedItem();
            if (s.equals("Solid Line")) {
                this.pen.setStyle(1);
            }
            if (s.equals("Dashed Line")) {
                this.pen.setStyle(2);
            }
            if (s.equals("No Line")) {
                this.pen.setStyle(0);
            }
        }
    }
}

