/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.AffineTransform;

public class PFDPathDiagramView
extends PFDView {
    private Insets outerMargin = new Insets(0, 0, 0, 0);

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
    }

    @Override
    protected void xfmChanged() {
        Dimension ms;
        this.currentXfm = new AffineTransform();
        int vw = this.getWidth() - this.outerMargin.left - this.outerMargin.right;
        int vh = this.getHeight() - this.outerMargin.top - this.outerMargin.bottom;
        if (this.userSetAlwaysCropAndScaleToFit) {
            ms = this.model.getSize();
            int w = ms.width + 1;
            int h = ms.height + 1;
            double sx = (double)vw / (double)w;
            double sy = (double)vh / (double)h;
            double s = Math.min(sx, sy);
            this.currentXfm.scale(s, s);
            this.currentXfm.translate(((double)vw - s * (double)w) / 2.0 / s, ((double)vh - s * (double)h) / 2.0 / s);
        } else if (this.scaleToFit) {
            ms = this.model.getSize();
            int w = ms.width + 1;
            int h = ms.height + 1;
            double sx = (double)vw / (double)w;
            double sy = (double)vh / (double)h;
            double s = Math.min(sx, sy);
            this.currentXfm.scale(s, s);
        } else if (this.zoomAtCenter) {
            this.currentXfm.translate(vw / 2, vh / 2);
            this.currentXfm.scale(this.scale, this.scale);
            this.currentXfm.translate(this.translateX - (double)(vw / 2), this.translateY - (double)(vh / 2));
        } else {
            this.currentXfm.scale(this.scale, this.scale);
            this.currentXfm.translate(this.translateX, this.translateY);
        }
        if (this.pfdAnnoComponent != null) {
            this.pfdAnnoComponent.getPFDAnnotate().setDirty();
        }
        if (this.backLayerAnnotate != null) {
            this.backLayerAnnotate.setDirty();
        }
        if (this.outerMargin.left > 0 || this.outerMargin.top > 0) {
            AffineTransform af = new AffineTransform();
            af.translate(this.outerMargin.left, this.outerMargin.top);
            this.currentXfm.preConcatenate(af);
        }
    }

    public boolean isSGEditor() {
        return this.isSGEditor;
    }

    public void setSGEditor(boolean isSGEditor) {
        this.isSGEditor = isSGEditor;
    }

    public PFDSelectionList getSelectedList() {
        return this.selected;
    }

    public PFDAbstractNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(PFDAbstractNode selectedNode) {
        this.selectedNode = selectedNode;
    }
}

